/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.ui.contentassist;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectPackage;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.smartmdsd.xtext.service.communicationObject.ui.contentassist.AbstractCommunicationObjectProposalProvider;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class CommunicationObjectProposalProvider extends AbstractCommunicationObjectProposalProvider {
  @Inject
  private XtextResourceIndex index;
  
  @Override
  public void completeCommObjectsRepository_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final URI uri = model.eResource().getURI();
    boolean _isPlatform = uri.isPlatform();
    if (_isPlatform) {
      final String projectName = uri.segment(1);
      acceptor.accept(this.createCompletionProposal(projectName, (projectName + " - ProjectName"), this.getImage(model), context));
    }
  }
  
  @Override
  public void completeCommRepositoryImport_ImportedNamespace(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final Iterable<IEObjectDescription> repos = this.index.getVisibleEObjectDescriptions(model, CommunicationObjectPackage.eINSTANCE.getCommObjectsRepository());
    final Consumer<IEObjectDescription> _function = (IEObjectDescription repo) -> {
      final String name = repo.getName().toString();
      final String text = (name + ".*;");
      acceptor.accept(this.createCompletionProposal(text, (name + " - CommRepositoryImport"), this.getImage(repo), context));
    };
    repos.forEach(_function);
  }
  
  @Override
  public void completeVersion_Major(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    acceptor.accept(this.createCompletionProposal("1.0", "1.0 - Version", this.getImage(model), context));
  }
  
  @Override
  public void completeSingleValue_Value(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    EObject attr = model;
    if ((model instanceof ArrayValue)) {
      attr = ((ArrayValue)model).eContainer();
    }
    if ((attr instanceof AttributeDefinition)) {
      final AbstractAttributeType type = ((AttributeDefinition)attr).getType();
      if ((type instanceof CommElementReference)) {
        final AbstractCommElement id = ((CommElementReference)type).getTypeName();
        if ((id instanceof Enumeration)) {
          final Consumer<EnumerationElement> _function = (EnumerationElement en) -> {
            String _name = en.getName();
            String _name_1 = en.getName();
            String _plus = (_name_1 + " - EnumLiteral");
            acceptor.accept(this.createCompletionProposal(_name, _plus, this.getImage(en), context));
          };
          ((Enumeration)id).getEnums().forEach(_function);
        } else {
          if ((id instanceof CommunicationObject)) {
            String _name = ((CommunicationObject)id).getName();
            String _plus = (_name + "()");
            String _name_1 = ((CommunicationObject)id).getName();
            String _plus_1 = (_name_1 + " - CommunicationObject");
            acceptor.accept(this.createCompletionProposal(_plus, _plus_1, this.getImage(id), context));
          }
        }
      } else {
        super.completeSingleValue_Value(model, assignment, context, acceptor);
      }
    }
  }
}
