/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectModel;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommRepositoryImport;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectPackage;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2.BasicAttributesFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CommunicationObjectFormatter
extends BasicAttributesFormatter {
    protected void _format(CommObjectModel commObjectModel, @Extension IFormattableDocument document) {
        EList _imports = commObjectModel.getImports();
        for (CommRepositoryImport commRepositoryImport : _imports) {
            document.format((Object)commRepositoryImport);
            Procedures.Procedure1 _function = it -> it.newLine();
            document.append((EObject)commRepositoryImport, _function);
        }
        CommObjectsRepository _repository = commObjectModel.getRepository();
        if (_repository != null) {
            document.format((Object)_repository);
        }
    }

    protected void _format(CommObjectsRepository commObjectsRepository, @Extension IFormattableDocument document) {
        document.format((Object)commObjectsRepository.getVersion());
        ISemanticRegion ropen = this.textRegionExtensions.regionFor((EObject)commObjectsRepository).keyword("{");
        ISemanticRegion rclose = this.textRegionExtensions.regionFor((EObject)commObjectsRepository).keyword("}");
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend(ropen, _function);
        Procedures.Procedure1 _function_1 = it -> it.newLine();
        document.append(ropen, _function_1);
        Procedures.Procedure1 _function_2 = it -> it.indent();
        document.interior(ropen, rclose, _function_2);
        EList _elements = commObjectsRepository.getElements();
        for (AbstractCommElement abstractCommElement : _elements) {
            document.format((Object)abstractCommElement);
            Procedures.Procedure1 _function_3 = it -> it.oneSpace();
            document.surround(this.textRegionExtensions.regionFor((EObject)abstractCommElement).feature((EStructuralFeature)CommunicationObjectPackage.Literals.ABSTRACT_COMM_ELEMENT__NAME), _function_3);
            Procedures.Procedure1 _function_4 = it -> it.setNewLines(1, 1, 2);
            document.append((EObject)abstractCommElement, _function_4);
            ISemanticRegion open = this.textRegionExtensions.regionFor((EObject)abstractCommElement).keyword("{");
            ISemanticRegion close = this.textRegionExtensions.regionFor((EObject)abstractCommElement).keyword("}");
            Procedures.Procedure1 _function_5 = it -> it.newLine();
            document.append(open, _function_5);
            Procedures.Procedure1 _function_6 = it -> it.indent();
            document.interior(open, close, _function_6);
        }
    }

    public void format(Object commObjectsRepository, IFormattableDocument document) {
        if (commObjectsRepository instanceof XtextResource) {
            this._format((XtextResource)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository instanceof AttributeDefinition) {
            this._format((AttributeDefinition)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository instanceof AttributeRefinement) {
            this._format((AttributeRefinement)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository instanceof InlineEnumerationType) {
            this._format((InlineEnumerationType)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository instanceof CommObjectsRepository) {
            this._format((CommObjectsRepository)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository instanceof CommObjectModel) {
            this._format((CommObjectModel)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository instanceof EObject) {
            this._format((EObject)commObjectsRepository, document);
            return;
        }
        if (commObjectsRepository == null) {
            this._format(null, document);
            return;
        }
        if (commObjectsRepository != null) {
            this._format(commObjectsRepository, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(commObjectsRepository, document).toString());
    }
}

