/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.resource.IFileGetter;
import org.eclipse.sirius.ext.base.cache.LRUCache;
import org.osgi.framework.Bundle;

public class FileProvider {
    private static FileProvider instance;
    private Map<File, String> file2plugin = new LRUCache(10, 50);
    private Map<File, String> file2path = new LRUCache(10, 50);
    private Map<String, Map<String, List<URL>>> bundleName2mtPaths = new LRUCache(10, 50);
    private Set<IFileGetter> fileGetters = new LinkedHashSet<IFileGetter>();

    public static FileProvider getDefault() {
        if (instance == null) {
            instance = new FileProvider();
        }
        return instance;
    }

    public String getPluginId(File file) {
        return this.file2plugin.get(file);
    }

    public String getRelativePath(File file) {
        return this.file2path.get(file);
    }

    public File getFile(String pluginId, String fullName, String extension) {
        IPath fullPath = new Path(fullName.replaceAll("\\.", "/")).addFileExtension(extension);
        return this.getFile(pluginId, fullPath);
    }

    public File getFile(IPath fullPath) {
        File file = null;
        if (fullPath != null && fullPath.segmentCount() > 0) {
            for (IFileGetter getter : this.fileGetters) {
                file = getter.getFile(fullPath);
                if (file != null) break;
            }
            if (file == null) {
                IFile eclipseFile = FileProvider.findFile(fullPath);
                if (eclipseFile != null) {
                    file = eclipseFile.getLocation().toFile();
                } else {
                    String pluginId = fullPath.segment(0);
                    file = this.getFile(pluginId, fullPath.removeFirstSegments(1));
                }
            }
        }
        return file;
    }

    public void registerFileGetter(IFileGetter fileGetter) {
        this.fileGetters.add(fileGetter);
    }

    public File getFile(String pluginId, IPath relativePath) {
        return this.getFile(pluginId, relativePath, true);
    }

    private File getFile(String pluginId, IPath relativePath, boolean requiredSearch) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        File file = null;
        if (bundle != null) {
            URL url = bundle.getEntry(relativePath.toString());
            if (url == null && "mt".equals(relativePath.getFileExtension()) && relativePath.segmentCount() > 1 && (url = bundle.getEntry(relativePath.removeFirstSegments(1).toString())) == null) {
                url = this.getRuntimeModeURL(bundle, relativePath);
            }
            if (url != null && (file = this.getFileFromUrl(url, pluginId, relativePath, bundle)) != null) {
                return file;
            }
            if (requiredSearch) {
                file = this.getFileFromBundles(relativePath, bundle);
            }
        }
        return file;
    }

    private File getFileFromUrl(URL url, String pluginId, IPath relativePath, Bundle bundle) {
        File file = new File(FileProvider.transformToAbsolutePath(url));
        if (file.exists()) {
            if (!this.file2plugin.containsKey(file)) {
                this.file2plugin.put(file, pluginId);
                this.file2path.put(file, relativePath.toString());
                Enumeration allProperties = bundle.findEntries(relativePath.removeLastSegments(1).toString(), "*.properties", true);
                while (allProperties != null && allProperties.hasMoreElements()) {
                    File propertyFile;
                    URL propertyFileURL = (URL)allProperties.nextElement();
                    if (propertyFileURL == null || !(propertyFile = new File(FileProvider.transformToAbsolutePath(propertyFileURL))).exists()) continue;
                    this.file2plugin.put(propertyFile, pluginId);
                }
            }
            return file;
        }
        return null;
    }

    private File getFileFromBundles(IPath relativePath, Bundle bundle) {
        String requiredBundles = (String)bundle.getHeaders().get("Require-Bundle");
        if (requiredBundles != null) {
            StringTokenizer st = new StringTokenizer(requiredBundles, ",");
            while (st.hasMoreTokens()) {
                File scriptFile;
                String id = st.nextToken().trim();
                int iDot = id.indexOf(59);
                if (iDot > -1) {
                    id = id.substring(0, iDot).trim();
                }
                if (id.length() <= 0 || (scriptFile = this.getFile(id, relativePath, false)) == null) continue;
                return scriptFile;
            }
        }
        return null;
    }

    private URL getRuntimeModeURL(Bundle bundle, IPath relativePath) {
        List<URL> urls;
        Map<String, List<URL>> mtName2mtURLs = this.bundleName2mtPaths.get(bundle.getSymbolicName());
        if (mtName2mtURLs == null) {
            mtName2mtURLs = new HashMap<String, List<URL>>();
            this.bundleName2mtPaths.put(bundle.getSymbolicName(), mtName2mtURLs);
            Enumeration entries = bundle.findEntries("/", "*.mt", true);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    Path path;
                    URL entry = (URL)entries.nextElement();
                    if (entry == null || (path = new Path(entry.getPath())).segmentCount() <= 0) continue;
                    String name = path.lastSegment();
                    List<URL> mt = this.getMTs(mtName2mtURLs, name);
                    mt.add(entry);
                }
            }
        }
        if ((urls = mtName2mtURLs.get(relativePath.lastSegment())) != null) {
            for (URL url : urls) {
                if (url.getPath().indexOf(relativePath.toString()) <= -1) continue;
                return url;
            }
        }
        return null;
    }

    private List<URL> getMTs(Map<String, List<URL>> mtName2mtURLs, String name) {
        List<URL> mt = mtName2mtURLs.get(name);
        if (mt == null) {
            mt = new ArrayList<URL>();
            mtName2mtURLs.put(name, mt);
        }
        return mt;
    }

    public static IResource findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    public static IFile findFile(IPath path) {
        IResource resource = FileProvider.findResource(path);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static String transformToAbsolutePath(URL url) {
        String absolutePath;
        try {
            URL transformedUrl = FileLocator.toFileURL((URL)url);
            File file = new File(transformedUrl.getFile());
            absolutePath = file.getAbsolutePath();
        }
        catch (IOException e) {
            absolutePath = "";
            DslCommonPlugin.getDefault().error(e.getMessage(), e);
        }
        return absolutePath;
    }
}

