/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.delegate.OCLDelegateDomain;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryDelegate
implements QueryDelegate {
    protected final OCLDelegateDomain delegateDomain;
    protected final EClassifier context;
    protected final Map<String, EClassifier> variables;
    protected final String expression;
    private OCLExpression query = null;

    public OCLQueryDelegate(OCLDelegateDomain delegateDomain, EClassifier context, Map<String, EClassifier> variables, String expression) {
        this.delegateDomain = delegateDomain;
        this.context = context;
        this.variables = variables;
        this.expression = expression;
    }

    public void prepare() throws InvocationTargetException {
        OCL ocl = this.delegateDomain.getOCL();
        OCL.Helper helper = ocl.createOCLHelper();
        helper.setContext(this.context);
        if (this.variables != null) {
            Environment environment = helper.getEnvironment();
            OCLFactory oclFactory = environment.getOCLFactory();
            UMLReflection umlReflection = environment.getUMLReflection();
            for (Map.Entry<String, EClassifier> entry : this.variables.entrySet()) {
                Variable variable = oclFactory.createVariable();
                variable.setName(entry.getKey());
                variable.setType((Object)((EClassifier)umlReflection.getOCLType((Object)entry.getValue())));
                environment.addElement(entry.getKey(), variable, true);
            }
        }
        try {
            this.query = helper.createQuery(this.expression);
        }
        catch (ParserException e) {
            throw new InvocationTargetException(e);
        }
    }

    public Object execute(Object target, Map<String, ?> arguments) throws InvocationTargetException {
        String key;
        EClassifier contextType;
        if (this.query == null) {
            this.prepare();
        }
        OCL ocl = this.delegateDomain.getOCL();
        Query oclQuery = ocl.createQuery(this.query);
        EvaluationEnvironment evalEnv = oclQuery.getEvaluationEnvironment();
        Environment env = ocl.getEnvironment();
        if (!TypeUtil.compatibleTypeMatch((Environment)env, (Object)(contextType = (EClassifier)evalEnv.getType(target)), (Object)this.context)) {
            String string = OCLMessages.bind((String)OCLMessages.WrongContextClassifier_ERROR_, (Object)contextType.getName(), (Object)this.context.getName());
            throw new InvocationTargetException(new ParserException(string));
        }
        if (this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                key = entry.getKey();
                if (arguments != null && arguments.containsKey(key)) continue;
                String message = OCLMessages.bind((String)OCLMessages.BadArg_ERROR_, (Object)key);
                throw new InvocationTargetException(new ParserException(message));
            }
        }
        if (arguments != null) {
            for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                EClassifier variableType;
                key = entry.getKey();
                EClassifier eClassifier = variableType = this.variables != null ? this.variables.get(key) : null;
                if (variableType == null) {
                    String message = OCLMessages.bind((String)OCLMessages.ExtraArg_ERROR_, (Object)key);
                    throw new InvocationTargetException(new LookupException(message));
                }
                Object newValue = entry.getValue();
                EClassifier valueType = (EClassifier)evalEnv.getType(newValue);
                if (!TypeUtil.compatibleTypeMatch((Environment)env, (Object)valueType, (Object)variableType)) {
                    String message = OCLMessages.bind((String)OCLMessages.TypeConformanceInit_ERROR_, (Object)key);
                    throw new InvocationTargetException(new ParserException(message));
                }
                evalEnv.replace(key, newValue);
            }
        }
        return oclQuery.evaluate(target);
    }

    public String toString() {
        return "<" + this.delegateDomain.getURI() + ":query> " + this.expression;
    }
}

