/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.language.settings.providers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.ui.newui.StatusMessageLine;
import org.eclipse.cdt.managedbuilder.internal.language.settings.providers.CompilationDatabaseParser;
import org.eclipse.cdt.managedbuilder.internal.ui.language.settings.providers.Messages;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.language.settings.providers.AbstractLanguageSettingProviderOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class CompilationDatabaseParserOptionPage
extends AbstractLanguageSettingProviderOptionPage {
    private boolean fEditable;
    private Text fCompileCommandsPath;
    private StatusMessageLine fStatusLine;
    private Combo fBuildOutputParserCombo;

    public void createControl(Composite parent) {
        this.fEditable = parent.isEnabled();
        CompilationDatabaseParser provider = (CompilationDatabaseParser)this.getProvider();
        Composite composite = this.createCompositeForPageArea(parent);
        this.createCompileCommandsPathInputControl(composite, provider);
        this.createBrowseButton(composite);
        this.createOutputParserCombo(composite);
        this.createExclusionOptions(composite);
        this.createStatusLine(composite, provider);
        this.setControl((Control)composite);
    }

    private Composite createCompositeForPageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.marginRight = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    private void createCompileCommandsPathInputControl(Composite composite, CompilationDatabaseParser provider) {
        Label label = ControlFactory.createLabel((Composite)composite, (String)Messages.CompilationDatabaseParserOptionPage_CompileCommandsPath);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label.setEnabled(this.fEditable);
        this.fCompileCommandsPath = ControlFactory.createTextField((Composite)composite, (int)2052);
        String command = provider.getCompilationDataBasePath().toOSString();
        this.fCompileCommandsPath.setText(command != null ? command : "");
        this.fCompileCommandsPath.setEnabled(this.fEditable);
        this.fCompileCommandsPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = CompilationDatabaseParserOptionPage.this.fCompileCommandsPath.getText();
                CompilationDatabaseParser provider = (CompilationDatabaseParser)CompilationDatabaseParserOptionPage.this.getProvider();
                if (provider.getCompilationDataBasePath() == null || !text.equals(provider.getCompilationDataBasePath().toOSString())) {
                    CompilationDatabaseParser selectedProvider = (CompilationDatabaseParser)CompilationDatabaseParserOptionPage.this.getProviderWorkingCopy();
                    selectedProvider.setCompilationDataBasePath(Path.fromOSString((String)text));
                    CompilationDatabaseParserOptionPage.this.refreshItem((ILanguageSettingsProvider)selectedProvider);
                    CompilationDatabaseParserOptionPage.this.validate();
                }
            }
        });
    }

    private void createBrowseButton(Composite composite) {
        Button button = ControlFactory.createPushButton((Composite)composite, (String)Messages.CompilationDatabaseParserOptionPage_Browse);
        button.setEnabled(this.fEditable);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(CompilationDatabaseParserOptionPage.this.getShell(), 0);
                dialog.setText(Messages.CompilationDatabaseParserOptionPage_ChooseFile);
                String fileName = CompilationDatabaseParserOptionPage.this.fCompileCommandsPath.getText();
                IPath folder = new Path(fileName).removeLastSegments(1);
                dialog.setFilterPath(folder.toOSString());
                String chosenFile = dialog.open();
                if (chosenFile != null) {
                    CompilationDatabaseParserOptionPage.this.fCompileCommandsPath.insert(chosenFile);
                }
            }
        });
    }

    private void createOutputParserCombo(Composite composite) {
        AbstractBuildCommandParser buildParser;
        ICConfigurationDescription configurationDescription = this.getConfigurationDescription();
        ArrayList<AbstractBuildCommandParser> buildParsers = new ArrayList<AbstractBuildCommandParser>();
        if (configurationDescription instanceof ILanguageSettingsProvidersKeeper) {
            List settingProviders = ((ILanguageSettingsProvidersKeeper)configurationDescription).getLanguageSettingProviders();
            for (ILanguageSettingsProvider languageSettingsProvider : settingProviders) {
                if (!(languageSettingsProvider instanceof AbstractBuildCommandParser)) continue;
                buildParser = (AbstractBuildCommandParser)languageSettingsProvider;
                buildParsers.add(buildParser);
            }
        }
        Label parserLabel = ControlFactory.createLabel((Composite)composite, (String)Messages.CompilationDatabaseParserOptionPage_BuildParser);
        GridData gd = new GridData(1);
        gd.horizontalSpan = 2;
        parserLabel.setLayoutData((Object)gd);
        this.fBuildOutputParserCombo = new Combo(composite, 8);
        this.fBuildOutputParserCombo.setEnabled(this.fEditable);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fBuildOutputParserCombo.setLayoutData((Object)gd);
        if (buildParsers.isEmpty()) {
            this.fBuildOutputParserCombo.add(Messages.CompilationDatabaseParserOptionPage_NoBuildOutputParserError);
            this.fBuildOutputParserCombo.select(0);
            this.fBuildOutputParserCombo.setEnabled(false);
            this.fBuildOutputParserCombo.setData(null);
            return;
        }
        int i = 0;
        while (i < buildParsers.size()) {
            buildParser = (AbstractBuildCommandParser)buildParsers.get(i);
            this.fBuildOutputParserCombo.add(buildParser.getName());
            this.fBuildOutputParserCombo.setData(buildParser.getName(), (Object)buildParser);
            if (buildParser.getId().equals(((CompilationDatabaseParser)this.getProvider()).getBuildParserId())) {
                this.fBuildOutputParserCombo.select(i);
                this.fBuildOutputParserCombo.setData((Object)buildParser.getId());
            }
            ++i;
        }
        this.fBuildOutputParserCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractBuildCommandParser parser = (AbstractBuildCommandParser)CompilationDatabaseParserOptionPage.this.fBuildOutputParserCombo.getData(CompilationDatabaseParserOptionPage.this.fBuildOutputParserCombo.getText());
                CompilationDatabaseParser selectedProvider = (CompilationDatabaseParser)CompilationDatabaseParserOptionPage.this.getProviderWorkingCopy();
                String parserId = "";
                if (parser != null) {
                    parserId = parser.getId();
                }
                selectedProvider.setBuildParserId(parserId);
                CompilationDatabaseParserOptionPage.this.fBuildOutputParserCombo.setData((Object)parserId);
                CompilationDatabaseParserOptionPage.this.validate();
            }
        });
    }

    private void createExclusionOptions(Composite parent) {
        final Button keepExclusion = new Button(parent, 32);
        keepExclusion.setText(Messages.CompilationDatabaseParserOptionPage_ExcludeFiles);
        GridData gd = new GridData(1);
        gd.horizontalSpan = 2;
        keepExclusion.setLayoutData((Object)gd);
        keepExclusion.setSelection(((CompilationDatabaseParser)this.getProvider()).getExcludeFiles());
        keepExclusion.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompilationDatabaseParser selectedProvider = (CompilationDatabaseParser)CompilationDatabaseParserOptionPage.this.getProviderWorkingCopy();
                selectedProvider.setExcludeFiles(keepExclusion.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createStatusLine(Composite composite, CompilationDatabaseParser provider) {
        this.fStatusLine = new StatusMessageLine(composite, 16384, 2);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        ILanguageSettingsProvider provider = this.providerTab.getProvider(this.providerId);
        if (provider instanceof CompilationDatabaseParser) {
            CompilationDatabaseParser compilationDatabaseParser = (CompilationDatabaseParser)provider;
            ILanguageSettingsProvider initialProvider = this.providerTab.getInitialProvider(this.providerId);
            if (!(initialProvider instanceof CompilationDatabaseParser && ((CompilationDatabaseParser)initialProvider).getCompilationDataBasePath().equals((Object)compilationDatabaseParser.getCompilationDataBasePath()) && ((CompilationDatabaseParser)initialProvider).getBuildParserId().equals(compilationDatabaseParser.getBuildParserId()) && ((CompilationDatabaseParser)initialProvider).getExcludeFiles() == compilationDatabaseParser.getExcludeFiles())) {
                compilationDatabaseParser.clear();
            }
            if (compilationDatabaseParser.isEmpty()) {
                compilationDatabaseParser.processCompileCommandsFile(monitor, this.getConfigurationDescription());
            }
        }
        super.performApply(monitor);
    }

    private void validate() {
        CompilationDatabaseParser provider;
        if (this.fBuildOutputParserCombo.getData() == null) {
            ((CompilationDatabaseParser)this.getProviderWorkingCopy()).setBuildParserId(null);
        }
        if ((provider = (CompilationDatabaseParser)this.getProvider()).getCompilationDataBasePath() == null || provider.getCompilationDataBasePath().isEmpty() || !Files.exists(Paths.get(provider.getCompilationDataBasePath().toOSString(), new String[0]), new LinkOption[0])) {
            this.fStatusLine.setErrorStatus((IStatus)new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), Messages.CompilationDatabaseParserOptionPage_CompileCommandsPathError));
            return;
        }
        if (provider.getBuildParserId() == null || provider.getBuildParserId().isEmpty()) {
            this.fStatusLine.setErrorStatus((IStatus)new Status(4, ManagedBuilderUIPlugin.getUniqueIdentifier(), Messages.CompilationDatabaseParserOptionPage_BuildOutputParserError));
            return;
        }
        this.fStatusLine.setErrorStatus(Status.OK_STATUS);
    }

    private ICConfigurationDescription getConfigurationDescription() {
        if (this.providerTab.page.isForPrefs()) {
            return null;
        }
        return this.providerTab.getResDesc().getConfiguration().getConfiguration();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validate();
        }
    }
}

