/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TraceControlView;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TracepointsMessages;
import org.eclipse.cdt.dsf.gdb.service.GDBTraceControl_7_2;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl2;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class TraceControlModel {
    private String fDebugSessionId;
    private DsfServicesTracker fServicesTracker;
    private volatile IGDBTraceControl fGDBTraceControl;
    private volatile IGDBTraceControl.ITraceTargetDMContext fTargetContext;
    private TraceControlView fTraceControlView;
    private IDebugContextListener fDebugContextListener = event -> {
        if ((event.getFlags() & 1) != 0) {
            this.updateDebugContext();
        }
    };

    TraceControlModel(TraceControlView view) {
        this.fTraceControlView = view;
        IWorkbenchWindow window = this.fTraceControlView.getSite().getWorkbenchWindow();
        DebugUITools.getDebugContextManager().getContextService(window).addDebugContextListener(this.fDebugContextListener);
        this.updateDebugContext();
    }

    protected void updateContent() {
        if (this.getSession() == null) {
            this.notifyUI(TracepointsMessages.TraceControlView_trace_status_no_debug_session);
            return;
        }
        if (this.fTargetContext == null || this.fGDBTraceControl == null) {
            this.notifyUI(TracepointsMessages.TraceControlView_trace_status_not_supported);
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null) {
                    TraceControlModel.this.fGDBTraceControl.getTraceStatus(TraceControlModel.this.fTargetContext, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceStatusDMData>((Executor)TraceControlModel.this.getSession().getExecutor(), null){

                        protected void handleCompleted() {
                            if (this.isSuccess() && this.getData() != null) {
                                TraceControlModel.this.notifyUI((IGDBTraceControl.ITraceStatusDMData2)this.getData());
                            } else {
                                TraceControlModel.this.notifyUI(null);
                            }
                        }
                    });
                } else {
                    TraceControlModel.this.notifyUI(null);
                }
            }
        });
    }

    public void init() {
        if (this.fDebugSessionId != null) {
            this.debugSessionChanged();
        } else {
            this.updateDebugContext();
        }
    }

    public void dispose() {
        IWorkbenchWindow window = this.fTraceControlView.getSite().getWorkbenchWindow();
        DebugUITools.getDebugContextManager().getContextService(window).removeDebugContextListener(this.fDebugContextListener);
        this.setDebugContext(null);
    }

    protected void updateDebugContext() {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof IDMVMContext) {
            this.setDebugContext((IDMVMContext)debugContext);
        } else {
            this.setDebugContext(null);
        }
    }

    protected void setDebugContext(IDMVMContext vmContext) {
        if (vmContext != null) {
            IDMContext dmContext = vmContext.getDMContext();
            String sessionId = dmContext.getSessionId();
            this.fTargetContext = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmContext, IGDBTraceControl.ITraceTargetDMContext.class);
            if (!sessionId.equals(this.fDebugSessionId)) {
                if (this.getSession() != null) {
                    try {
                        final DsfSession session = this.getSession();
                        session.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                session.removeServiceEventListener((Object)TraceControlModel.this);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
                this.fDebugSessionId = sessionId;
                if (this.fServicesTracker != null) {
                    this.fServicesTracker.dispose();
                }
                this.fServicesTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), sessionId);
                this.getGDBTraceControl();
                this.debugSessionChanged();
            }
        } else if (this.fDebugSessionId != null) {
            if (this.getSession() != null) {
                try {
                    final DsfSession session = this.getSession();
                    session.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            session.removeServiceEventListener((Object)TraceControlModel.this);
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            this.fDebugSessionId = null;
            this.fTargetContext = null;
            if (this.fServicesTracker != null) {
                this.fServicesTracker.dispose();
                this.fServicesTracker = null;
            }
            this.debugSessionChanged();
        }
    }

    private void debugSessionChanged() {
        if (this.getSession() != null) {
            try {
                final DsfSession session = this.getSession();
                session.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        session.addServiceEventListener((Object)TraceControlModel.this, null);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        this.updateContent();
    }

    public void exitVisualizationMode() {
        if (this.getSession() == null) {
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null) {
                    if (TraceControlModel.this.fGDBTraceControl instanceof IGDBTraceControl2) {
                        ((IGDBTraceControl2)TraceControlModel.this.fGDBTraceControl).stopTraceVisualization(TraceControlModel.this.fTargetContext, (RequestMonitor)new ImmediateRequestMonitor());
                    } else {
                        IGDBTraceControl.ITraceRecordDMContext emptyDmc = TraceControlModel.this.fGDBTraceControl.createTraceRecordContext(TraceControlModel.this.fTargetContext, "-1");
                        TraceControlModel.this.fGDBTraceControl.selectTraceRecord(emptyDmc, (RequestMonitor)new ImmediateRequestMonitor());
                    }
                }
            }
        });
    }

    public IGDBTraceControl.ITraceVariableDMData[] getTraceVarList() {
        if (this.getSession() == null) {
            return null;
        }
        Query<IGDBTraceControl.ITraceVariableDMData[]> query = new Query<IGDBTraceControl.ITraceVariableDMData[]>(){

            protected void execute(final DataRequestMonitor<IGDBTraceControl.ITraceVariableDMData[]> rm) {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null) {
                    TraceControlModel.this.fGDBTraceControl.getTraceVariables(TraceControlModel.this.fTargetContext, (DataRequestMonitor)new DataRequestMonitor<IGDBTraceControl.ITraceVariableDMData[]>((Executor)TraceControlModel.this.getSession().getExecutor(), rm){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                rm.setData((Object)((IGDBTraceControl.ITraceVariableDMData[])this.getData()));
                            } else {
                                rm.setData(null);
                            }
                            rm.done();
                        }
                    });
                } else {
                    rm.setData(null);
                    rm.done();
                }
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            return (IGDBTraceControl.ITraceVariableDMData[])query.get(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }

    public void createVariable(final String name, final String value) throws TraceControlView.FailedTraceVariableCreationException {
        if (this.getSession() == null) {
            throw new TraceControlView.FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_create_variable_error);
        }
        Query<String> query = new Query<String>(){

            protected void execute(DataRequestMonitor<String> rm) {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null) {
                    TraceControlModel.this.fGDBTraceControl.createTraceVariable(TraceControlModel.this.fTargetContext, name, value, new RequestMonitor((Executor)TraceControlModel.this.getSession().getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                        private final /* synthetic */ DataRequestMonitor val$rm;
                        {
                            this.val$rm = dataRequestMonitor;
                            super($anonymous0, $anonymous1);
                        }

                        protected void handleFailure() {
                            String message = TracepointsMessages.TraceControlView_create_variable_error;
                            Throwable t = this.getStatus().getException();
                            if (t != null) {
                                message = t.getMessage();
                            }
                            TraceControlView.FailedTraceVariableCreationException e = new TraceControlView.FailedTraceVariableCreationException(message);
                            this.val$rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Backend error", (Throwable)e));
                            this.val$rm.done();
                        }
                    });
                } else {
                    TraceControlView.FailedTraceVariableCreationException e = new TraceControlView.FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_trace_variable_tracing_unavailable);
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10001, "Tracing unavailable", (Throwable)e));
                    rm.done();
                }
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException && (t = ((CoreException)t).getStatus().getException()) instanceof TraceControlView.FailedTraceVariableCreationException) {
                throw (TraceControlView.FailedTraceVariableCreationException)t;
            }
            throw new TraceControlView.FailedTraceVariableCreationException(TracepointsMessages.TraceControlView_create_variable_error);
        }
    }

    public void setCurrentTraceRecord(final String traceRecordId) {
        if (this.getSession() == null) {
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null) {
                    TraceControlModel.this.fGDBTraceControl.getCurrentTraceRecordContext(TraceControlModel.this.fTargetContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IGDBTraceControl.ITraceRecordDMContext>(){

                        protected void handleSuccess() {
                            final IGDBTraceControl.ITraceRecordDMContext previousDmc = (IGDBTraceControl.ITraceRecordDMContext)this.getData();
                            IGDBTraceControl.ITraceRecordDMContext nextRecord = TraceControlModel.this.fGDBTraceControl.createTraceRecordContext(TraceControlModel.this.fTargetContext, traceRecordId);
                            TraceControlModel.this.getSession().dispatchEvent((Object)new GDBTraceControl_7_2.TraceRecordSelectedChangedEvent(nextRecord), new Hashtable());
                            TraceControlModel.this.fGDBTraceControl.selectTraceRecord(nextRecord, (RequestMonitor)new ImmediateRequestMonitor(){

                                protected void handleError() {
                                    TraceControlModel.this.getSession().dispatchEvent((Object)new GDBTraceControl_7_2.TraceRecordSelectedChangedEvent(previousDmc), new Hashtable());
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    public void setCircularBuffer(final boolean useCircularBuffer) {
        if (this.getSession() == null) {
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null && TraceControlModel.this.fGDBTraceControl instanceof IGDBTraceControl2) {
                    ((IGDBTraceControl2)TraceControlModel.this.fGDBTraceControl).setCircularTraceBuffer(TraceControlModel.this.fTargetContext, useCircularBuffer, (RequestMonitor)new ImmediateRequestMonitor());
                }
            }
        });
    }

    public void setDisconnectedTracing(final boolean disconnected) {
        if (this.getSession() == null) {
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null && TraceControlModel.this.fGDBTraceControl instanceof IGDBTraceControl2) {
                    ((IGDBTraceControl2)TraceControlModel.this.fGDBTraceControl).setDisconnectedTracing(TraceControlModel.this.fTargetContext, disconnected, (RequestMonitor)new ImmediateRequestMonitor());
                }
            }
        });
    }

    public void setTraceNotes(final String notes) {
        if (this.getSession() == null) {
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (TraceControlModel.this.fTargetContext != null && TraceControlModel.this.fGDBTraceControl != null && TraceControlModel.this.fGDBTraceControl instanceof IGDBTraceControl2) {
                    ((IGDBTraceControl2)TraceControlModel.this.fGDBTraceControl).setTraceNotes(TraceControlModel.this.fTargetContext, notes, (RequestMonitor)new ImmediateRequestMonitor());
                }
            }
        });
    }

    private void getGDBTraceControl() {
        if (this.getSession() == null) {
            this.fGDBTraceControl = null;
            return;
        }
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                TraceControlModel.this.fGDBTraceControl = (IGDBTraceControl)TraceControlModel.this.getService(IGDBTraceControl.class);
            }
        });
    }

    private DsfSession getSession() {
        return DsfSession.getSession((String)this.fDebugSessionId);
    }

    private <V> V getService(Class<V> serviceClass) {
        if (this.fServicesTracker != null) {
            return (V)this.fServicesTracker.getService(serviceClass);
        }
        return null;
    }

    private void notifyUI(IGDBTraceControl.ITraceStatusDMData2 data) {
        TraceControlView v = this.fTraceControlView;
        if (v != null) {
            Display.getDefault().asyncExec(() -> {
                if (v != null) {
                    traceControlView.fLastRefreshTime = System.currentTimeMillis();
                    v.updateUI(data);
                }
            });
        }
    }

    private void notifyUI(String message) {
        TraceControlView v = this.fTraceControlView;
        if (v != null) {
            Display.getDefault().asyncExec(() -> {
                if (v != null) {
                    v.updateUI(message);
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITracingStartedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITracingStoppedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        this.updateContent();
    }

    @DsfServiceEventHandler
    public void handleEvent(IGDBTraceControl.ITracingSupportedChangeDMEvent event) {
        this.updateContent();
    }
}

