/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.handlers;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.security.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.security.ui.ISecurityManagementContext;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.NotAuthenticatedException;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.handlers.LongRunningHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ManageSecurityHandler
extends LongRunningHandler {
    private IWorkbenchPart part;
    private ISecurityManagementContext context;
    private CDOSession session;

    protected void extractEventDetails(ExecutionEvent event) {
        super.extractEventDetails(event);
        this.part = HandlerUtil.getActivePart((ExecutionEvent)event);
        this.context = this.getContext(event);
    }

    protected void preRun() throws Exception {
        IWorkbenchPage page;
        IEditorPart existing;
        if (this.part == null) {
            this.cancel();
            return;
        }
        this.setSession(this.getSession());
        if (this.session != null && !this.session.isClosed() && (existing = this.findEditor(page = this.part.getSite().getPage(), this.session)) != null) {
            this.cancel();
            page.activate((IWorkbenchPart)existing);
        }
    }

    protected CDOSession getSession() {
        return (CDOSession)UIUtil.adaptElement((ISelection)this.getSelection(), CDOSession.class);
    }

    protected void setSession(CDOSession session) {
        this.session = session;
    }

    protected void doExecute(IProgressMonitor progressMonitor) throws Exception {
        final CDOView[] view = new CDOView[]{this.context.connect(this.session)};
        if (view[0] == null || view[0].isClosed()) {
            this.showWarning(Messages.ManageSecurityHandler_0, Messages.ManageSecurityHandler_1);
            return;
        }
        try {
            final CDOResource resource = this.context.getSecurityResource(view[0]);
            if (resource == null) {
                this.showWarning(Messages.ManageSecurityHandler_0, Messages.ManageSecurityHandler_2);
            } else {
                UIUtil.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        CDOEditorInput input = CDOEditorUtil.createCDOEditorInput((CDOView)view[0], (String)resource.getPath(), (boolean)false);
                        try {
                            IEditorPart editor = ManageSecurityHandler.this.part.getSite().getPage().openEditor((IEditorInput)input, "org.eclipse.emf.cdo.security.ui.CDOSecurityFormEditor");
                            if (editor != null) {
                                ManageSecurityHandler.this.hookCloseListener(editor, ManageSecurityHandler.this.context, view[0]);
                                view[0] = null;
                            }
                        }
                        catch (PartInitException e) {
                            StatusManager.getManager().handle(e.getStatus(), 2);
                        }
                    }
                });
            }
        }
        finally {
            if (view[0] != null) {
                this.context.disconnect(view[0]);
            }
        }
    }

    protected void showWarning(final String title, final String message) {
        UIUtil.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openWarning((Shell)ManageSecurityHandler.this.part.getSite().getShell(), (String)title, (String)message);
            }
        });
    }

    IEditorPart findEditor(IWorkbenchPage page, CDOSession session) {
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view;
            IEditorInput input;
            IEditorPart candidate;
            IEditorReference next = iEditorReferenceArray[n2];
            if ("org.eclipse.emf.cdo.security.ui.CDOSecurityFormEditor".equals(next.getId()) && (candidate = next.getEditor(false)) != null && (input = candidate.getEditorInput()) instanceof CDOEditorInput && (view = ((CDOEditorInput)input).getView()) != null && !view.isClosed() && session.equals(view.getSession())) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    ISecurityManagementContext getContext(ExecutionEvent event) {
        ISecurityManagementContext result = null;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part != null) {
            result = (ISecurityManagementContext)part.getAdapter(ISecurityManagementContext.class);
        }
        if (result == null) {
            result = ISecurityManagementContext.DEFAULT;
        }
        return result;
    }

    private void hookCloseListener(IEditorPart editor, final ISecurityManagementContext context, final CDOView view) {
        final IWorkbenchPage page = editor.getSite().getPage();
        page.addPartListener(new IPartListener(editor){
            private final IEditorInput input;
            private final Set<IEditorPart> openEditors;
            {
                this.input = iEditorPart.getEditorInput();
                this.openEditors = new HashSet<IEditorPart>();
                this.openEditors.add(iEditorPart);
            }

            public void partClosed(IWorkbenchPart part) {
                this.openEditors.remove(part);
                if (this.openEditors.isEmpty()) {
                    context.disconnect(view);
                    page.removePartListener((IPartListener)this);
                }
            }

            public void partOpened(IWorkbenchPart part) {
                IEditorPart editor;
                if (part instanceof IEditorPart && this.input.equals((editor = (IEditorPart)part).getEditorInput())) {
                    this.openEditors.add(editor);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        });
    }

    public static class Sessionless
    extends ManageSecurityHandler
    implements CDOAdminClientRepository.SessionConfigurator {
        private static final AtomicInteger NEXT_SESSION_NUMBER = new AtomicInteger();

        public void prepare(CDONet4jSessionConfiguration configuration) {
            IPasswordCredentialsProvider credentialsProvider = this.getCredentialsProvider();
            configuration.setCredentialsProvider(credentialsProvider);
        }

        protected CDOSession getSession() {
            return this.getExistingAdminSession(this.getRepository());
        }

        protected void doExecute(IProgressMonitor progressMonitor) throws Exception {
            CDOAdminClientRepository repository = this.getRepository();
            CDOSession session = this.getExistingAdminSession(repository);
            if (session == null) {
                session = this.openSession(this.getRepository());
                this.setSession(session);
            }
            if (session != null) {
                super.doExecute(progressMonitor);
            }
        }

        protected CDOAdminClientRepository getRepository() {
            return (CDOAdminClientRepository)UIUtil.adaptElement((ISelection)this.getSelection(), CDOAdminClientRepository.class);
        }

        protected CDOSession getExistingAdminSession(CDOAdminClientRepository repository) {
            Object[] objectArray = IPluginContainer.INSTANCE.getElements("org.eclipse.emf.cdo.sessions");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                CDONet4jSession session = (CDONet4jSession)ObjectUtil.tryCast((Object)element, CDONet4jSession.class);
                if (session != null && !session.isClosed() && ("Administrator".equals(session.getUserID()) || StringUtil.isEmpty((String)session.getUserID())) && ObjectUtil.equals((Object)session.getRepositoryInfo().getUUID(), (Object)repository.getUUID())) {
                    return session;
                }
                ++n2;
            }
            return null;
        }

        protected CDOSession openSession(CDOAdminClientRepository repository) {
            try {
                CDONet4jSession result = repository.openSession((CDOAdminClientRepository.SessionConfigurator)this);
                if (result != null) {
                    CDOPackageRegistryPopulator.populate((CDOPackageRegistry)result.getPackageRegistry());
                    String description = "session" + NEXT_SESSION_NUMBER.incrementAndGet();
                    IPluginContainer.INSTANCE.putElement("org.eclipse.emf.cdo.sessions", "security", description, (Object)result);
                }
                return result;
            }
            catch (NotAuthenticatedException e) {
                return null;
            }
        }

        protected IPasswordCredentialsProvider getCredentialsProvider() {
            IPluginContainer container = IPluginContainer.INSTANCE;
            String productGroup = "org.eclipse.net4j.util.security.credentialsProviders";
            String factoryType = "interactive";
            IPasswordCredentialsProvider credentialsProvider = (IPasswordCredentialsProvider)container.getElement(productGroup, factoryType, null);
            if (credentialsProvider == null) {
                credentialsProvider = UIUtil.createInteractiveCredentialsProvider();
            }
            return credentialsProvider;
        }
    }
}

