/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model;

public enum SourceVersion {
    RELEASE_0,
    RELEASE_1,
    RELEASE_2,
    RELEASE_3,
    RELEASE_4,
    RELEASE_5,
    RELEASE_6,
    RELEASE_7,
    RELEASE_8,
    RELEASE_9,
    RELEASE_10,
    RELEASE_11,
    RELEASE_12,
    RELEASE_13;

    private static final SourceVersion latestSupported;

    static {
        latestSupported = SourceVersion.getLatestSupported();
    }

    public static SourceVersion latest() {
        return RELEASE_13;
    }

    private static SourceVersion getLatestSupported() {
        int intVersion = Runtime.version().feature();
        return intVersion >= 11 ? SourceVersion.valueOf("RELEASE_" + Math.min(13, intVersion)) : RELEASE_10;
    }

    public static SourceVersion latestSupported() {
        return latestSupported;
    }

    public static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        if (id.length() == 0) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        int i = Character.charCount(cp);
        while (i < id.length()) {
            cp = id.codePointAt(i);
            if (!Character.isJavaIdentifierPart(cp)) {
                return false;
            }
            i += Character.charCount(cp);
        }
        return true;
    }

    public static boolean isName(CharSequence name) {
        return SourceVersion.isName(name, SourceVersion.latest());
    }

    public static boolean isName(CharSequence name, SourceVersion version) {
        String id = name.toString();
        String[] stringArray = id.split("\\.", -1);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!SourceVersion.isIdentifier(s) || SourceVersion.isKeyword(s, version)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isKeyword(CharSequence s) {
        return SourceVersion.isKeyword(s, SourceVersion.latest());
    }

    public static boolean isKeyword(CharSequence s, SourceVersion version) {
        String id;
        switch (id = s.toString()) {
            case "strictfp": {
                return version.compareTo(RELEASE_2) >= 0;
            }
            case "assert": {
                return version.compareTo(RELEASE_4) >= 0;
            }
            case "enum": {
                return version.compareTo(RELEASE_5) >= 0;
            }
            case "_": {
                return version.compareTo(RELEASE_9) >= 0;
            }
            case "volatile": 
            case "synchronized": 
            case "double": 
            case "extends": 
            case "import": 
            case "native": 
            case "public": 
            case "return": 
            case "implements": 
            case "static": 
            case "switch": 
            case "throws": 
            case "finally": 
            case "package": 
            case "protected": 
            case "continue": 
            case "private": 
            case "do": 
            case "if": 
            case "for": 
            case "int": 
            case "new": 
            case "try": 
            case "byte": 
            case "case": 
            case "char": 
            case "else": 
            case "goto": 
            case "long": 
            case "null": 
            case "this": 
            case "true": 
            case "void": 
            case "boolean": 
            case "break": 
            case "catch": 
            case "class": 
            case "const": 
            case "false": 
            case "final": 
            case "float": 
            case "short": 
            case "super": 
            case "throw": 
            case "while": 
            case "interface": 
            case "instanceof": 
            case "transient": 
            case "default": 
            case "abstract": {
                return true;
            }
        }
        return false;
    }
}

