/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.UpdateBundleVersionOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;

public class VersionNumberingResolution
implements IMarkerResolution2 {
    String newVersionValue;
    private int kind;
    private String description;

    public VersionNumberingResolution(IMarker marker) {
        this.newVersionValue = marker.getAttribute("version", null);
        this.kind = ApiProblemFactory.getProblemKind((int)marker.getAttribute("problemid", 0));
        this.description = marker.getAttribute("description", null);
    }

    public String getDescription() {
        this.description = this.description.replace(System.getProperty("line.separator"), "<br>");
        switch (this.kind) {
            case 1: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major0, (Object[])new String[]{this.description});
            }
            case 2: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor0, (Object[])new String[]{this.description});
            }
            case 3: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major0, (Object[])new String[]{this.description});
            }
            case 4: {
                return MarkerMessages.VersionNumberingResolution_minorNoNewAPI0;
            }
            case 5: {
                return MarkerMessages.VersionNumberingResolution_reexportedMajor0;
            }
            case 7: {
                return MarkerMessages.VersionNumberingResolution_breeMinor;
            }
            case 8: {
                return MarkerMessages.VersionNumberingResolution_unnecessaryMicroIncrease;
            }
            case 9: {
                return MarkerMessages.VersionNumberingResolution_unnecessaryMinorIncrease;
            }
        }
        return MarkerMessages.VersionNumberingResolution_reexportedMinor0;
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_OBJ_BUNDLE_VERSION");
    }

    public String getLabel() {
        switch (this.kind) {
            case 1: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
            }
            case 2: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor1, (Object)this.newVersionValue);
            }
            case 3: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
            }
            case 4: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_minorNoNewAPI1, (Object)this.newVersionValue);
            }
            case 5: {
                return NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
            }
            case 8: {
                return MarkerMessages.VersionNumberingResolution_unnecessaryMicroIncrease;
            }
            case 9: {
                return MarkerMessages.VersionNumberingResolution_unnecessaryMinorIncrease;
            }
        }
        return NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor1, (Object)this.newVersionValue);
    }

    public void run(final IMarker marker) {
        String title = null;
        switch (this.kind) {
            case 1: {
                title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
                break;
            }
            case 2: {
                title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor1, (Object)this.newVersionValue);
                break;
            }
            case 3: {
                title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
                break;
            }
            case 4: {
                title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_minorNoNewAPI2, (Object)this.newVersionValue);
                break;
            }
            case 5: {
                title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_major1, (Object)this.newVersionValue);
                break;
            }
            case 8: {
                title = MarkerMessages.VersionNumberingResolution_unnecessaryMicroIncrease;
                break;
            }
            case 9: {
                title = MarkerMessages.VersionNumberingResolution_unnecessaryMinorIncrease;
                break;
            }
            default: {
                title = NLS.bind((String)MarkerMessages.VersionNumberingResolution_minor1, (Object)this.newVersionValue);
            }
        }
        Job job = new Job(title){

            public IStatus run(IProgressMonitor monitor) {
                UpdateBundleVersionOperation updateBundleVersionOperation = new UpdateBundleVersionOperation(marker, VersionNumberingResolution.this.newVersionValue);
                return updateBundleVersionOperation.run(monitor);
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

