/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithWorkingTreeHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        if (selection.isEmpty()) {
            return null;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        Object input = this.getPage(event).getInputInternal().getSingleFile();
        IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        if (input instanceof IFile) {
            IFile file = (IFile)input;
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            if (mapping != null) {
                String gitPath = mapping.getRepoRelativePath((IResource)file);
                String commitPath = this.getRenamedPath(gitPath, (ObjectId)commit);
                ITypedElement right = CompareUtils.getFileRevisionTypedElement(commitPath, commit, mapping.getRepository());
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(SaveableCompareEditorInput.createFileElement((IFile)file), right, null);
                CompareUtils.openInCompare(workbenchPage, (CompareEditorInput)in);
            }
        } else if (input instanceof File) {
            File file = (File)input;
            Repository repo = this.getRepository(event);
            if (repo != null) {
                String leftCommitPath = this.getRepoRelativePath(repo, file);
                String rightCommitPath = this.getRenamedPath(leftCommitPath, (ObjectId)commit);
                ITypedElement right = CompareUtils.getFileRevisionTypedElement(rightCommitPath, commit, repo);
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)new LocalNonWorkspaceTypedElement(repo, (IPath)new Path(file.getAbsolutePath())), right, null);
                CompareUtils.openInCompare(workbenchPage, (CompareEditorInput)in);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        int size = this.getSelection(page).size();
        if (size != 1) {
            return false;
        }
        return page.getInputInternal().isSingleFile();
    }
}

