/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.DecoratorRepositoryStateCache;
import org.eclipse.egit.ui.internal.decorators.GitDecorator;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IServiceLocator;

public class RepositoryTreeNodeDecorator
extends GitDecorator
implements IStateListener {
    private static final String HAS_CHANGES_PREFIX = "> ";
    private static final String OPEN_BRACKET = " [";
    private static final String OPEN_PARENTHESIS = " (";
    private static final String MULTIPLE_REPOSITORIES = "*";
    private final State verboseBranchModeState;
    private boolean verboseBranchMode = false;

    public RepositoryTreeNodeDecorator() {
        ICommandService srv = CommonUtils.getService((IServiceLocator)PlatformUI.getWorkbench(), ICommandService.class);
        this.verboseBranchModeState = srv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchCommit").getState("org.eclipse.ui.commands.toggleState");
        this.verboseBranchModeState.addListener((IStateListener)this);
        try {
            this.verboseBranchMode = (Boolean)this.verboseBranchModeState.getValue();
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        this.verboseBranchModeState.removeListener((IStateListener)this);
        super.dispose();
    }

    @Override
    public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
        DecoratorRepositoryStateCache.INSTANCE.clear(repository);
        super.indexDiffChanged(repository, indexDiffData);
    }

    public void handleStateChange(State state, Object oldValue) {
        try {
            boolean newValue = (Boolean)state.getValue();
            if (newValue != this.verboseBranchMode) {
                this.verboseBranchMode = newValue;
                this.postLabelEvent();
            }
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        Repository repository = node.getRepository();
        if (repository != null) {
            UnitOfWork.execute((Repository)repository, () -> this.decorateText(node, repository, decoration));
        } else if (node.getType() == RepositoryTreeNodeType.REPOGROUP) {
            this.decorateRepositoryGroup(node, decoration);
        }
    }

    private void decorateText(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) {
        boolean decorated = false;
        switch (node.getType()) {
            case REPO: {
                decorated = this.decorateRepository(node, repository, decoration);
                break;
            }
            case ADDITIONALREF: {
                decorated = this.decorateAdditionalRef((AdditionalRefNode)node, decoration);
                break;
            }
            case REF: {
                decorated = this.decorateRef((RefNode)node, decoration);
                break;
            }
            case TAG: {
                decorated = this.decorateTag((TagNode)node, decoration);
                break;
            }
            case STASHED_COMMIT: {
                decorated = this.decorateStash((StashedCommitNode)node, decoration);
                break;
            }
            case SUBMODULES: {
                decorated = this.decorateSubmodules(repository, decoration);
                break;
            }
            default: {
                return;
            }
        }
        if (!decorated) {
            this.ensureCorrectLabelCaching(decoration);
        }
    }

    private boolean decorateAdditionalRef(AdditionalRefNode node, IDecoration decoration) {
        Ref ref = (Ref)node.getObject();
        StringBuilder suffix = new StringBuilder();
        if (ref.isSymbolic()) {
            suffix.append(OPEN_BRACKET).append(ref.getLeaf().getName()).append(']');
        }
        ObjectId refId = ref.getObjectId();
        suffix.append(' ');
        RevCommit commit = this.getLatestCommit(node);
        if (commit != null) {
            suffix.append(this.abbreviate((ObjectId)commit)).append(' ').append(commit.getShortMessage());
        } else if (!ref.isSymbolic() || refId != null) {
            suffix.append(this.abbreviate(refId));
        } else {
            suffix.append(UIText.RepositoriesViewLabelProvider_UnbornBranchText);
        }
        decoration.addSuffix(suffix.toString());
        return true;
    }

    private boolean decorateRef(RefNode node, IDecoration decoration) {
        RevCommit latest;
        if (this.verboseBranchMode && (latest = this.getLatestCommit(node)) != null) {
            decoration.addSuffix(" " + this.abbreviate((ObjectId)latest) + ' ' + latest.getShortMessage());
            return true;
        }
        return false;
    }

    private boolean decorateRepository(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) {
        boolean isSubModule;
        boolean bl = isSubModule = node.getParent() != null && node.getParent().getType() == RepositoryTreeNodeType.SUBMODULES;
        if (RepositoryUtil.hasChanges((Repository)repository)) {
            decoration.addPrefix(HAS_CHANGES_PREFIX);
        }
        StringBuilder suffix = new StringBuilder();
        if (isSubModule) {
            RevCommit commit;
            Ref head = DecoratorRepositoryStateCache.INSTANCE.getHeadRef(repository);
            if (head == null) {
                return false;
            }
            suffix.append(OPEN_BRACKET);
            if (head.isSymbolic()) {
                suffix.append(Repository.shortenRefName((String)head.getLeaf().getName()));
            } else if (head.getObjectId() != null) {
                suffix.append(this.abbreviate(head.getObjectId()));
            }
            suffix.append(']');
            if (this.verboseBranchMode && head.getObjectId() != null && (commit = DecoratorRepositoryStateCache.INSTANCE.getHeadCommit(repository)) != null) {
                suffix.append(' ').append(commit.getShortMessage());
            }
        } else {
            RepositoryState repositoryState;
            String branch = DecoratorRepositoryStateCache.INSTANCE.getCurrentBranchLabel(repository);
            if (branch == null) {
                return false;
            }
            suffix.append(OPEN_BRACKET);
            suffix.append(branch);
            String trackingStatus = DecoratorRepositoryStateCache.INSTANCE.getBranchStatus(repository);
            if (trackingStatus != null) {
                suffix.append(' ').append(trackingStatus);
            }
            if ((repositoryState = DecoratorRepositoryStateCache.INSTANCE.getRepositoryState(repository)) != RepositoryState.SAFE) {
                suffix.append(" - ").append(repositoryState.getDescription());
            }
            suffix.append(']');
        }
        decoration.addSuffix(suffix.toString());
        return true;
    }

    private void decorateRepositoryGroup(RepositoryTreeNode<?> node, IDecoration decoration) {
        RepositoryCache cache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
        RepositoryGroup group = (RepositoryGroup)((RepositoryGroupNode)node).getObject();
        boolean markGroupDirty = false;
        int numberOfBranches = 0;
        String singleBranch = null;
        String singleRepoName = null;
        int numberOfDirectories = group.getRepositoryDirectories().size();
        for (File repoDir : group.getRepositoryDirectories()) {
            Repository repo = cache.getRepository(repoDir);
            if (repo == null) continue;
            if (numberOfDirectories == 1) {
                singleRepoName = DecoratorRepositoryStateCache.INSTANCE.getRepositoryNameAndState(repo);
            }
            if (!markGroupDirty && RepositoryUtil.hasChanges((Repository)repo)) {
                markGroupDirty = true;
            }
            if (numberOfBranches <= 1) {
                String thisBranch = Repository.shortenRefName((String)DecoratorRepositoryStateCache.INSTANCE.getFullBranchName(repo));
                if (!thisBranch.equals(singleBranch)) {
                    ++numberOfBranches;
                }
                if (singleBranch == null) {
                    singleBranch = thisBranch;
                }
            }
            if (markGroupDirty && numberOfBranches > 1) break;
        }
        boolean decorated = false;
        if (markGroupDirty) {
            decorated = true;
            decoration.addPrefix(HAS_CHANGES_PREFIX);
        }
        if (numberOfBranches == 1) {
            decorated = true;
            String repoLabel = singleRepoName != null ? singleRepoName : MULTIPLE_REPOSITORIES;
            decoration.addSuffix(OPEN_BRACKET + repoLabel + ' ' + singleBranch + ']');
        } else if (numberOfDirectories > 1) {
            decorated = true;
            decoration.addSuffix(OPEN_PARENTHESIS + numberOfDirectories + ')');
        }
        if (!decorated) {
            this.ensureCorrectLabelCaching(decoration);
        }
    }

    private void ensureCorrectLabelCaching(IDecoration decoration) {
        decoration.addSuffix(" ");
    }

    private boolean decorateStash(StashedCommitNode node, IDecoration decoration) {
        RevCommit commit = (RevCommit)node.getObject();
        decoration.addSuffix(OPEN_BRACKET + this.abbreviate((ObjectId)commit) + "] " + commit.getShortMessage());
        return true;
    }

    private boolean decorateSubmodules(@NonNull Repository repository, IDecoration decoration) {
        if (this.haveSubmoduleChanges(repository)) {
            decoration.addPrefix(HAS_CHANGES_PREFIX);
            return true;
        }
        return false;
    }

    private boolean decorateTag(TagNode node, IDecoration decoration) {
        if (this.verboseBranchMode && node.getCommitId() != null && node.getCommitId().length() > 0) {
            decoration.addSuffix(" " + node.getCommitId().substring(0, 7) + ' ' + node.getCommitShortMessage());
            return true;
        }
        return false;
    }

    private RevCommit getLatestCommit(RepositoryTreeNode node) {
        Ref ref = (Ref)node.getObject();
        ObjectId id = ref.isSymbolic() ? ref.getLeaf().getObjectId() : ref.getObjectId();
        if (id == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk walk = new RevWalk(node.getRepository());){
                walk.setRetainBody(true);
                return walk.parseCommit((AnyObjectId)id);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private String abbreviate(ObjectId id) {
        if (id != null) {
            return Utils.getShortObjectId((ObjectId)id);
        }
        return Utils.getShortObjectId((ObjectId)ObjectId.zeroId());
    }

    private boolean haveSubmoduleChanges(@NonNull Repository repository) {
        IndexDiffData data;
        IndexDiffCache cache = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache();
        if (cache == null) {
            return false;
        }
        IndexDiffCacheEntry entry = cache.getIndexDiffCacheEntry(repository);
        IndexDiffData indexDiffData = data = entry != null ? entry.getIndexDiff() : null;
        if (data == null) {
            return false;
        }
        Set modified = data.getModified();
        return data.getSubmodules().stream().anyMatch(s -> modified.contains(s));
    }

    @Override
    protected String getName() {
        return UIText.RepositoryTreeNodeDecorator_name;
    }
}

