/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.storage.CommitBlobStorage;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

class GitRemoteFile
extends GitRemoteResource {
    private final Repository repo;
    private final DirCacheCheckout.CheckoutMetadata metadata;

    GitRemoteFile(Repository repo, RevCommit commitId, ObjectId objectId, String path, DirCacheCheckout.CheckoutMetadata metadata) {
        super(commitId, objectId, path);
        this.repo = repo;
        this.metadata = metadata;
    }

    public boolean isContainer() {
        return false;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IStorage content = this.getStorage((IProgressMonitor)progress.newChild(1));
        try {
            this.setContents(content.getContents(), (IProgressMonitor)progress.newChild(1));
        }
        catch (CoreException e) {
            Activator.logError("", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitRemoteFile) {
            GitRemoteFile that = (GitRemoteFile)((Object)obj);
            return this.getPath().equals(that.getPath()) && this.getObjectId().equals((AnyObjectId)that.getObjectId());
        }
        return false;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        return new CommitBlobStorage(this.repo, this.getCachePath(), this.getObjectId(), this.getCommitId(), this.metadata);
    }

    public int hashCode() {
        return this.getObjectId().hashCode() ^ this.getPath().hashCode();
    }
}

