/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.core.commands.CMakeCommand;
import com.cthing.cmakeed.core.commands.CMakeCommands;
import com.cthing.cmakeed.core.properties.CMakeProperties;
import com.cthing.cmakeed.core.properties.CMakeProperty;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWord;
import com.cthing.cmakeed.core.reservedwords.CMakeReservedWords;
import com.cthing.cmakeed.core.variables.CMakeVariable;
import com.cthing.cmakeed.core.variables.CMakeVariables;
import com.cthing.cmakeed.ui.editor.EditorUtils;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class CMakeEditorTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private IInformationControlCreator hoverControlCreator;

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            IRegion wordRegion = this.getWordRegion(textViewer, hoverRegion);
            String word = textViewer.getDocument().get(wordRegion.getOffset(), wordRegion.getLength());
            CMakeCommand cmd = CMakeCommands.getCommand((String)word);
            if (cmd != null) {
                return this.format(cmd.getName(), cmd.getDescription(), cmd.getUsages());
            }
            CMakeProperty prop = CMakeProperties.getCommand((String)word);
            if (prop != null) {
                return this.format("CMake Property", prop.getDescription(), null);
            }
            CMakeReservedWord resword = CMakeReservedWords.getCommand((String)word);
            if (resword != null) {
                return this.format("CMake Reserved Word", resword.getName(), null);
            }
            CMakeVariable var = CMakeVariables.getCommand((String)word);
            if (var != null) {
                return this.format("CMake Defined Variable", var.getDescription(), null);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String format(String name, String description, String[] usages) {
        String html = "<h2>" + name + "</h2>" + description;
        if (usages != null && usages.length > 0) {
            html = String.valueOf(html) + "<ul>";
            int i = 0;
            while (i < usages.length) {
                html = String.valueOf(html) + "<li><b>" + name + "</b>";
                html = String.valueOf(html) + usages[i].replaceAll("<", "&lt;") + "</li>";
                ++i;
            }
            html = String.valueOf(html) + "</ul>";
        }
        return html;
    }

    public IRegion getWordRegion(ITextViewer viewer, IRegion region) {
        IDocument doc;
        int offset = region.getOffset();
        if (offset >= (doc = viewer.getDocument()).getLength()) {
            return null;
        }
        int startOffset = offset;
        while (!EditorUtils.startOfWord(doc, startOffset) && startOffset >= 0) {
            --startOffset;
        }
        int endOffset = offset;
        while (!EditorUtils.startOfWord(doc, endOffset) && endOffset < doc.getLength()) {
            ++endOffset;
        }
        Region reg = new Region(startOffset, endOffset - startOffset - 1);
        return reg;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.hoverControlCreator == null) {
            this.hoverControlCreator = new HoverControlCreator(false);
        }
        return this.hoverControlCreator;
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final boolean createEnriched;

        public HoverControlCreator(boolean createEnriched) {
            this.createEnriched = createEnriched;
        }

        protected IInformationControl doCreateInformationControl(Shell parent) {
            if (this.createEnriched) {
                return new InformationControl(parent, true);
            }
            return new InformationControl(parent, EditorsUI.getTooltipAffordanceString());
        }
    }

    private static final class InformationControl
    extends DefaultInformationControl {
        private static final String BG_KEY = "org.eclipse.ui.workbench.HOVER_BACKGROUND";
        private static final String FG_KEY = "org.eclipse.ui.workbench.HOVER_FOREGROUND";

        private InformationControl(Shell parent, String statusFieldText) {
            super(parent, statusFieldText);
            this.init();
        }

        private InformationControl(Shell parent, boolean isResizeable) {
            super(parent, isResizeable);
            this.init();
        }

        private void init() {
            Color background;
            ColorRegistry registry = JFaceResources.getColorRegistry();
            Color foreground = registry.get(FG_KEY);
            if (foreground != null) {
                this.setForegroundColor(foreground);
            }
            if ((background = registry.get(BG_KEY)) != null) {
                this.setBackgroundColor(background);
            }
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new HoverControlCreator(true);
        }
    }
}

