/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.security;

import java.security.SecureRandom;
import java.text.MessageFormat;
import org.eclipse.net4j.util.internal.ui.messages.Messages;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.PasswordCredentialsUpdate;
import org.eclipse.net4j.util.ui.security.CredentialsDialog;
import org.eclipse.swt.widgets.Shell;

public class CredentialsResetDialog
extends CredentialsDialog {
    private static final String TITLE = Messages.getString("CredentialsResetDialog_0");
    private static final String MESSAGE = Messages.getString("CredentialsResetDialog_1");
    private static final SecureRandom RANDOM = new SecureRandom();

    public CredentialsResetDialog(Shell shell, String userID) {
        this(shell, null, userID);
    }

    public CredentialsResetDialog(Shell shell, String realm, String userID) {
        super(shell, realm, TITLE, MessageFormat.format(MESSAGE, userID));
    }

    public IPasswordCredentialsUpdate getCredentials() {
        return (IPasswordCredentialsUpdate)super.getCredentials();
    }

    protected IPasswordCredentials createCredentials(String userID, char[] password) {
        char[] newPassword = this.generatePassword();
        return new PasswordCredentialsUpdate(userID, password, newPassword);
    }

    char[] generatePassword() {
        char[] result = new char[8];
        char base = Character.valueOf('!').charValue();
        int max = Character.valueOf('~').charValue() - base;
        int i = 0;
        while (i < result.length) {
            result[i] = (char)(base + RANDOM.nextInt(max));
            ++i;
        }
        return result;
    }
}

