/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtend.open62541.compiler.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaClient;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class OpcUaClientImpl implements OpcUaClient {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private OpcUaObjectInterfaceImpl _opcUaObjectInterfaceImpl;
  
  @Inject
  @Extension
  private OpcUaXmlParser _opcUaXmlParser;
  
  @Override
  public String getOpcUa_DeviceClient_HeaderFileName(final String clientName) {
    return (("OpcUa" + clientName) + ".hh");
  }
  
  @Override
  public String getOpcUa_DeviceClient_SourceFileName(final String clientName) {
    return (("OpcUa" + clientName) + ".cc");
  }
  
  @Override
  public String getOpcUa_DeviceClient_TestMain_SourceFileName(final String clientName) {
    return (clientName + "ClientMain.cc");
  }
  
  @Override
  public CharSequence compileOpcUa_DeviceClient_HeaderFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef _");
    String _upperCase = objectName.toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = objectName.toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// use the generic client implmentation from the Open62541 C++ Wrapper Library");
    _builder.newLine();
    _builder.append("#include <OpcUaGenericClient.hh>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// implement the abstract interface");
    _builder.newLine();
    _builder.append("#include \"");
    String _opcUaDevice_Interface_HeaderFileName = this._opcUaObjectInterfaceImpl.getOpcUaDevice_Interface_HeaderFileName(objectName);
    _builder.append(_opcUaDevice_Interface_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace OPCUA {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/** This class wraps OPC UA related communication to an OPC UA Device.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This class internally implements an OPC UA client and provides a C++ API");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* based on a provided XML file that contains the device\'s information model.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* In case where no XML file is provided, this class can still be used generically");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* by using two generic connect methods and the generic template getter/setter/caller methods.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* ");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("class ");
    _builder.append(objectName);
    _builder.append(" : public GenericClient, public ");
    _builder.append(objectName);
    _builder.append("Interface");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("protected:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// method implementing the XML-specific client space");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual bool createClientSpace(const bool activateUpcalls=true) override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// generic upcall method called whenever one of the ntity\'s values is changed");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void handleVariableValueUpdate(const std::string &variableName, const OPCUA::Variant &value) override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("\t");
        _builder.append("// specific method to handle value updates for ");
        _builder.append(entity.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("void handle");
        String _firstUpper = StringExtensions.toFirstUpper(entity.name);
        _builder.append(_firstUpper, "\t");
        _builder.append("(const ");
        String _cppType = this._opcUaXmlParser.getCppType(entity.type);
        _builder.append(_cppType, "\t");
        _builder.append(" &value);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Constructor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(objectName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// Destructor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~");
    _builder.append(objectName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_1 : entityList) {
        _builder.append("\t");
        _builder.append("/** XML Specific Getter function for variable ");
        _builder.append(entity_1.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  This function gets ");
        _builder.append(entity_1.name, "\t ");
        _builder.append("  from the Server");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  When class ");
        _builder.append(objectName, "\t ");
        _builder.append(" is used with a Specific XML file to connect to");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  SeRoNet Servers which implements the device information model.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @return the new value (or a default value like 0 in case of errors)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual ");
        String _cppType_1 = this._opcUaXmlParser.getCppType(entity_1.type);
        _builder.append(_cppType_1, "\t");
        _builder.append(" get");
        String _firstUpper_1 = StringExtensions.toFirstUpper(entity_1.name);
        _builder.append(_firstUpper_1, "\t");
        _builder.append("() const;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/** XML Specific Getter function for variable ");
        _builder.append(entity_1.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  This function gets ");
        _builder.append(entity_1.name, "\t ");
        _builder.append("  from the Server");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  When class ");
        _builder.append(objectName, "\t ");
        _builder.append(" is used with a Specific XML file to connect to");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  SeRoNet Servers which implements the device information model.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @param value\t:output parameter, returns the new value if StatusCode is ALL_OK");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @return status code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*\t- ALL_OK");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  - DISCONNECTED");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  - ERROR_COMMUNICATION");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual OPCUA::StatusCode get");
        String _firstUpper_2 = StringExtensions.toFirstUpper(entity_1.name);
        _builder.append(_firstUpper_2, "\t");
        _builder.append("(");
        String _cppType_2 = this._opcUaXmlParser.getCppType(entity_1.type);
        _builder.append(_cppType_2, "\t");
        _builder.append(" &");
        String _firstLower = StringExtensions.toFirstLower(entity_1.name);
        _builder.append(_firstLower, "\t");
        _builder.append(") const override;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual OPCUA::StatusCode get");
        String _firstUpper_3 = StringExtensions.toFirstUpper(entity_1.name);
        _builder.append(_firstUpper_3, "\t");
        _builder.append("Wait(");
        String _cppType_3 = this._opcUaXmlParser.getCppType(entity_1.type);
        _builder.append(_cppType_3, "\t");
        _builder.append(" &");
        String _firstLower_1 = StringExtensions.toFirstLower(entity_1.name);
        _builder.append(_firstLower_1, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        {
          if (((entity_1.userAccessLevel == 2) || (entity_1.userAccessLevel == 3))) {
            _builder.append("\t");
            _builder.append("/** XML Specific Setter function for entity ");
            _builder.append(entity_1.name, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  This function sets ");
            _builder.append(entity_1.name, "\t ");
            _builder.append("  at the Server");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  When class ");
            _builder.append(objectName, "\t ");
            _builder.append(" is used with a Specific XML file to connect to");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  SeRoNet Servers which implements the device information model.");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  @param value\t\t\t:Value to be set");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  @return status code");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*    - true    : Entity was found and the value was set correctly");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*    - false   : Entity was not found or the value was not set correctly");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("virtual OPCUA::StatusCode set");
            String _firstUpper_4 = StringExtensions.toFirstUpper(entity_1.name);
            _builder.append(_firstUpper_4, "\t");
            _builder.append("(const ");
            String _cppType_4 = this._opcUaXmlParser.getCppType(entity_1.type);
            _builder.append(_cppType_4, "\t");
            _builder.append(" &value) override;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method : methodList) {
        _builder.append("\t");
        _builder.append("/** XML Specific Caller function for method ");
        _builder.append(method.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  This function calls the method ");
        _builder.append(method.name, "\t ");
        _builder.append(" at the Server");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT argIn : method.inputArguments) {
            _builder.append("\t");
            _builder.append("*  @param ");
            _builder.append(argIn.name, "\t");
            _builder.append("\t\t\t: Input | DataTypeIdentifier:");
            _builder.append(argIn.DataTypeIdentifier, "\t");
            _builder.append("(");
            String _DataTypeString = argIn.DataTypeString();
            _builder.append(_DataTypeString, "\t");
            _builder.append(") ValueRank:");
            _builder.append(argIn.ValueRank, "\t");
            _builder.append(" ArrayDimensions:");
            _builder.append(argIn.ArrayDimensions, "\t");
            _builder.append("\t\t\t \t");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT argIn_1 : method.outputArguments) {
            _builder.append("\t");
            _builder.append("*  @param ");
            _builder.append(argIn_1.name, "\t");
            _builder.append("\t\t\t: Output| DataTypeIdentifier:");
            _builder.append(argIn_1.DataTypeIdentifier, "\t");
            _builder.append("(");
            String _DataTypeString_1 = argIn_1.DataTypeString();
            _builder.append(_DataTypeString_1, "\t");
            _builder.append(") ValueRank:");
            _builder.append(argIn_1.ValueRank, "\t");
            _builder.append(" ArrayDimensions:");
            _builder.append(argIn_1.ArrayDimensions, "\t");
            _builder.append("\t\t\t \t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @return status code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*    - true    : Method was found and the method call was completed correctly");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*    - false   : Method was not found or the method call was not completed correctly");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("virtual OPCUA::StatusCode call");
        String _firstUpper_5 = StringExtensions.toFirstUpper(method.name);
        _builder.append(_firstUpper_5, "\t ");
        _builder.append("(");
        String _cppMethodArgumentsDef = this._opcUaXmlParser.getCppMethodArgumentsDef(method);
        _builder.append(_cppMethodArgumentsDef, "\t ");
        _builder.append(") override;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.newLine();
      }
    }
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace OPCUA */");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif // _");
    String _upperCase_2 = objectName.toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence compileOpcUa_DeviceClient_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _opcUa_DeviceClient_HeaderFileName = this.getOpcUa_DeviceClient_HeaderFileName(objectName);
    _builder.append(_opcUa_DeviceClient_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("using namespace OPCUA;");
    _builder.newLine();
    _builder.newLine();
    _builder.append(objectName);
    _builder.append("::");
    _builder.append(objectName);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.append(objectName);
    _builder.append("::~");
    _builder.append(objectName);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("bool ");
    _builder.append(objectName);
    _builder.append("::createClientSpace(const bool activateUpcalls)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("bool result = true;");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("\t");
        _builder.append("if(this->addVariableNode(\"");
        _builder.append(entity.name, "\t");
        _builder.append("\", activateUpcalls) != true) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("result = false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method : methodList) {
        _builder.append("\t");
        _builder.append("if(this->addMethodNode(\"");
        _builder.append(method.name, "\t");
        _builder.append("\") != true) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("result = false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    _builder.append(objectName);
    _builder.append("::handleVariableValueUpdate(const std::string &variableName, const OPCUA::Variant &value)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_1 : entityList) {
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetENTITY _head = IterableExtensions.<OpcUaXmlParser.SeRoNetENTITY>head(entityList);
          boolean _notEquals = (!Objects.equal(entity_1, _head));
          if (_notEquals) {
            _builder.append("else ");
          }
        }
        _builder.append("if(variableName == \"");
        _builder.append(entity_1.name, "\t");
        _builder.append("\") ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("this->handle");
        String _firstUpper = StringExtensions.toFirstUpper(entity_1.name);
        _builder.append(_firstUpper, "\t\t");
        _builder.append("(value);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_2 : entityList) {
        _builder.append("// specific method to handle value updates for ");
        _builder.append(entity_2.name);
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        _builder.append(objectName);
        _builder.append("::handle");
        String _firstUpper_1 = StringExtensions.toFirstUpper(entity_2.name);
        _builder.append(_firstUpper_1);
        _builder.append("(const ");
        String _cppType = this._opcUaXmlParser.getCppType(entity_2.type);
        _builder.append(_cppType);
        _builder.append(" &value)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//implement your specific code here (if needed)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::cout << \"handle");
        String _firstUpper_2 = StringExtensions.toFirstUpper(entity_2.name);
        _builder.append(_firstUpper_2, "\t");
        _builder.append("(): \" << value << std::endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("// generate xml-specific getters and setters");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_3 : entityList) {
        String _cppType_1 = this._opcUaXmlParser.getCppType(entity_3.type);
        _builder.append(_cppType_1);
        _builder.append(" ");
        _builder.append(objectName);
        _builder.append("::get");
        String _firstUpper_3 = StringExtensions.toFirstUpper(entity_3.name);
        _builder.append(_firstUpper_3);
        _builder.append("() const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("OPCUA::Variant genericValue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("OPCUA::StatusCode status = getVariableCurrentValue(\"");
        _builder.append(entity_3.name, "\t");
        _builder.append("\", genericValue);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(status == OPCUA::StatusCode::ALL_OK) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return genericValue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _cppDefaultValue = this._opcUaXmlParser.getCppDefaultValue(entity_3.type);
        _builder.append(_cppDefaultValue, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.append("OPCUA::StatusCode ");
        _builder.append(objectName);
        _builder.append("::get");
        String _firstUpper_4 = StringExtensions.toFirstUpper(entity_3.name);
        _builder.append(_firstUpper_4);
        _builder.append("(");
        String _cppType_2 = this._opcUaXmlParser.getCppType(entity_3.type);
        _builder.append(_cppType_2);
        _builder.append(" &");
        String _firstLower = StringExtensions.toFirstLower(entity_3.name);
        _builder.append(_firstLower);
        _builder.append(") const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("OPCUA::Variant genericValue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("OPCUA::StatusCode status = getVariableCurrentValue(\"");
        _builder.append(entity_3.name, "\t");
        _builder.append("\", genericValue);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_1 = StringExtensions.toFirstLower(entity_3.name);
        _builder.append(_firstLower_1, "\t");
        _builder.append(" = genericValue");
        {
          boolean _equals = entity_3.type.equals("String");
          if (_equals) {
            _builder.append(".toString()");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return status;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("OPCUA::StatusCode ");
        _builder.append(objectName);
        _builder.append("::get");
        String _firstUpper_5 = StringExtensions.toFirstUpper(entity_3.name);
        _builder.append(_firstUpper_5);
        _builder.append("Wait(");
        String _cppType_3 = this._opcUaXmlParser.getCppType(entity_3.type);
        _builder.append(_cppType_3);
        _builder.append(" &");
        String _firstLower_2 = StringExtensions.toFirstLower(entity_3.name);
        _builder.append(_firstLower_2);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("OPCUA::Variant genericValue;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("OPCUA::StatusCode status = getVariableNextValue(\"");
        _builder.append(entity_3.name, "\t");
        _builder.append("\", genericValue);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_3 = StringExtensions.toFirstLower(entity_3.name);
        _builder.append(_firstLower_3, "\t");
        _builder.append(" = genericValue");
        {
          boolean _equals_1 = entity_3.type.equals("String");
          if (_equals_1) {
            _builder.append(".toString()");
          }
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return status;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        {
          if (((entity_3.userAccessLevel == 2) || (entity_3.userAccessLevel == 3))) {
            _builder.append("OPCUA::StatusCode ");
            _builder.append(objectName);
            _builder.append("::set");
            String _firstUpper_6 = StringExtensions.toFirstUpper(entity_3.name);
            _builder.append(_firstUpper_6);
            _builder.append("(const ");
            String _cppType_4 = this._opcUaXmlParser.getCppType(entity_3.type);
            _builder.append(_cppType_4);
            _builder.append(" &value) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return setVariableValue(\"");
            _builder.append(entity_3.name, "\t");
            _builder.append("\", value);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method_1 : methodList) {
        _builder.append("OPCUA::StatusCode ");
        _builder.append(objectName);
        _builder.append("::call");
        String _firstUpper_7 = StringExtensions.toFirstUpper(method_1.name);
        _builder.append(_firstUpper_7);
        _builder.append("(");
        String _cppMethodArgumentsDef = this._opcUaXmlParser.getCppMethodArgumentsDef(method_1);
        _builder.append(_cppMethodArgumentsDef);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("std::vector<OPCUA::Variant> inputArguments(");
        int _size = method_1.inputArguments.size();
        _builder.append(_size, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        int count1 = (-1);
        _builder.newLineIfNotEmpty();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT arg : method_1.inputArguments) {
            _builder.append("\t");
            _builder.append("inputArguments[");
            _builder.append(count1 = (count1 + 1), "\t");
            _builder.append("] = ");
            _builder.append(arg.name, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("std::vector<OPCUA::Variant> outputArguments;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("OPCUA::StatusCode status = callMethod(std::string(\"");
        _builder.append(method_1.name, "\t");
        _builder.append("\"), inputArguments, outputArguments);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(status == OPCUA::StatusCode::ALL_OK)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        int count2 = (-1);
        _builder.newLineIfNotEmpty();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT arg_1 : method_1.outputArguments) {
            {
              if ((arg_1.ValueRank == 1)) {
                _builder.append("\t\t");
                _builder.append(arg_1.name, "\t\t");
                _builder.append(" = outputArguments[");
                _builder.append(count2 = (count2 + 1), "\t\t");
                _builder.append("].getArrayValuesAs<");
                String _DataTypeString = arg_1.DataTypeString();
                _builder.append(_DataTypeString, "\t\t");
                _builder.append(">();");
                _builder.newLineIfNotEmpty();
              } else {
                {
                  if ((arg_1.DataTypeIdentifier == OpcUaXmlParser.SeRoNetARGUMENT.UA_TYPES_STRING)) {
                    _builder.append("\t\t");
                    _builder.append(arg_1.name, "\t\t");
                    _builder.append(" = outputArguments[");
                    _builder.append(count2 = (count2 + 1), "\t\t");
                    _builder.append("].toString();");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("\t\t");
                    _builder.append(arg_1.name, "\t\t");
                    _builder.append(" = outputArguments[");
                    _builder.append(count2 = (count2 + 1), "\t\t");
                    _builder.append("];");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return status;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence compileOpcUa_DeviceClient_TestMain_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _opcUa_DeviceClient_HeaderFileName = this.getOpcUa_DeviceClient_HeaderFileName(objectName);
    _builder.append(_opcUa_DeviceClient_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("void callAllGetters(const OPCUA::");
    _builder.append(objectName);
    _builder.append(" &client) {");
    _builder.newLineIfNotEmpty();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("\t");
        String _cppType = this._opcUaXmlParser.getCppType(entity.type);
        _builder.append(_cppType, "\t");
        _builder.append(" ");
        String _firstLower = StringExtensions.toFirstLower(entity.name);
        _builder.append(_firstLower, "\t");
        _builder.append(" = client.get");
        String _firstUpper = StringExtensions.toFirstUpper(entity.name);
        _builder.append(_firstUpper, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("std::cout << \"get");
        String _firstUpper_1 = StringExtensions.toFirstUpper(entity.name);
        _builder.append(_firstUpper_1, "\t");
        _builder.append("(): \" << ");
        String _firstLower_1 = StringExtensions.toFirstLower(entity.name);
        _builder.append(_firstLower_1, "\t");
        _builder.append(" << std::endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int main(int argc, char* argv[]) ");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("OPCUA::");
    _builder.append(objectName, "\t");
    _builder.append(" client;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string serverAddress = \"opc.tcp://localhost:4840\";");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::string rootObjectName = \"");
    _builder.append(objectName, "\t");
    _builder.append("\";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("std::cout << \"connecting client: \" << client.connect(serverAddress, rootObjectName) << std::endl;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// this is just a testing method");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("callAllGetters(client);");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("OPCUA::StatusCode status;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("do {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// this executes the client\'s upcall (i.e. subscription) infrastructure");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("status = client.run_once();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("} while(status == OPCUA::StatusCode::ALL_OK);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence compileOpcUa_DeviceClient_Test_CMakeListsContent(final String objectName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("PROJECT(");
    _builder.append(objectName);
    _builder.append("ClientTest)");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# find Open62541CppWrapper as the main dependency");
    _builder.newLine();
    _builder.append("FIND_PACKAGE(Open62541CppWrapper 1.0)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# setup default include directoy");
    _builder.newLine();
    _builder.append("INCLUDE_DIRECTORIES(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/..");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# setup server source files");
    _builder.newLine();
    _builder.append("SET(SERVER_SRCS");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/");
    String _opcUa_DeviceClient_SourceFileName = this.getOpcUa_DeviceClient_SourceFileName(objectName);
    _builder.append(_opcUa_DeviceClient_SourceFileName, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/");
    String _opcUa_DeviceClient_TestMain_SourceFileName = this.getOpcUa_DeviceClient_TestMain_SourceFileName(objectName);
    _builder.append(_opcUa_DeviceClient_TestMain_SourceFileName, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# create server test executable");
    _builder.newLine();
    _builder.append("ADD_EXECUTABLE(${PROJECT_NAME} ${SERVER_SRCS})");
    _builder.newLine();
    _builder.append("TARGET_LINK_LIBRARIES(${PROJECT_NAME} Open62541CppWrapper)");
    _builder.newLine();
    _builder.append("SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("CXX_STANDARD 14");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    return _builder;
  }
}
