/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaClient;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaClientImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterface;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServer;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServerImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.smartmdsd.xtend.open62541.compiler.SpecificModelViewController;
import org.eclipse.smartmdsd.xtend.open62541.compiler.SpecificModelViewControllerImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class OpcUaXmlCompilerMain {
  public static void main(final String[] args) {
    SimpleDateFormat _simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    Date _date = new Date();
    String TimeStamp = _simpleDateFormat.format(_date);
    int _size = ((List<String>)Conversions.doWrapArray(args)).size();
    boolean _lessThan = (_size < 1);
    if (_lessThan) {
      System.err.println(("TIMESTAMP: " + TimeStamp));
      System.err.println("ERROR: no XML file specified");
      System.err.println("Arguments: <XML-File> ( [ALL] | ([SERVER] [CLIENT] [MVC]) ) (USE_TS)");
      return;
    }
    String _get = args[0];
    final File xmlFile = new File(_get);
    boolean generateServer = false;
    boolean generateClient = false;
    boolean generateMVC = false;
    boolean useTimeStamp = false;
    String TAG = (args[0]).replace(".xml", "");
    for (final String arg : args) {
      Object _head = IterableExtensions.<Object>head(((Iterable<Object>)Conversions.doWrapArray(args)));
      boolean _notEquals = (!Objects.equal(arg, _head));
      if (_notEquals) {
        boolean _equals = arg.equals("ALL");
        if (_equals) {
          generateServer = true;
          generateClient = true;
          generateMVC = true;
        } else {
          boolean _equals_1 = arg.equals("SERVER");
          if (_equals_1) {
            generateServer = true;
          } else {
            boolean _equals_2 = arg.equals("CLIENT");
            if (_equals_2) {
              generateClient = true;
            } else {
              boolean _equals_3 = arg.equals("MVC");
              if (_equals_3) {
                generateServer = true;
                generateMVC = true;
              } else {
                boolean _equals_4 = arg.equals("USE_TS");
                if (_equals_4) {
                  useTimeStamp = true;
                }
              }
            }
          }
        }
      }
    }
    String TargetOutputPath = ("output_" + TAG);
    if ((useTimeStamp == true)) {
      TargetOutputPath = ((TargetOutputPath + "_") + TimeStamp);
    }
    TargetOutputPath = (TargetOutputPath + "/src-gen");
    final JavaIoFileSystemAccess fsa = new JavaIoFileSystemAccess();
    String _replace = TargetOutputPath.replace("/src-gen", "");
    String _plus = ("Output path set to: " + _replace);
    InputOutput.<String>println(_plus);
    fsa.setOutputPath(TargetOutputPath);
    final File outDir = new File(TargetOutputPath);
    if ((outDir.exists() && outDir.isDirectory())) {
      InputOutput.<String>println(("Cleanup Directory: " + TargetOutputPath));
      File[] _listFiles = outDir.listFiles();
      for (final File f : _listFiles) {
        boolean _isDirectory = f.isDirectory();
        if (_isDirectory) {
          File[] _listFiles_1 = f.listFiles();
          for (final File f2 : _listFiles_1) {
            boolean _isDirectory_1 = f2.isDirectory();
            boolean _not = (!_isDirectory_1);
            if (_not) {
              f2.delete();
            }
          }
        } else {
          f.delete();
        }
      }
    }
    final Injector injector = Guice.createInjector(new AbstractModule() {
      @Override
      protected void configure() {
        this.binder().<OpcUaObjectInterface>bind(OpcUaObjectInterface.class).to(OpcUaObjectInterfaceImpl.class);
        this.binder().<OpcUaServer>bind(OpcUaServer.class).to(OpcUaServerImpl.class);
        this.binder().<OpcUaClient>bind(OpcUaClient.class).to(OpcUaClientImpl.class);
        this.binder().<SpecificModelViewController>bind(SpecificModelViewController.class).to(SpecificModelViewControllerImpl.class);
        this.binder().<IEncodingProvider>bind(IEncodingProvider.class).to(IEncodingProvider.Runtime.class);
      }
    });
    injector.injectMembers(fsa);
    final OpcUaXmlParser parser = new OpcUaXmlParser();
    final String objectName = parser.getObjectName(xmlFile);
    final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList = parser.getEntityList(xmlFile);
    final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList = parser.getMethodList(xmlFile);
    final OpcUaObjectInterface interfaceGenerator = injector.<OpcUaObjectInterface>getInstance(OpcUaObjectInterface.class);
    fsa.generateFile(
      interfaceGenerator.getOpcUaDevice_Interface_HeaderFileName(objectName), 
      interfaceGenerator.compileOpcUaDevice_Interface_HeaderFileContent(objectName, entityList, methodList));
    if ((generateServer == true)) {
      final String serverSubFolder = "server";
      final OpcUaServer serverGenerator = injector.<OpcUaServer>getInstance(OpcUaServer.class);
      String _opcUaDevice_Server_HeaderFileName = serverGenerator.getOpcUaDevice_Server_HeaderFileName(objectName);
      String _plus_1 = ((serverSubFolder + "/") + _opcUaDevice_Server_HeaderFileName);
      fsa.generateFile(_plus_1, 
        serverGenerator.compileOpcUaDevice_Server_HeaderFileContent(objectName, entityList, methodList));
      String _opcUaDevice_Server_SourceFileName = serverGenerator.getOpcUaDevice_Server_SourceFileName(objectName);
      String _plus_2 = ((serverSubFolder + "/") + _opcUaDevice_Server_SourceFileName);
      fsa.generateFile(_plus_2, 
        serverGenerator.compileOpcUaDevice_Server_SourceFileContent(objectName, entityList, methodList));
    }
    if ((generateClient == true)) {
      final OpcUaClient clientGenerator = injector.<OpcUaClient>getInstance(OpcUaClient.class);
      final String clientSubFolder = "client";
      String _opcUa_DeviceClient_HeaderFileName = clientGenerator.getOpcUa_DeviceClient_HeaderFileName(objectName);
      String _plus_3 = ((clientSubFolder + "/") + _opcUa_DeviceClient_HeaderFileName);
      fsa.generateFile(_plus_3, 
        clientGenerator.compileOpcUa_DeviceClient_HeaderFileContent(objectName, entityList, methodList));
      String _opcUa_DeviceClient_SourceFileName = clientGenerator.getOpcUa_DeviceClient_SourceFileName(objectName);
      String _plus_4 = ((clientSubFolder + "/") + _opcUa_DeviceClient_SourceFileName);
      fsa.generateFile(_plus_4, 
        clientGenerator.compileOpcUa_DeviceClient_SourceFileContent(objectName, entityList, methodList));
      String _opcUa_DeviceClient_TestMain_SourceFileName = clientGenerator.getOpcUa_DeviceClient_TestMain_SourceFileName(objectName);
      String _plus_5 = ((clientSubFolder + "/") + _opcUa_DeviceClient_TestMain_SourceFileName);
      fsa.generateFile(_plus_5, 
        clientGenerator.compileOpcUa_DeviceClient_TestMain_SourceFileContent(objectName, entityList, methodList));
      fsa.generateFile(
        ((clientSubFolder + "/") + "CMakeLists.txt"), 
        clientGenerator.compileOpcUa_DeviceClient_Test_CMakeListsContent(objectName));
    }
    if ((generateMVC == true)) {
      final SpecificModelViewController mvcGenerator = injector.<SpecificModelViewController>getInstance(SpecificModelViewController.class);
      final String mvcSubFolder = "server";
      String _specificDriverModelHeader = mvcGenerator.getSpecificDriverModelHeader(objectName);
      String _plus_6 = ((mvcSubFolder + "/") + _specificDriverModelHeader);
      fsa.generateFile(_plus_6, 
        mvcGenerator.compileSpecificDriverModelHeader(objectName));
      String _specificViewHeader = mvcGenerator.getSpecificViewHeader(objectName);
      String _plus_7 = ((mvcSubFolder + "/") + _specificViewHeader);
      fsa.generateFile(_plus_7, 
        mvcGenerator.compileSpecificViewHeader(objectName));
      String _specificViewSource = mvcGenerator.getSpecificViewSource(objectName);
      String _plus_8 = ((mvcSubFolder + "/") + _specificViewSource);
      fsa.generateFile(_plus_8, 
        mvcGenerator.compileSpecificViewSource(objectName));
      String _specificControllerHeader = mvcGenerator.getSpecificControllerHeader(objectName);
      String _plus_9 = ((mvcSubFolder + "/") + _specificControllerHeader);
      fsa.generateFile(_plus_9, 
        mvcGenerator.compileSpecificControllerHeader(objectName, entityList, methodList));
      String _specificControllerSource = mvcGenerator.getSpecificControllerSource(objectName);
      String _plus_10 = ((mvcSubFolder + "/") + _specificControllerSource);
      fsa.generateFile(_plus_10, 
        mvcGenerator.compileSpecificControllerSource(objectName, entityList, methodList));
      String _specificTestServer = mvcGenerator.getSpecificTestServer(objectName);
      String _plus_11 = ((mvcSubFolder + "/") + _specificTestServer);
      fsa.generateFile(_plus_11, 
        mvcGenerator.compileSpecificTestServer(objectName));
      fsa.generateFile(
        ((mvcSubFolder + "/") + "CMakeLists.txt"), 
        mvcGenerator.compileSpecificCMakeLists(objectName));
    }
    fsa.generateFile(
      "CMakeLists.txt", 
      OpcUaXmlCompilerMain.compileSrcGenCMakeLists(generateServer, generateClient));
    fsa.generateFile(
      "../CMakeLists.txt", 
      OpcUaXmlCompilerMain.compileTopLevelCMakeLists());
  }
  
  public static CharSequence compileSrcGenCMakeLists(final boolean hasServer, final boolean hasClient) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
    _builder.newLine();
    _builder.newLine();
    {
      if (hasServer) {
        _builder.append("# compile the test server");
        _builder.newLine();
        _builder.append("ADD_SUBDIRECTORY(server)");
        _builder.newLine();
      }
    }
    {
      if (hasClient) {
        _builder.append("# compile the test client");
        _builder.newLine();
        _builder.append("ADD_SUBDIRECTORY(client)");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public static CharSequence compileTopLevelCMakeLists() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("ADD_SUBDIRECTORY(src-gen)");
    _builder.newLine();
    return _builder;
  }
}
