/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServerImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PlainOpcUaStatusServer {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private CommObjectGenHelpers _commObjectGenHelpers;
    @Inject
    @Extension
    private ComponentGenHelpers _componentGenHelpers;
    @Inject
    @Extension
    private OpcUaServerImpl _opcUaServerImpl;
    @Inject
    @Extension
    private OpcUaObjectInterfaceImpl _opcUaObjectInterfaceImpl;
    @Inject
    @Extension
    private OpcUaXmlParser _opcUaXmlParser;
    private int currentEntityId = 6000;

    public String getNameInstance(OpcUaReadServer server) {
        String _firstLower = StringExtensions.toFirstLower((String)server.getName());
        return String.valueOf(_firstLower) + "Controller";
    }

    public String getClassName(OpcUaReadServer server) {
        String _firstUpper = StringExtensions.toFirstUpper((String)server.getName());
        return String.valueOf(_firstUpper) + "Controller";
    }

    public String getServerControllerHeaderFileName(OpcUaReadServer server) {
        String _name = server.getName();
        return String.valueOf(_name) + "Controller.hh";
    }

    public String getServerControllerSourceFileName(OpcUaReadServer server) {
        String _name = server.getName();
        return String.valueOf(_name) + "Controller.cc";
    }

    public void compilePlainOpcUaReadServer(OpcUaReadServer server, IFileSystemAccess2 fsa) {
        Collection objects = ComponentDefinitionModelUtility.getAllCommObjects((ComponentPort)server.getOutPort());
        CommunicationObject communicationObject = (CommunicationObject)IterableExtensions.head((Iterable)objects);
        if (communicationObject != null) {
            this.currentEntityId = 6000;
            ArrayList<OpcUaXmlParser.SeRoNetENTITY> _arrayList = new ArrayList<OpcUaXmlParser.SeRoNetENTITY>();
            Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList = this.getEntityList(communicationObject, "", "", _arrayList);
            ArrayList methodList = new ArrayList();
            String _name = server.getName();
            String _plus = String.valueOf(_name) + ".xml";
            fsa.generateFile(_plus, this.compileReadServerXMLFileContent(server, entityList));
            fsa.generateFile(this._opcUaObjectInterfaceImpl.getOpcUaDevice_Interface_HeaderFileName(server.getName()), this._opcUaObjectInterfaceImpl.compileOpcUaDevice_Interface_HeaderFileContent(server.getName(), entityList, methodList));
            fsa.generateFile(this._opcUaServerImpl.getOpcUaDevice_Server_HeaderFileName(server.getName()), this._opcUaServerImpl.compileOpcUaDevice_Server_HeaderFileContent(server.getName(), entityList, methodList));
            fsa.generateFile(this._opcUaServerImpl.getOpcUaDevice_Server_SourceFileName(server.getName()), this._opcUaServerImpl.compileOpcUaDevice_Server_SourceFileContent(server.getName(), entityList, methodList));
            fsa.generateFile(this.getServerControllerHeaderFileName(server), this.compileServerControllerHeader(server, communicationObject, entityList));
            fsa.generateFile(this.getServerControllerSourceFileName(server), this.compileServerControllerSource(server, communicationObject, entityList));
        }
    }

    private Iterable<OpcUaXmlParser.SeRoNetENTITY> getEntityList(CommunicationObject object, String parentName, String parentCommObjectCall, List<OpcUaXmlParser.SeRoNetENTITY> result) {
        EList _attributes = object.getAttributes();
        for (AttributeDefinition attribute : _attributes) {
            boolean _notEquals_1;
            AbstractCommElement typeName;
            OpcUaXmlParser.SeRoNetENTITY entity = new OpcUaXmlParser.SeRoNetENTITY();
            entity.userAccessLevel = 1;
            AbstractAttributeType type = attribute.getType();
            if (type instanceof PrimitiveType) {
                OpcUaXmlParser.SeRoNetNodeId _seRoNetNodeId_1;
                int _plusPlus;
                OpcUaXmlParser.SeRoNetNodeId _seRoNetNodeId;
                boolean _tripleNotEquals_1;
                PRIMITIVE_TYPE_NAME _typeName;
                boolean _equals;
                boolean _notEquals;
                boolean bl = _notEquals = !Objects.equal((Object)parentName, (Object)"");
                if (_notEquals) {
                    String _plus_1;
                    String _plus;
                    String _name = attribute.getName();
                    entity.name = _plus = String.valueOf(parentName) + "_" + _name;
                    String _firstUpper = StringExtensions.toFirstUpper((String)attribute.getName());
                    entity.commObjectCall = _plus_1 = String.valueOf(parentCommObjectCall) + ".get" + _firstUpper;
                } else {
                    String _plus_2;
                    entity.name = attribute.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)attribute.getName());
                    entity.commObjectCall = _plus_2 = ".get" + _firstUpper_1;
                }
                ArrayType _array = ((PrimitiveType)type).getArray();
                boolean _tripleNotEquals = _array != null;
                entity.commObjectCall = _tripleNotEquals ? String.valueOf(entity.commObjectCall) + "Ref()" : String.valueOf(entity.commObjectCall) + "()";
                entity.type = Objects.equal((Object)((PrimitiveType)type).getTypeName(), (Object)PRIMITIVE_TYPE_NAME.BOOLEAN) || Objects.equal((Object)((PrimitiveType)type).getTypeName(), (Object)PRIMITIVE_TYPE_NAME.INT32) || Objects.equal((Object)((PrimitiveType)type).getTypeName(), (Object)PRIMITIVE_TYPE_NAME.DOUBLE) || Objects.equal((Object)((PrimitiveType)type).getTypeName(), (Object)PRIMITIVE_TYPE_NAME.STRING) ? ((PrimitiveType)type).getTypeName().getLiteral() : ((_equals = Objects.equal((Object)(_typeName = ((PrimitiveType)type).getTypeName()), (Object)PRIMITIVE_TYPE_NAME.FLOAT)) ? "Double" : "Int32");
                ArrayType _array_1 = ((PrimitiveType)type).getArray();
                boolean bl2 = _tripleNotEquals_1 = _array_1 != null;
                if (_tripleNotEquals_1) {
                    entity.type = "std::vector<" + entity.type + ">";
                }
                entity.nodeid = _seRoNetNodeId = new OpcUaXmlParser.SeRoNetNodeId();
                ++this.currentEntityId;
                entity.nodeid.i = _plusPlus;
                entity.Parent_nodeid = _seRoNetNodeId_1 = new OpcUaXmlParser.SeRoNetNodeId();
                entity.Parent_nodeid.i = 1001;
                result.add(entity);
                continue;
            }
            if (!(type instanceof CommElementReference) || !((typeName = ((CommElementReference)type).getTypeName()) instanceof CommunicationObject)) continue;
            boolean bl = _notEquals_1 = !Objects.equal((Object)parentName, (Object)"");
            if (_notEquals_1) {
                String _name_1 = attribute.getName();
                String currentName = String.valueOf(parentName) + "_" + _name_1;
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)attribute.getName());
                String currentCommObjectCall = String.valueOf(parentCommObjectCall) + ".get" + _firstUpper_2;
                ArrayType _array_2 = ((CommElementReference)type).getArray();
                boolean _tripleNotEquals_2 = _array_2 != null;
                currentCommObjectCall = _tripleNotEquals_2 ? String.valueOf(currentCommObjectCall) + "Ref()" : String.valueOf(currentCommObjectCall) + "()";
                this.getEntityList((CommunicationObject)typeName, currentName, currentCommObjectCall, result);
                continue;
            }
            String _firstUpper_3 = StringExtensions.toFirstUpper((String)attribute.getName());
            String currentCommObjectCall_1 = ".get" + _firstUpper_3;
            ArrayType _array_3 = ((CommElementReference)type).getArray();
            boolean _tripleNotEquals_3 = _array_3 != null;
            currentCommObjectCall_1 = _tripleNotEquals_3 ? String.valueOf(currentCommObjectCall_1) + "Ref()" : String.valueOf(currentCommObjectCall_1) + "()";
            this.getEntityList((CommunicationObject)typeName, attribute.getName(), currentCommObjectCall_1, result);
        }
        return result;
    }

    private CharSequence compileReadServerXMLFileContent(OpcUaReadServer server, Iterable<OpcUaXmlParser.SeRoNetENTITY> entitiesReadServer) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--");
        _builder.newLine();
        String _replace = this._copyrightHelpers.getCopyright().replace("-", "").replace("//", "");
        _builder.append(_replace);
        _builder.newLineIfNotEmpty();
        _builder.append("-->");
        _builder.newLine();
        _builder.append("<UANodeSet xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("xmlns:uax=\"http://opcfoundation.org/UA/2008/02/Types.xsd\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("xmlns=\"http://opcfoundation.org/UA/2011/03/UANodeSet.xsd\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("xmlns:s1=\"http://yourorganisation.org/example_nodeset/\"");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<NamespaceUris>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Uri>http://http://opcfoundation.org/UA/SeRoNet");
        String _firstUpper = StringExtensions.toFirstUpper((String)server.getName());
        _builder.append(_firstUpper, "\t\t");
        _builder.append("/</Uri>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</NamespaceUris>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<Aliases>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"Boolean\">i=1</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"UInt32\">i=7</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"String\">i=12</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"HasModellingRule\">i=37</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"HasTypeDefinition\">i=40</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"HasSubtype\">i=45</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"HasProperty\">i=46</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"HasComponent\">i=47</Alias>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Alias Alias=\"Argument\">i=296</Alias>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</Aliases>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<Extensions>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Extension>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<ModelInfo Tool=\"UaModeler\" Hash=\"Zs8w1AQI71W8P/GOk3k/xQ==\" Version=\"1.3.4\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</Extension>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</Extensions>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<UAReferenceType NodeId=\"ns=1;i=4001\" BrowseName=\"1:providesInputTo\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<DisplayName>providesInputTo</DisplayName>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<References>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<Reference ReferenceType=\"HasSubtype\" IsForward=\"false\">i=33</Reference>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</References>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<InverseName Locale=\"en-US\">inputProcidedBy</InverseName>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</UAReferenceType>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<UAObjectType IsAbstract=\"true\" NodeId=\"ns=1;i=1001\"");
        _builder.newLine();
        _builder.append("\t              ");
        _builder.append("BrowseName=\"1:");
        String _name = server.getName();
        _builder.append(_name, "\t              ");
        _builder.append("\">");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    ");
        _builder.append("<DisplayName>");
        String _name_1 = server.getName();
        _builder.append(_name_1, "\t    ");
        _builder.append("</DisplayName>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    ");
        _builder.append("<References>");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("<Reference ReferenceType=\"HasSubtype\" IsForward=\"false\">");
        _builder.newLine();
        _builder.append("\t            ");
        _builder.append("i=58");
        _builder.newLine();
        _builder.append("\t        ");
        _builder.append("</Reference>");
        _builder.newLine();
        for (OpcUaXmlParser.SeRoNetENTITY en : entitiesReadServer) {
            _builder.append("\t        ");
            _builder.append("<Reference ReferenceType=\"HasComponent\">ns=1;i=");
            _builder.append((Object)en.nodeid.i, "\t        ");
            _builder.append("</Reference>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t    ");
        _builder.append("</References>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</UAObjectType>");
        _builder.newLine();
        for (OpcUaXmlParser.SeRoNetENTITY en_1 : entitiesReadServer) {
            _builder.append("\t");
            _builder.append("<!--                                    ");
            _builder.append(en_1.name, "\t");
            _builder.append("     -->");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<UAVariable DataType=\"");
            _builder.append(en_1.type, "\t");
            _builder.append("\" ParentNodeId=\"ns=1;i=1001\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("        ");
            _builder.append("NodeId=\"ns=1;i=");
            _builder.append((Object)en_1.nodeid.i, "\t        ");
            _builder.append("\" BrowseName=\"1:");
            _builder.append(en_1.name, "\t        ");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("        ");
            _builder.append("UserAccessLevel=\"1\" AccessLevel=\"1\">");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("<DisplayName>");
            _builder.append(en_1.name, "\t");
            _builder.append("</DisplayName>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<References>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("<Reference ReferenceType=\"HasTypeDefinition\">i=63</Reference>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("<Reference ReferenceType=\"HasModellingRule\">i=78</Reference>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("<Reference ReferenceType=\"HasComponent\" IsForward=\"false\">");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("        ");
            _builder.append("ns=1;i=1001");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("    ");
            _builder.append("</Reference>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("</References>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("</UAVariable>");
            _builder.newLine();
        }
        _builder.append("</UANodeSet>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileServerControllerHeader(OpcUaReadServer server, CommunicationObject commObj, Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#ifndef ");
        String _upperCase = server.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("CONTROLLER_H_");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        String _upperCase_1 = server.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("CONTROLLER_H_");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// C++11 mutex");
        _builder.newLine();
        _builder.append("#include <mutex>");
        _builder.newLine();
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.append("#include \"");
        String _opcUaDevice_Interface_HeaderFileName = this._opcUaObjectInterfaceImpl.getOpcUaDevice_Interface_HeaderFileName(server.getName());
        _builder.append(_opcUaDevice_Interface_HeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _opcUaDevice_Server_HeaderFileName = this._opcUaServerImpl.getOpcUaDevice_Server_HeaderFileName(server.getName());
        _builder.append(_opcUaDevice_Server_HeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include <");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(commObj);
        _builder.append((Object)_userClassHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("namespace OPCUA {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* This class implements the Controller part of the Model-View-Controller (MVC)");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* design pattern. As a second responsibility, this class also implements");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* the generated interface which is used by the internally initialized OPC UA");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* server to interact with the actual model. The actual model can be internally");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* accessed over the given view pointer. Conceptually, this class decouples");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* the OPC UA server from the Model and handles the lifecycle of the OPC UA server.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("class ");
        String _className = this.getClassName(server);
        _builder.append(_className);
        _builder.append(" : public ");
        String _name = server.getName();
        _builder.append(_name);
        _builder.append("Interface, public SmartACE::Task");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// the internal OPC UA server");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("OPCUA::");
        String _name_1 = server.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" server;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// a copy of the most recent communication object");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mutable std::mutex object_mutex;");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(commObj);
        _builder.append((Object)_fullyQualifiedNameCpp, "\t");
        _builder.append(" ");
        String _name_2 = server.getName();
        _builder.append(_name_2, "\t");
        _builder.append("Object;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/// implementing the SmartACE::Task");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int task_execution();");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _className_1 = this.getClassName(server);
        _builder.append(_className_1, "\t");
        _builder.append("(Smart::IComponent *component, const unsigned short &portNumber=4840);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual ~");
        String _className_2 = this.getClassName(server);
        _builder.append(_className_2, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/// allows updating the internal communication-object copy");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void put(");
        String _commObjectsParameterList = this._componentGenHelpers.getCommObjectsParameterList(server.getOutPort());
        _builder.append(_commObjectsParameterList, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// override stop method from SmartACE::Task base class (to stop internal GenricServer)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual int stop(const bool wait_till_stopped=true) override;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        for (OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
            _builder.append("\t");
            _builder.append("/** XML Specific Getter function for entity ");
            _builder.append(entity.name, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  This function gets ");
            _builder.append(entity.name, "\t ");
            _builder.append("  from the Server");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  When class ");
            String _name_3 = server.getName();
            _builder.append(_name_3, "\t ");
            _builder.append(" is used with a Specific XML file to connect to");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  SeRoNet Servers which implements the device information model.");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  @param value\t\t\t:Value that was read (when status code true)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  @return status code");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*    - true    : Entity was found and the value was read correctly");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*    - false   : Entity was not found or the value was not read correctly");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("virtual OPCUA::StatusCode get");
            String _firstUpper = StringExtensions.toFirstUpper((String)entity.name);
            _builder.append(_firstUpper, "\t");
            _builder.append("(");
            String _cppType = this._opcUaXmlParser.getCppType(entity.type);
            _builder.append(_cppType, "\t");
            _builder.append(" &value) const;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("} /* namespace OPCUA */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /* ");
        String _upperCase_2 = server.getName().toUpperCase();
        _builder.append(_upperCase_2);
        _builder.append("CONTROLLER_H_ */");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence compileServerControllerSource(OpcUaReadServer server, CommunicationObject commObj, Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include \"");
        String _serverControllerHeaderFileName = this.getServerControllerHeaderFileName(server);
        _builder.append(_serverControllerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("using namespace OPCUA;");
        _builder.newLine();
        _builder.newLine();
        String _className = this.getClassName(server);
        _builder.append(_className);
        _builder.append("::");
        String _className_1 = this.getClassName(server);
        _builder.append(_className_1);
        _builder.append("(Smart::IComponent *component, const unsigned short &portNumber)");
        _builder.newLineIfNotEmpty();
        _builder.append(":\tSmartACE::Task(component)");
        _builder.newLine();
        _builder.append(",\tserver(this, portNumber, false)");
        _builder.newLine();
        _builder.append("{  }");
        _builder.newLine();
        _builder.newLine();
        String _className_2 = this.getClassName(server);
        _builder.append(_className_2);
        _builder.append("::~");
        String _className_3 = this.getClassName(server);
        _builder.append(_className_3);
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("{  }");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _className_4 = this.getClassName(server);
        _builder.append(_className_4);
        _builder.append("::put(");
        String _commObjectsParameterList = this._componentGenHelpers.getCommObjectsParameterList(server.getOutPort());
        _builder.append(_commObjectsParameterList);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("std::unique_lock<std::mutex> lock(object_mutex);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->");
        String _name = server.getName();
        _builder.append(_name, "\t");
        _builder.append("Object = ");
        String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)server.getOutPort());
        _builder.append(_nameInstance, "\t");
        _builder.append("DataObject;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("int ");
        String _className_5 = this.getClassName(server);
        _builder.append(_className_5);
        _builder.append("::stop(const bool wait_till_stopped) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this->server.signalStop();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return SmartACE::Task::stop(wait_till_stopped);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("//Getter methods for all OPCUA Entity nodes.\t\t");
        _builder.newLine();
        for (OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
            _builder.append("OPCUA::StatusCode ");
            String _className_6 = this.getClassName(server);
            _builder.append(_className_6);
            _builder.append("::get");
            String _firstUpper = StringExtensions.toFirstUpper((String)entity.name);
            _builder.append(_firstUpper);
            _builder.append("(");
            String _cppType = this._opcUaXmlParser.getCppType(entity.type);
            _builder.append(_cppType);
            _builder.append(" &value) const");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("std::unique_lock<std::mutex> lock(object_mutex);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("value = ");
            String _name_1 = server.getName();
            _builder.append(_name_1, "\t");
            _builder.append("Object");
            _builder.append(entity.commObjectCall, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return OPCUA::StatusCode::ALL_OK;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("int ");
        String _className_7 = this.getClassName(server);
        _builder.append(_className_7);
        _builder.append("::task_execution()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// this call executes the OPCUA server (until it is killed)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return server.run();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

