/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtext.behavior.taskDefinition.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinition;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionModel;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionRepository;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2.BasicAttributesFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class TaskDefinitionFormatter extends BasicAttributesFormatter {
  protected void _format(final TaskDefinitionModel taskDefinitionModel, @Extension final IFormattableDocument document) {
    document.<TaskDefinitionRepository>format(taskDefinitionModel.getRepository());
  }
  
  protected void _format(final TaskDefinitionRepository taskDefinitionRepository, @Extension final IFormattableDocument document) {
    EList<TaskDefinition> _tasks = taskDefinitionRepository.getTasks();
    for (final TaskDefinition taskDefinition : _tasks) {
      document.<TaskDefinition>format(taskDefinition);
    }
  }
  
  public void format(final Object taskDefinitionModel, final IFormattableDocument document) {
    if (taskDefinitionModel instanceof XtextResource) {
      _format((XtextResource)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel instanceof AttributeDefinition) {
      _format((AttributeDefinition)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel instanceof AttributeRefinement) {
      _format((AttributeRefinement)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel instanceof TaskDefinitionModel) {
      _format((TaskDefinitionModel)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel instanceof TaskDefinitionRepository) {
      _format((TaskDefinitionRepository)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel instanceof EObject) {
      _format((EObject)taskDefinitionModel, document);
      return;
    } else if (taskDefinitionModel == null) {
      _format((Void)null, document);
      return;
    } else if (taskDefinitionModel != null) {
      _format(taskDefinitionModel, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(taskDefinitionModel, document).toString());
    }
  }
}
