/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.linux;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public class DebianTerminalLauncher
implements ILaunchConfigurationDelegate {
    public static final String LAUNCHER_ID = "org.eclipse.smartmdsd.ui.debianTerminalLauncher";
    public static final String ATTR_PROJECT_NAME = "org.eclipse.smartmdsd.ui.debianTerminalLauncher.projectName";
    public static final String ATTR_WORKING_DIR = "org.eclipse.smartmdsd.ui.debianTerminalLauncher.rootWorkingDir";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute(ATTR_PROJECT_NAME, "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && project.isOpen()) {
            IResource resource;
            String workingDirString = configuration.getAttribute(ATTR_WORKING_DIR, "");
            IPath workingDir = null;
            workingDir = workingDirString.contentEquals("") ? project.getLocation() : ((resource = project.findMember(workingDirString)) instanceof IContainer ? resource.getLocation() : resource.getParent().getLocation());
            if (!workingDir.isEmpty() && Platform.getOS().contentEquals("linux")) {
                String teminalCommand = "x-terminal-emulator";
                String[] commands = new String[]{teminalCommand};
                Process terminalProcess = DebugPlugin.exec((String[])commands, (File)workingDir.toFile());
                DebugPlugin.newProcess((ILaunch)launch, (Process)terminalProcess, (String)teminalCommand);
            }
        }
    }
}

