/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureHelpers;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleSmartMDSDNatureHandler
extends AbstractHandler {
    public static final String NATURE_PARAMETER = "org.eclipse.smartmdsd.ui.natureParameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection;
        String natureId = event.getParameter(NATURE_PARAMETER);
        SmartMDSDNatureEnum natureEnum = SmartMDSDNatureEnum.getFromID(natureId);
        if (natureEnum != null && (currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)currentSelection).getFirstElement();
            IAdapterManager adapterManager = Platform.getAdapterManager();
            IResource resource = (IResource)adapterManager.getAdapter(firstElement, IResource.class);
            if (resource != null) {
                this.toggleNature(resource.getProject(), natureId, null);
            }
        }
        return null;
    }

    private void toggleNature(IProject project, String natureId, IProgressMonitor monitor) {
        try {
            IProjectDescription description = project.getDescription();
            if (description.hasNature(natureId)) {
                SmartMDSDNatureHelpers.removeProjectNature(project, natureId, monitor);
            } else {
                SmartMDSDNatureHelpers.addProjectNature(project, natureId, monitor);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

