/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui.quickfix;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetFactory;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetModel;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.TechnologyReadinessLevel;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.validation.GenericDatasheetValidator;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class GenericDatasheetQuickfixProvider extends DefaultQuickfixProvider {
  @Fix(GenericDatasheetValidator.INVALID_SPDX_URI)
  public void fixSPDXURI(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    final String text = ("Fix semantic URI using SPDX ID " + _get);
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final DatasheetProperty property = ((DatasheetProperty) element);
      String _get_1 = issue.getData()[0];
      String _plus = ("https://spdx.org/licenses/" + _get_1);
      final String spdx_uri = (_plus + ".html");
      property.setSemanticID(spdx_uri);
    };
    acceptor.accept(issue, text, text, null, _function);
  }
  
  @Fix(GenericDatasheetValidator.INVALID_TRL_VALUE)
  public void fixTRLValue(final Issue issue, final IssueResolutionAcceptor acceptor) {
    for (final TechnologyReadinessLevel trl : TechnologyReadinessLevel.VALUES) {
      {
        String _literal = trl.getLiteral();
        final String text = ("Change value to " + _literal);
        final ISemanticModification _function = (EObject element, IModificationContext context) -> {
          final DatasheetProperty property = ((DatasheetProperty) element);
          property.setValue(trl.getLiteral());
        };
        acceptor.accept(issue, text, text, null, _function);
      }
    }
  }
  
  @Fix(GenericDatasheetValidator.UNDEFINED_BASE_URI)
  public void addDefaultBaseURI(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final String text = "Create default Base URI http://www.servicerobotik-ulm.de";
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final GenericDatasheetModel model = ((GenericDatasheetModel) element);
      final MandatoryDatasheetElement baseURI = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
      baseURI.setName(MandatoryDatasheetElementNames.BASE_URI);
      baseURI.setValue("http://www.servicerobotik-ulm.de");
      model.getElements().add(baseURI);
    };
    acceptor.accept(issue, text, text, null, _function);
  }
  
  @Fix(GenericDatasheetValidator.UNDEFINED_SHORT_DESCRIPTION)
  public void addDefaultShortDescription(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final String text = "Create default short description";
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final GenericDatasheetModel model = ((GenericDatasheetModel) element);
      final MandatoryDatasheetElement description = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
      description.setName(MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
      String _segment = model.eResource().getURI().segment(1);
      String _plus = ("TODO: add short description for " + _segment);
      description.setValue(_plus);
      model.getElements().add(description);
    };
    acceptor.accept(issue, text, text, null, _function);
  }
}
