/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.skillDefinition.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.service.skillDefinition.SkillDefinitionRuntimeModule;
import org.eclipse.smartmdsd.xtext.service.skillDefinition.SkillDefinitionStandaloneSetup;
import org.eclipse.smartmdsd.xtext.service.skillDefinition.ide.SkillDefinitionIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class SkillDefinitionIdeSetup extends SkillDefinitionStandaloneSetup {
  @Override
  public Injector createInjector() {
    SkillDefinitionRuntimeModule _skillDefinitionRuntimeModule = new SkillDefinitionRuntimeModule();
    SkillDefinitionIdeModule _skillDefinitionIdeModule = new SkillDefinitionIdeModule();
    return Guice.createInjector(Modules2.mixin(_skillDefinitionRuntimeModule, _skillDefinitionIdeModule));
  }
}
