/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.behavior.generator.system;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.SkillRealization;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.SkillRealizationsRef;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillResult;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class SkillJsonGeneratorImpl extends AbstractGenerator {
  @Inject
  private DefaultDeclarativeQualifiedNameProvider fqn;
  
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<SystemComponentArchitecture> _filter = Iterables.<SystemComponentArchitecture>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), SystemComponentArchitecture.class);
    for (final SystemComponentArchitecture model : _filter) {
      String _name = model.getName();
      String _plus = (_name + ".skills.json");
      fsa.generateFile(_plus, this.compileJson(model));
    }
  }
  
  public CharSequence compileJson(final SystemComponentArchitecture model) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      EList<ComponentInstance> _components = model.getComponents();
      for(final ComponentInstance comp : _components) {
        {
          Iterable<CoordinationSlavePort> _filter = Iterables.<CoordinationSlavePort>filter(comp.getComponent().getElements(), CoordinationSlavePort.class);
          for(final CoordinationSlavePort slave : _filter) {
            {
              Iterable<SkillRealizationsRef> _filter_1 = Iterables.<SkillRealizationsRef>filter(slave.getElements(), SkillRealizationsRef.class);
              for(final SkillRealizationsRef skillSet : _filter_1) {
                _builder.append("[");
                _builder.newLine();
                {
                  EList<SkillRealization> _skills = skillSet.getSkillRealizationCoordModuleRef().getSkills();
                  for(final SkillRealization skill : _skills) {
                    _builder.append("{\"skill\" :");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("{ ");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\"name\" : \"");
                    String _name = skill.getSkillDef().getName();
                    _builder.append(_name, "\t\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\"skill-definition-fqn\" : \"");
                    QualifiedName _fullyQualifiedName = this.fqn.getFullyQualifiedName(skill.getSkillDef());
                    _builder.append(_fullyQualifiedName, "\t\t");
                    _builder.append("\",");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\"in-attribute\" : {");
                    _builder.newLine();
                    {
                      EList<AttributeDefinition> _inAttribute = skill.getSkillDef().getInAttribute();
                      for(final AttributeDefinition inAttr : _inAttribute) {
                        _builder.append("\t\t\t");
                        _builder.append("\"");
                        String _name_1 = inAttr.getName();
                        _builder.append(_name_1, "\t\t\t");
                        _builder.append("\" : \"");
                        String _typeString = this.getTypeString(inAttr.getType());
                        _builder.append(_typeString, "\t\t\t");
                        _builder.append("\"");
                        {
                          AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(skill.getSkillDef().getInAttribute());
                          boolean _notEquals = (!Objects.equal(inAttr, _last));
                          if (_notEquals) {
                            _builder.append(",");
                          }
                        }
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("},");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\"out-attribute\" : {");
                    _builder.newLine();
                    {
                      EList<AttributeDefinition> _outAttribute = skill.getSkillDef().getOutAttribute();
                      for(final AttributeDefinition outAttr : _outAttribute) {
                        _builder.append("\t\t\t");
                        _builder.append("\"");
                        String _name_2 = outAttr.getName();
                        _builder.append(_name_2, "\t\t\t");
                        _builder.append("\" : \"");
                        String _typeString_1 = this.getTypeString(outAttr.getType());
                        _builder.append(_typeString_1, "\t\t\t");
                        _builder.append("\"");
                        {
                          AttributeDefinition _last_1 = IterableExtensions.<AttributeDefinition>last(skill.getSkillDef().getOutAttribute());
                          boolean _notEquals_1 = (!Objects.equal(outAttr, _last_1));
                          if (_notEquals_1) {
                            _builder.append(",");
                          }
                        }
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("},");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\"results\" : [ ");
                    _builder.newLine();
                    {
                      EList<SkillResult> _results = skill.getSkillDef().getResults();
                      for(final SkillResult result : _results) {
                        _builder.append("\t\t\t");
                        _builder.append("{ \"result\" : \"");
                        String _literal = result.getResult().getLiteral();
                        _builder.append(_literal, "\t\t\t");
                        _builder.append("\", \"result-value\" : \"");
                        String _resultValue = result.getResultValue();
                        _builder.append(_resultValue, "\t\t\t");
                        _builder.append("\" }");
                        {
                          SkillResult _last_2 = IterableExtensions.<SkillResult>last(skill.getSkillDef().getResults());
                          boolean _notEquals_2 = (!Objects.equal(result, _last_2));
                          if (_notEquals_2) {
                            _builder.append(",");
                          }
                        }
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("]");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    {
                      SkillRealization _last_3 = IterableExtensions.<SkillRealization>last(skillSet.getSkillRealizationCoordModuleRef().getSkills());
                      boolean _notEquals_3 = (!Objects.equal(skill, _last_3));
                      if (_notEquals_3) {
                        _builder.append(",");
                      }
                    }
                    _builder.newLineIfNotEmpty();
                  }
                }
                _builder.append("]");
                _builder.newLine();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public String getTypeString(final AbstractAttributeType attrType) {
    if ((attrType instanceof PrimitiveType)) {
      final PRIMITIVE_TYPE_NAME typeName = ((PrimitiveType)attrType).getTypeName();
      boolean _equals = Objects.equal(typeName, PRIMITIVE_TYPE_NAME.DOUBLE);
      if (_equals) {
        return "Double";
      } else {
        boolean _equals_1 = Objects.equal(typeName, PRIMITIVE_TYPE_NAME.FLOAT);
        if (_equals_1) {
          return "Double";
        } else {
          boolean _equals_2 = Objects.equal(typeName, PRIMITIVE_TYPE_NAME.STRING);
          if (_equals_2) {
            return "String";
          } else {
            boolean _equals_3 = Objects.equal(typeName, PRIMITIVE_TYPE_NAME.BOOLEAN);
            if (_equals_3) {
              return "Bool";
            } else {
              return "Int";
            }
          }
        }
      }
    }
    return null;
  }
}
