/********************************************************************************
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 ********************************************************************************/
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;

public class ExtendedOutputConfigurationProvider implements IOutputConfigurationProvider {
	public final static String PLAIN_OPCUA_OUTPUT = "PLAIN_OPCUA_OUTPUT";
	public final static String SRC_OUTPUT = "SRC_OUTPUT";
	public final static String PROJECT_ROOT_FOLDER = "PROJECT_ROOT_FOLDER";

	/**
	 * @return a set of {@link OutputConfiguration} available for the generator
	 */
	public Set<OutputConfiguration> getOutputConfigurations() {
		OutputConfiguration defaultOutput = new OutputConfiguration(
				IFileSystemAccess.DEFAULT_OUTPUT);
		defaultOutput.setDescription("Output Folder");
		defaultOutput.setOutputDirectory("./plainOpcUa/src-gen");
		defaultOutput.setOverrideExistingResources(true);
		defaultOutput.setCreateOutputDirectory(true);
		defaultOutput.setCleanUpDerivedResources(true);
		defaultOutput.setSetDerivedProperty(true);
		
		OutputConfiguration plainOpcUaOutput = new OutputConfiguration(
				PLAIN_OPCUA_OUTPUT);
		plainOpcUaOutput.setDescription("Output Folder for Custom Code");
		plainOpcUaOutput.setOutputDirectory("./plainOpcUa");
		plainOpcUaOutput.setOverrideExistingResources(false);
		plainOpcUaOutput.setCreateOutputDirectory(true);
		plainOpcUaOutput.setCleanUpDerivedResources(false);
		plainOpcUaOutput.setSetDerivedProperty(false);
		
		OutputConfiguration srcOutput = new OutputConfiguration(
				SRC_OUTPUT);
		srcOutput.setDescription("Output Folder for Custom Code");
		srcOutput.setOutputDirectory("./plainOpcUa/src");
		srcOutput.setOverrideExistingResources(false);
		srcOutput.setCreateOutputDirectory(true);
		srcOutput.setCleanUpDerivedResources(false);
		srcOutput.setSetDerivedProperty(false);
		
		OutputConfiguration rootConfigOutput = new OutputConfiguration(
				PROJECT_ROOT_FOLDER);
		rootConfigOutput.setDescription("Project Root Output Folder");
		rootConfigOutput.setOutputDirectory("./");
		rootConfigOutput.setOverrideExistingResources(false);
		rootConfigOutput.setCreateOutputDirectory(false);
		rootConfigOutput.setCleanUpDerivedResources(false);
		rootConfigOutput.setSetDerivedProperty(false);
		
		HashSet<OutputConfiguration> configurations = new HashSet<OutputConfiguration>();
		configurations.add(defaultOutput);
		configurations.add(plainOpcUaOutput);
		configurations.add(srcOutput);
		configurations.add(rootConfigOutput);
		return configurations;
	}

}
