/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.InteractionObserver;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class SmartInputHandler {
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private InteractionObserver _interactionObserver;
  
  public String InputHandlerHeaderFileName(final InputHandler h) {
    String _nameClass = this._componentGenHelpers.nameClass(h);
    return (_nameClass + "Core.hh");
  }
  
  public String InputHandlerSourceFileName(final InputHandler h) {
    String _nameClass = this._componentGenHelpers.nameClass(h);
    return (_nameClass + "Core.cc");
  }
  
  public String InputHandlerUserHeaderFileName(final InputHandler h) {
    String _nameClass = this._componentGenHelpers.nameClass(h);
    return (_nameClass + ".hh");
  }
  
  public String InputHandlerUserSourceFileName(final InputHandler h) {
    String _nameClass = this._componentGenHelpers.nameClass(h);
    return (_nameClass + ".cc");
  }
  
  public String UpcallInterfaceHeaderFileName(final InputPort p) {
    String _nameClass = this._componentGenHelpers.nameClass(p);
    return (_nameClass + "UpcallInterface.hh");
  }
  
  public String UpcallManagerHeaderFileName(final InputPort p) {
    String _nameClass = this._componentGenHelpers.nameClass(p);
    return (_nameClass + "UpcallManager.hh");
  }
  
  public String UpcallManagerSourceFileName(final InputPort p) {
    String _nameClass = this._componentGenHelpers.nameClass(p);
    return (_nameClass + "UpcallManager.cc");
  }
  
  public void CreateSmartInputHandlers(final ComponentDefinition component, final IFileSystemAccess2 fsa) {
    Iterable<InputPort> _filter = Iterables.<InputPort>filter(component.getElements(), InputPort.class);
    for (final InputPort input : _filter) {
      {
        fsa.generateFile(this.UpcallInterfaceHeaderFileName(input), this.UpcallInterfaceHeaderFileContent(input));
        fsa.generateFile(this.UpcallManagerHeaderFileName(input), this.UpcallManagerHeaderFileContent(input));
        fsa.generateFile(this.UpcallManagerSourceFileName(input), this.UpcallManagerSourceFileContent(input));
      }
    }
    Iterable<InputHandler> _filter_1 = Iterables.<InputHandler>filter(component.getElements(), InputHandler.class);
    for (final InputHandler handler : _filter_1) {
      {
        fsa.generateFile(this.InputHandlerHeaderFileName(handler), this.InputHandlerHeaderFileContent(handler));
        fsa.generateFile(this.InputHandlerSourceFileName(handler), this.InputHandlerSourceFileContent(handler));
        fsa.generateFile(this.InputHandlerUserHeaderFileName(handler), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.TaskUserHeaderFileContent(handler));
        fsa.generateFile(this.InputHandlerUserSourceFileName(handler), ExtendedOutputConfigurationProvider.SRC_OUTPUT, this.InputHandlerUserSourceFileContent(handler));
      }
    }
  }
  
  public CharSequence UpcallInterfaceHeaderFileContent(final InputPort port) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = port.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_UPCALL_INTERFACE_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = port.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_UPCALL_INTERFACE_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<Map.Entry<String, CommunicationObject>, String> _function = (Map.Entry<String, CommunicationObject> it) -> {
        return it.getValue().getName();
      };
      List<Map.Entry<String, CommunicationObject>> _sortBy = IterableExtensions.<Map.Entry<String, CommunicationObject>, String>sortBy(this._componentGenHelpers.getCommunicationObjects(port).entrySet(), _function);
      for(final Map.Entry<String, CommunicationObject> obj : _sortBy) {
        _builder.append("#include \"");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj.getValue());
        _builder.append(_userClassHeaderFileNameFQN);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass);
    _builder.append("UpcallInterface {");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _nameClass_1 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_1, "\t");
    _builder.append("UpcallInterface() {  }");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void on_");
    String _name = port.getName();
    _builder.append(_name, "\t");
    _builder.append("(const ");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject, "\t");
    _builder.append(" &input) = 0;");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence UpcallManagerHeaderFileContent(final InputPort port) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = port.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_UPCALL_MANAGER_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = port.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_UPCALL_MANAGER_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <list>");
    _builder.newLine();
    _builder.append("#include \"aceSmartSoft.hh\"");
    _builder.newLine();
    _builder.append("#include \"");
    String _UpcallInterfaceHeaderFileName = this.UpcallInterfaceHeaderFileName(port);
    _builder.append(_UpcallInterfaceHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/** ");
    String _nameClass = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass);
    _builder.append("UpcallManager connects input-handling with Upcall propagation");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This class implements an InputHandler for the InputPort ");
    String _name = port.getName();
    _builder.append(_name, " ");
    _builder.append(" and propagates the handling ");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("* of incoming data to all associated (i.e. attached) Upcalls.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("class ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_1);
    _builder.append("UpcallManager");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tpublic Smart::IInputHandler<");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// list of associated updalls");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::list<");
    String _nameClass_2 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_2, "\t");
    _builder.append("UpcallInterface*> upcalls;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// call the on_");
    String _name_1 = port.getName();
    _builder.append(_name_1, "\t");
    _builder.append(" of all the attached ");
    String _nameClass_3 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_3, "\t");
    _builder.append("UpcallInterfaces");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("void notify_upcalls(const ");
    CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject_1, "\t");
    _builder.append(" &input);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("protected:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void handle_input(const ");
    CharSequence _inputHandlerCommObject_2 = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject_2, "\t");
    _builder.append(" &input) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// relay input-handling to all attached ");
    String _nameClass_4 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_4, "\t\t");
    _builder.append("UpcallInterfaces");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this->notify_upcalls(input);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _nameClass_5 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_5, "\t");
    _builder.append("UpcallManager(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("Smart::InputSubject<");
    CharSequence _inputHandlerCommObject_3 = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject_3, "\t\t");
    _builder.append("> *subject,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("const int &prescaleFactor=1");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(");");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _nameClass_6 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_6, "\t");
    _builder.append("UpcallManager();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void attach(");
    String _nameClass_7 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_7, "\t");
    _builder.append("UpcallInterface *upcall);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("void detach(");
    String _nameClass_8 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_8, "\t");
    _builder.append("UpcallInterface *upcall);");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence UpcallManagerSourceFileContent(final InputPort port) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _UpcallManagerHeaderFileName = this.UpcallManagerHeaderFileName(port);
    _builder.append(_UpcallManagerHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _nameClass = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass);
    _builder.append("UpcallManager::");
    String _nameClass_1 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_1);
    _builder.append("UpcallManager(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Smart::InputSubject<");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject, "\t");
    _builder.append("> *subject,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("const int &prescaleFactor)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(":\tSmart::IInputHandler<");
    CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject_1, "\t");
    _builder.append(">(subject, prescaleFactor)");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    String _nameClass_2 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_2);
    _builder.append("UpcallManager::~");
    String _nameClass_3 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_3);
    _builder.append("UpcallManager()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_4 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_4);
    _builder.append("UpcallManager::notify_upcalls(const ");
    CharSequence _inputHandlerCommObject_2 = this._componentGenHelpers.getInputHandlerCommObject(port);
    _builder.append(_inputHandlerCommObject_2);
    _builder.append(" &input)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for(auto it=upcalls.begin(); it!=upcalls.end(); it++) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("(*it)->on_");
    String _name = port.getName();
    _builder.append(_name, "\t\t");
    _builder.append("(input);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_5 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_5);
    _builder.append("UpcallManager::attach(");
    String _nameClass_6 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_6);
    _builder.append("UpcallInterface *upcall)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("upcalls.push_back(upcall);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_7 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_7);
    _builder.append("UpcallManager::detach(");
    String _nameClass_8 = this._componentGenHelpers.nameClass(port);
    _builder.append(_nameClass_8);
    _builder.append("UpcallInterface *upcall)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("upcalls.remove(upcall);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  private InputPort getInput(final InputHandler handler) {
    return handler.getInputPort();
  }
  
  public CharSequence InputHandlerHeaderFileContent(final InputHandler handler) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = this._componentGenHelpers.nameClass(handler).toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_CORE_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = this._componentGenHelpers.nameClass(handler).toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_CORE_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <aceSmartSoft.hh>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// include the main input-handler interface");
    _builder.newLine();
    _builder.append("#include \"");
    String _UpcallInterfaceHeaderFileName = this.UpcallInterfaceHeaderFileName(this.getInput(handler));
    _builder.append(_UpcallInterfaceHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("// include all other input interfaces (if any)");
    _builder.newLine();
    {
      final Function1<InputPortLink, String> _function = (InputPortLink it) -> {
        return it.getName();
      };
      List<InputPortLink> _sortBy = IterableExtensions.<InputPortLink, String>sortBy(ComponentDefinitionModelUtility.getInputLinks(handler), _function);
      for(final InputPortLink inLink : _sortBy) {
        _builder.append("#include \"");
        String _UpcallInterfaceHeaderFileName_1 = this.UpcallInterfaceHeaderFileName(inLink.getInputPort());
        _builder.append(_UpcallInterfaceHeaderFileName_1);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("// include all interaction-observer interfaces");
    _builder.newLine();
    _builder.append("#include <");
    String _nodeObserverInterfaceHeaderFileName = this._interactionObserver.getNodeObserverInterfaceHeaderFileName(handler);
    _builder.append(_nodeObserverInterfaceHeaderFileName);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    {
      final Function1<ComponentSubNodeObserver, String> _function_1 = (ComponentSubNodeObserver it) -> {
        return this._componentGenHelpers.getNameClass(it);
      };
      List<ComponentSubNodeObserver> _sortBy_1 = IterableExtensions.<ComponentSubNodeObserver, String>sortBy(ComponentDefinitionModelUtility.getObservers(handler), _function_1);
      for(final ComponentSubNodeObserver obs : _sortBy_1) {
        _builder.append("#include <");
        String _nodeObserverInterfaceHeaderFileName_1 = this._interactionObserver.getNodeObserverInterfaceHeaderFileName(obs.getSubject());
        _builder.append(_nodeObserverInterfaceHeaderFileName_1);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass);
    _builder.append("Core");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tpublic Smart::InputTaskTrigger<");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    {
      final Function1<ComponentSubNodeObserver, String> _function_2 = (ComponentSubNodeObserver it) -> {
        return this._componentGenHelpers.getNameClass(it);
      };
      List<ComponentSubNodeObserver> _sortBy_2 = IterableExtensions.<ComponentSubNodeObserver, String>sortBy(ComponentDefinitionModelUtility.getObservers(handler), _function_2);
      for(final ComponentSubNodeObserver obs_1 : _sortBy_2) {
        _builder.append(",\tpublic ");
        String _nodeObserverInterfaceClassName = this._interactionObserver.getNodeObserverInterfaceClassName(obs_1.getSubject());
        _builder.append(_nodeObserverInterfaceClassName);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append(",\tpublic ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(this.getInput(handler));
    _builder.append(_nameClass_1);
    _builder.append("UpcallInterface");
    _builder.newLineIfNotEmpty();
    {
      final Function1<InputPortLink, String> _function_3 = (InputPortLink it) -> {
        return it.getName();
      };
      List<InputPortLink> _sortBy_3 = IterableExtensions.<InputPortLink, String>sortBy(ComponentDefinitionModelUtility.getInputLinks(handler), _function_3);
      for(final InputPortLink inLink_1 : _sortBy_3) {
        _builder.append(",\tpublic ");
        String _nameClass_2 = this._componentGenHelpers.nameClass(inLink_1.getInputPort());
        _builder.append(_nameClass_2);
        _builder.append("UpcallInterface");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Smart::StatusCode updateStatus;");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_1, "\t");
    _builder.append(" lastUpdate;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<InputPortLink, String> _function_4 = (InputPortLink it) -> {
        return it.getName();
      };
      List<InputPortLink> _sortBy_4 = IterableExtensions.<InputPortLink, String>sortBy(ComponentDefinitionModelUtility.getInputLinks(handler), _function_4);
      for(final InputPortLink inLink_2 : _sortBy_4) {
        _builder.append("\t");
        _builder.append("Smart::StatusCode ");
        String _nameInstance = this._componentGenHelpers.nameInstance(inLink_2.getInputPort());
        _builder.append(_nameInstance, "\t");
        _builder.append("Status;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _inputHandlerCommObject_2 = this._componentGenHelpers.getInputHandlerCommObject(inLink_2.getInputPort());
        _builder.append(_inputHandlerCommObject_2, "\t");
        _builder.append(" ");
        String _nameInstance_1 = this._componentGenHelpers.nameInstance(inLink_2.getInputPort());
        _builder.append(_nameInstance_1, "\t");
        _builder.append("Object;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void updateAllCommObjects();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// internal input handling method");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void handle_input(const ");
    CharSequence _inputHandlerCommObject_3 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_3, "\t");
    _builder.append("& input) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("this->updateAllCommObjects();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// call the input handler method (which has to be implemented in derived classes)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this->on_");
    String _name = this.getInput(handler).getName();
    _builder.append(_name, "\t\t");
    _builder.append("(input);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("// notify all attached interaction observers");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this->notify_all_interaction_observers();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// call implementation of base class");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Smart::InputTaskTrigger<");
    CharSequence _inputHandlerCommObject_4 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_4, "\t\t");
    _builder.append(">::handle_input(input);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    CharSequence _compileNodeSubjectHeader = this._interactionObserver.compileNodeSubjectHeader(handler);
    _builder.append(_compileNodeSubjectHeader);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("protected:");
    _builder.newLine();
    {
      final Function1<ComponentSubNodeObserver, String> _function_5 = (ComponentSubNodeObserver it) -> {
        return it.getName();
      };
      List<ComponentSubNodeObserver> _sortBy_5 = IterableExtensions.<ComponentSubNodeObserver, String>sortBy(ComponentDefinitionModelUtility.getObservers(handler), _function_5);
      for(final ComponentSubNodeObserver obs_2 : _sortBy_5) {
        _builder.append("\t");
        _builder.append("// overload this method in derived classes!");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void on_update_from(const ");
        String _nameClass_3 = this._componentGenHelpers.nameClass(obs_2.getSubject());
        _builder.append(_nameClass_3, "\t");
        _builder.append("* subject) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// no-op");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      final Function1<InputPortLink, InputPort> _function_6 = (InputPortLink it) -> {
        return it.getInputPort();
      };
      final Function1<InputPort, String> _function_7 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_6 = IterableExtensions.<InputPort, String>sortBy(IterableExtensions.<InputPortLink, InputPort>map(ComponentDefinitionModelUtility.getInputLinks(handler), _function_6), _function_7);
      for(final InputPort input : _sortBy_6) {
        _builder.append("\t");
        _builder.append("// overload and implement this method in derived classes to immediately get all incoming updates from ");
        String _name_1 = input.getName();
        _builder.append(_name_1, "\t");
        _builder.append(" (as soon as they arrive)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual void on_");
        String _name_2 = input.getName();
        _builder.append(_name_2, "\t");
        _builder.append("(const ");
        CharSequence _inputHandlerCommObject_5 = this._componentGenHelpers.getInputHandlerCommObject(input);
        _builder.append(_inputHandlerCommObject_5, "\t");
        _builder.append(" &input) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// no-op");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// this method can be safely used from the thread in derived classes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inline Smart::StatusCode ");
        String _nameInstance_2 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_2, "\t");
        _builder.append("GetUpdate(");
        CharSequence _inputHandlerCommObject_6 = this._componentGenHelpers.getInputHandlerCommObject(input);
        _builder.append(_inputHandlerCommObject_6, "\t");
        _builder.append(" &");
        String _nameInstance_3 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_3, "\t");
        _builder.append("Object) const");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// copy local object buffer and return the last status code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t");
        String _nameInstance_4 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_4, "\t\t");
        _builder.append("Object = this->");
        String _nameInstance_5 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_5, "\t\t");
        _builder.append("Object;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return ");
        String _nameInstance_6 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_6, "\t\t");
        _builder.append("Status;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _nameClass_4 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_4, "\t");
    _builder.append("Core(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("Smart::InputSubject<");
    CharSequence _inputHandlerCommObject_7 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_7, "\t\t");
    _builder.append("> *subject,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("const int &prescaleFactor=1);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _nameClass_5 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_5, "\t");
    _builder.append("Core();");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence InputHandlerSourceFileContent(final InputHandler handler) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _InputHandlerHeaderFileName = this.InputHandlerHeaderFileName(handler);
    _builder.append(_InputHandlerHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _InputHandlerUserHeaderFileName = this.InputHandlerUserHeaderFileName(handler);
    _builder.append(_InputHandlerUserHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _nameClass = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass);
    _builder.append("Core::");
    String _nameClass_1 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_1);
    _builder.append("Core(");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Smart::InputSubject<");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject, "\t");
    _builder.append("> *subject,");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("const int &prescaleFactor)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(":\tSmart::InputTaskTrigger<");
    CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_1, "\t");
    _builder.append(">(subject, prescaleFactor)");
    _builder.newLineIfNotEmpty();
    {
      final Function1<InputPortLink, String> _function = (InputPortLink it) -> {
        return it.getName();
      };
      List<InputPortLink> _sortBy = IterableExtensions.<InputPortLink, String>sortBy(ComponentDefinitionModelUtility.getInputLinks(handler), _function);
      for(final InputPortLink inLink : _sortBy) {
        _builder.append("\t");
        _builder.append(",\t");
        String _nameInstance = this._componentGenHelpers.nameInstance(inLink.getInputPort());
        _builder.append(_nameInstance, "\t");
        _builder.append("Status(Smart::SMART_DISCONNECTED)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(",\t");
        String _nameInstance_1 = this._componentGenHelpers.nameInstance(inLink.getInputPort());
        _builder.append(_nameInstance_1, "\t");
        _builder.append("Object()");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("{  ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("updateStatus = Smart::SMART_NODATA;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    String _nameClass_2 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_2);
    _builder.append("Core::~");
    String _nameClass_3 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_3);
    _builder.append("Core()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_4 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_4);
    _builder.append("Core::updateAllCommObjects() {");
    _builder.newLineIfNotEmpty();
    {
      final Function1<InputPortLink, InputPort> _function_1 = (InputPortLink it) -> {
        return it.getInputPort();
      };
      final Function1<InputPort, String> _function_2 = (InputPort it) -> {
        return it.getName();
      };
      List<InputPort> _sortBy_1 = IterableExtensions.<InputPort, String>sortBy(IterableExtensions.<InputPortLink, InputPort>map(ComponentDefinitionModelUtility.getInputLinks(handler), _function_1), _function_2);
      for(final InputPort input : _sortBy_1) {
        _builder.append("\t");
        String _nameInstance_2 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_2, "\t");
        _builder.append("Status = COMP->");
        String _nameInstance_3 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_3, "\t");
        _builder.append("InputTaskTrigger->getUpdate(");
        String _nameInstance_4 = this._componentGenHelpers.nameInstance(input);
        _builder.append(_nameInstance_4, "\t");
        _builder.append("Object);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _compileNodeSubjectSource = this._interactionObserver.compileNodeSubjectSource(handler);
    _builder.append(_compileNodeSubjectSource);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence TaskUserHeaderFileContent(final InputHandler handler) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#ifndef _");
    String _upperCase = this._componentGenHelpers.nameClass(handler).toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = this._componentGenHelpers.nameClass(handler).toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _InputHandlerHeaderFileName = this.InputHandlerHeaderFileName(handler);
    _builder.append(_InputHandlerHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass);
    _builder.append("  : public ");
    String _nameClass_1 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_1);
    _builder.append("Core");
    _builder.newLineIfNotEmpty();
    _builder.append("{\t\t");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _nameClass_2 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_2, "\t");
    _builder.append("(Smart::InputSubject<");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject, "\t");
    _builder.append("> *subject, const int &prescaleFactor=1);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _nameClass_3 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_3, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void on_");
    String _name = this.getInput(handler).getName();
    _builder.append(_name, "\t");
    _builder.append("(const ");
    CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_1, "\t");
    _builder.append(" &input);");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence InputHandlerUserSourceFileContent(final InputHandler handler) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
    _builder.append(_copyrightWriteOnce);
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _InputHandlerUserHeaderFileName = this.InputHandlerUserHeaderFileName(handler);
    _builder.append(_InputHandlerUserHeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <iostream>");
    _builder.newLine();
    _builder.newLine();
    String _nameClass = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass);
    _builder.append("::");
    String _nameClass_1 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_1);
    _builder.append("(Smart::InputSubject<");
    CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject);
    _builder.append("> *subject, const int &prescaleFactor)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\t");
    String _nameClass_2 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_2);
    _builder.append("Core(subject, prescaleFactor)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"constructor ");
    String _nameClass_3 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_3, "\t");
    _builder.append("\\n\";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    String _nameClass_4 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_4);
    _builder.append("::~");
    String _nameClass_5 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_5);
    _builder.append("() ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("std::cout << \"destructor ");
    String _nameClass_6 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_6, "\t");
    _builder.append("\\n\";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _nameClass_7 = this._componentGenHelpers.nameClass(handler);
    _builder.append(_nameClass_7);
    _builder.append("::on_");
    String _name = this.getInput(handler).getName();
    _builder.append(_name);
    _builder.append("(const ");
    CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject(this.getInput(handler));
    _builder.append(_inputHandlerCommObject_1);
    _builder.append(" &input)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// implement business logic here");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// (do not use blocking calls here, otherwise this might block the InputPort ");
    String _name_1 = this.getInput(handler).getName();
    _builder.append(_name_1, "\t");
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
