/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.system;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultInputTrigger;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultTrigger;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.AbstractInputNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.AbstractSourceNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivationSource;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureModel;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityNode;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.CPUCore;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.DataFlow;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.DataTriggered;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.PeriodicTimer;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.Scheduler;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.Sporadic;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.TriggerInputNode;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ActivityConfigurationMapping;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ActivityConfig {
  public CharSequence compileActivityNode(final ActivityConfigurationMapping mapping) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _compile = this.compile(mapping.getConfig().getActivationSource(), mapping);
    _builder.append(_compile);
    _builder.newLineIfNotEmpty();
    {
      Scheduler _scheduler = mapping.getConfig().getScheduler();
      boolean _tripleNotEquals = (_scheduler != null);
      if (_tripleNotEquals) {
        _builder.append("scheduler ");
        String _literal = mapping.getConfig().getScheduler().getType().getLiteral();
        _builder.append(_literal);
        _builder.newLineIfNotEmpty();
        _builder.append("priority ");
        int _priority = mapping.getConfig().getScheduler().getPriority();
        _builder.append(_priority);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      CPUCore _affinity = mapping.getConfig().getAffinity();
      boolean _tripleNotEquals_1 = (_affinity != null);
      if (_tripleNotEquals_1) {
        _builder.append("cpuAffinity ");
        int _coreNumber = mapping.getConfig().getAffinity().getCoreNumber();
        _builder.append(_coreNumber);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _compile(final DataTriggered data, final ActivityConfigurationMapping mapping) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("triggerType DataTriggered");
    _builder.newLine();
    _builder.append("inPortRef ");
    ComponentPort _inputPort = this.getInputPort(mapping);
    String _name = null;
    if (_inputPort!=null) {
      _name=_inputPort.getName();
    }
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.append("prescale ");
    int _prescale = data.getPrescale();
    _builder.append(_prescale);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _compile(final PeriodicTimer timer, final ActivityConfigurationMapping mapping) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("triggerType PeriodicTimer");
    _builder.newLine();
    _builder.append("periodicActFreqHz ");
    double _periodicActFreq = timer.getPeriodicActFreq();
    _builder.append(_periodicActFreq);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _compile(final Sporadic timer, final ActivityConfigurationMapping mapping) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("triggerType Sporadic");
    _builder.newLine();
    _builder.append("minActFreqHz ");
    double _minActFreq = timer.getMinActFreq();
    _builder.append(_minActFreq);
    _builder.newLineIfNotEmpty();
    _builder.append("maxActFreqHz ");
    double _maxActFreq = timer.getMaxActFreq();
    _builder.append(_maxActFreq);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public ComponentPort getInputPort(final ActivityConfigurationMapping mapping) {
    final AbstractSourceNode sourceNode = this.getSourceNode(mapping);
    if ((sourceNode instanceof ActivityNode)) {
      final EObject componentInstance = mapping.eContainer();
      if ((componentInstance instanceof ComponentInstance)) {
        final EObject systemModel = ((ComponentInstance)componentInstance).eContainer();
        if ((systemModel instanceof SystemComponentArchitecture)) {
          EList<ServiceInstance> _ports = ((ComponentInstance)componentInstance).getPorts();
          for (final ServiceInstance port : _ports) {
            final Function1<InputPortLink, Boolean> _function = (InputPortLink it) -> {
              InputPort _inputPort = it.getInputPort();
              ComponentPort _port = port.getPort();
              return Boolean.valueOf(Objects.equal(_inputPort, _port));
            };
            boolean _exists = IterableExtensions.<InputPortLink>exists(ComponentDefinitionModelUtility.getInputLinks(mapping.getActivity()), _function);
            if (_exists) {
              final Function1<Connection, Boolean> _function_1 = (Connection it) -> {
                RequiredService _from = it.getFrom();
                return Boolean.valueOf(Objects.equal(_from, port));
              };
              final Connection connection = IterableExtensions.<Connection>findFirst(((SystemComponentArchitecture)systemModel).getConnections(), _function_1);
              if ((connection != null)) {
                final ComponentPort sourcePort = connection.getTo().getPort();
                EObject _eContainer = connection.getTo().eContainer();
                final ComponentInstance sourceComponent = ((ComponentInstance) _eContainer);
                if ((sourcePort instanceof OutputPort)) {
                  final Activity sourceActivity = ((OutputPort)sourcePort).getActivity();
                  Iterable<ActivityConfigurationMapping> _filter = Iterables.<ActivityConfigurationMapping>filter(sourceComponent.getExtensions(), ActivityConfigurationMapping.class);
                  for (final ActivityConfigurationMapping sourceActMapping : _filter) {
                    if ((Objects.equal(sourceActMapping.getActivity(), sourceActivity) && Objects.equal(sourceActMapping.getConfig(), sourceNode))) {
                      return port.getPort();
                    }
                  }
                }
              }
            }
          }
        }
      }
    } else {
    }
    return null;
  }
  
  public AbstractSourceNode getSourceNode(final ActivityConfigurationMapping mapping) {
    final ActivationSource activationSource = mapping.getConfig().getActivationSource();
    if ((activationSource instanceof DataTriggered)) {
      final EObject actModel = mapping.getConfig().eContainer();
      if ((actModel instanceof ActivityArchitectureModel)) {
        final Function1<DataFlow, Boolean> _function = (DataFlow it) -> {
          AbstractInputNode _destination = it.getDestination();
          TriggerInputNode _triggerRef = ((DataTriggered)activationSource).getTriggerRef();
          return Boolean.valueOf(Objects.equal(_destination, _triggerRef));
        };
        final DataFlow df = IterableExtensions.<DataFlow>findFirst(Iterables.<DataFlow>filter(((ActivityArchitectureModel)actModel).getElements(), DataFlow.class), _function);
        if ((df != null)) {
          return df.getSource();
        }
      }
    }
    return null;
  }
  
  public CharSequence compileDefaultActivity(final Activity activity) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<ActivationConstraints, Boolean> _function = (ActivationConstraints it) -> {
        boolean _isConfigurable = it.isConfigurable();
        return Boolean.valueOf((_isConfigurable == false));
      };
      boolean _exists = IterableExtensions.<ActivationConstraints>exists(Iterables.<ActivationConstraints>filter(activity.getExtensions(), ActivationConstraints.class), _function);
      boolean _not = (!_exists);
      if (_not) {
        _builder.append("minActFreqHz ");
        Double _minActFreq = this.getMinActFreq(activity);
        _builder.append(_minActFreq);
        _builder.newLineIfNotEmpty();
        _builder.append("maxActFreqHz ");
        Double _maxActFreq = this.getMaxActFreq(activity);
        _builder.append(_maxActFreq);
        _builder.newLineIfNotEmpty();
        {
          Iterable<DefaultTrigger> _filter = Iterables.<DefaultTrigger>filter(activity.getExtensions(), DefaultTrigger.class);
          for(final DefaultTrigger trigger : _filter) {
            {
              if ((trigger instanceof DefaultPeriodicTimer)) {
                _builder.append("# setup default trigger as PeriodicTimer");
                _builder.newLine();
                _builder.append("triggerType PeriodicTimer");
                _builder.newLine();
                _builder.append("periodicActFreqHz ");
                double _periodicActFreq = ((DefaultPeriodicTimer)trigger).getPeriodicActFreq();
                _builder.append(_periodicActFreq);
                _builder.newLineIfNotEmpty();
              } else {
                if ((trigger instanceof DefaultInputTrigger)) {
                  _builder.append("# setup default trigger as DataTriggered");
                  _builder.newLine();
                  _builder.append("triggerType DataTriggered");
                  _builder.newLine();
                  _builder.append("inPortRef ");
                  String _name = ((DefaultInputTrigger)trigger).getInputLink().getInputPort().getName();
                  _builder.append(_name);
                  _builder.newLineIfNotEmpty();
                  _builder.append("prescale 1");
                  _builder.newLine();
                }
              }
            }
          }
        }
        _builder.append("# other trigger-types are:");
        _builder.newLine();
        _builder.append("#triggerType PeriodicTimer");
        _builder.newLine();
        _builder.append("#periodicActFreqHz ");
        Double _minActFreq_1 = this.getMinActFreq(activity);
        _builder.append(_minActFreq_1);
        _builder.newLineIfNotEmpty();
        _builder.append("# or alternatively:");
        _builder.newLine();
        _builder.append("#triggerType DataTriggered");
        _builder.newLine();
        _builder.append("#inPortRef <InPortName>");
        _builder.newLine();
        _builder.append("#prescale 1");
        _builder.newLine();
      }
    }
    _builder.append("# optional scheduling parameters");
    _builder.newLine();
    _builder.append("# scheduler FIFO");
    _builder.newLine();
    _builder.append("# priority 0");
    _builder.newLine();
    _builder.append("# cpuAffinity 0");
    _builder.newLine();
    return _builder;
  }
  
  public Double getMinActFreq(final Activity activity) {
    int _size = IterableExtensions.size(Iterables.<ActivationConstraints>filter(activity.getExtensions(), ActivationConstraints.class));
    boolean _equals = (_size == 0);
    if (_equals) {
      return Double.valueOf(0.0);
    } else {
      return Double.valueOf((((ActivationConstraints[])Conversions.unwrapArray((Iterables.<ActivationConstraints>filter(activity.getExtensions(), ActivationConstraints.class)), ActivationConstraints.class))[0]).getMinActFreq());
    }
  }
  
  public Double getMaxActFreq(final Activity activity) {
    int _size = IterableExtensions.size(Iterables.<ActivationConstraints>filter(activity.getExtensions(), ActivationConstraints.class));
    boolean _equals = (_size == 0);
    if (_equals) {
      return Double.valueOf(0.0);
    } else {
      return Double.valueOf((((ActivationConstraints[])Conversions.unwrapArray((Iterables.<ActivationConstraints>filter(activity.getExtensions(), ActivationConstraints.class)), ActivationConstraints.class))[0]).getMaxActFreq());
    }
  }
  
  public CharSequence compile(final ActivationSource data, final ActivityConfigurationMapping mapping) {
    if (data instanceof DataTriggered) {
      return _compile((DataTriggered)data, mapping);
    } else if (data instanceof PeriodicTimer) {
      return _compile((PeriodicTimer)data, mapping);
    } else if (data instanceof Sporadic) {
      return _compile((Sporadic)data, mapping);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(data, mapping).toString());
    }
  }
}
