/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.system.deployment.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentPackage;
import org.eclipse.smartmdsd.ecore.system.deployment.TargetPlatformReference;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.LoginAccount;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformDefinition;
import org.eclipse.smartmdsd.xtext.system.deployment.scoping.AbstractDeploymentScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class DeploymentScopeProvider extends AbstractDeploymentScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    IScope _xblockexpression = null;
    {
      final EObject parent = context.eContainer();
      boolean _equals = Objects.equal(reference, DeploymentPackage.Literals.LOGIN_ACCOUNT_SELECTION__LOGIN);
      if (_equals) {
        if ((parent instanceof TargetPlatformReference)) {
          TargetPlatformDefinition _platform = ((TargetPlatformReference)parent).getPlatform();
          boolean _tripleNotEquals = (_platform != null);
          if (_tripleNotEquals) {
            return Scopes.scopeFor(Iterables.<LoginAccount>filter(((TargetPlatformReference)parent).getPlatform().getElements(), LoginAccount.class));
          }
        }
      } else {
        boolean _equals_1 = Objects.equal(reference, DeploymentPackage.Literals.NETWORK_INTERFACE_SELECTION__NETWORK);
        if (_equals_1) {
          if ((parent instanceof TargetPlatformReference)) {
            TargetPlatformDefinition _platform_1 = ((TargetPlatformReference)parent).getPlatform();
            boolean _tripleNotEquals_1 = (_platform_1 != null);
            if (_tripleNotEquals_1) {
              return Scopes.scopeFor(Iterables.<NetworkInterface>filter(((TargetPlatformReference)parent).getPlatform().getElements(), NetworkInterface.class));
            }
          }
        } else {
          boolean _equals_2 = Objects.equal(reference, DeploymentPackage.Literals.COMPONENT_ARTEFACT__COMPONENT);
          if (_equals_2) {
            if ((parent instanceof DeploymentModel)) {
              SystemComponentArchitecture _componentArch = ((DeploymentModel)parent).getComponentArch();
              boolean _tripleNotEquals_2 = (_componentArch != null);
              if (_tripleNotEquals_2) {
                return Scopes.scopeFor(((DeploymentModel)parent).getComponentArch().getComponents());
              }
            }
          }
        }
      }
      _xblockexpression = super.getScope(context, reference);
    }
    return _xblockexpression;
  }
}
