/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.base.basicAttributes;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BoolValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.FloatingPointValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.IntValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.StringValue;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BasicAttributesStyledLabelProvider {
    public String getValueString(AbstractValue av) {
        String _switchResult = null;
        boolean _matched = false;
        if (av instanceof IntValue) {
            _matched = true;
            _switchResult = Integer.valueOf(((IntValue)av).getValue()).toString();
        }
        if (!_matched && av instanceof FloatingPointValue) {
            _matched = true;
            _switchResult = Double.valueOf(((FloatingPointValue)av).getValue()).toString();
        }
        if (!_matched && av instanceof StringValue) {
            _matched = true;
            _switchResult = ((StringValue)av).getValue();
        }
        if (!_matched && av instanceof BoolValue) {
            _matched = true;
            _switchResult = Boolean.valueOf(((BoolValue)av).isValue()).toString();
        }
        if (!_matched && av instanceof EnumerationValue) {
            _matched = true;
            _switchResult = ((EnumerationValue)av).getValue().getName();
        }
        if (!_matched && av instanceof ArrayValue) {
            _matched = true;
            EList<SingleValue> _values = ((ArrayValue)av).getValues();
            List _map = null;
            if (_values != null) {
                Functions.Function1 _function = it -> this.getValueString((AbstractValue)it);
                _map = ListExtensions.map(_values, (Functions.Function1)_function);
            }
            String _join = IterableExtensions.join(_map, (CharSequence)", ");
            String _plus = "[" + _join;
            _switchResult = String.valueOf(_plus) + "]";
        }
        return _switchResult;
    }

    public String getTypeName(AbstractAttributeType attrType) {
        String _switchResult = null;
        boolean _matched = false;
        if (attrType instanceof PrimitiveType) {
            _matched = true;
            _switchResult = ((PrimitiveType)attrType).getTypeName().getLiteral();
        }
        if (!_matched && attrType instanceof InlineEnumerationType) {
            _matched = true;
            _switchResult = "InlineEnumeration";
        }
        return _switchResult;
    }

    public StyledString getEnumerationElementStyledString(EnumerationElement en) {
        boolean _notEquals;
        String _name = en.getName();
        StyledString text = new StyledString(_name, StyledString.QUALIFIER_STYLER);
        int _value = en.getValue();
        boolean bl = _notEquals = _value != 0;
        if (_notEquals) {
            String _string = Integer.valueOf(en.getValue()).toString();
            String _plus = " = " + _string;
            StyledString _styledString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            text.append(_styledString);
        }
        return text;
    }

    public StyledString getAttributeStyledString(AttributeDefinition attr) {
        AbstractValue _defaultvalue;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals;
        String _name = attr.getName();
        StyledString text = new StyledString(_name, StyledString.QUALIFIER_STYLER);
        AbstractAttributeType _type = attr.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            String _typeName = this.getTypeName(attr.getType());
            String _plus = ": " + _typeName;
            StyledString typeString = new StyledString(_plus, StyledString.DECORATIONS_STYLER);
            text.append(typeString);
            ArrayType _array = attr.getType().getArray();
            boolean bl2 = _tripleNotEquals_1 = _array != null;
            if (_tripleNotEquals_1) {
                boolean _tripleNotEquals_2;
                String arrayString = " [";
                String _length = attr.getType().getArray().getLength();
                boolean bl3 = _tripleNotEquals_2 = _length != null;
                if (_tripleNotEquals_2) {
                    String _plus_1;
                    String _length_1 = attr.getType().getArray().getLength();
                    arrayString = _plus_1 = String.valueOf(arrayString) + _length_1;
                }
                arrayString = String.valueOf(arrayString) + "]";
                StyledString _styledString = new StyledString(arrayString, StyledString.DECORATIONS_STYLER);
                text.append(_styledString);
            }
        }
        boolean bl4 = _tripleNotEquals_3 = (_defaultvalue = attr.getDefaultvalue()) != null;
        if (_tripleNotEquals_3) {
            String _valueString = this.getValueString(attr.getDefaultvalue());
            String _plus_2 = " = " + _valueString;
            StyledString attrValueString = new StyledString(_plus_2, StyledString.QUALIFIER_STYLER);
            text.append(attrValueString);
        }
        return text;
    }
}

