/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.behavior.skillRealization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventMode implements Enumerator
{
    CONTINUOUS(0, "continuous", "continuous"),
    SINGLE(1, "single", "single");

    public static final int CONTINUOUS_VALUE = 0;
    public static final int SINGLE_VALUE = 1;
    private static final EventMode[] VALUES_ARRAY;
    public static final List<EventMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventMode[]{CONTINUOUS, SINGLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventMode get(int value) {
        switch (value) {
            case 0: {
                return CONTINUOUS;
            }
            case 1: {
                return SINGLE;
            }
        }
        return null;
    }

    private EventMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

