/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator;

import com.google.inject.Injector;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mwe.utils.DirectoryCleaner;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;

public class GeneratorHelper {
    private final IProject project;
    private Injector injector;

    public GeneratorHelper(Injector injector, Resource resource) {
        this.injector = injector;
        this.project = GeneratorHelper.getCurrentProjectFrom(resource);
    }

    public static IProject getCurrentProjectFrom(Resource resource) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(resource.getURI().segment(1));
    }

    public void createFolder(String outputConfigName) {
        GeneratorHelper.createFolder(outputConfigName, this.injector, this.project);
    }

    public static void createFolder(String outputConfigName, Injector specificInjector, IProject specificProject) {
        OutputConfiguration config = GeneratorHelper.getOutputConfiguration(outputConfigName, specificInjector);
        if (config != null) {
            String folderStr = config.getOutputDirectory();
            IFolder ifolder = specificProject.getFolder(folderStr);
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (!ifolder.exists()) {
                    ifolder.create(true, true, (IProgressMonitor)monitor);
                }
                ifolder.setDerived(config.isSetDerivedProperty(), (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteFolder(String outputConfigName) {
        GeneratorHelper.deleteFolder(outputConfigName, this.injector, this.project);
    }

    public static void deleteFolder(String outputConfigName, Injector specificInjector, IProject specificProject) {
        OutputConfiguration config = GeneratorHelper.getOutputConfiguration(outputConfigName, specificInjector);
        if (config != null) {
            String folderStr = config.getOutputDirectory();
            IFolder ifolder = specificProject.getFolder(folderStr);
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (ifolder.exists()) {
                    ifolder.delete(true, (IProgressMonitor)monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void invokeDirectoryCleaner() {
        GeneratorHelper.invokeDirectoryCleaner(this.injector, this.project);
    }

    public static void invokeDirectoryCleaner(Injector specificInjector, IProject specificProject) {
        GeneratorHelper.invokeDirectoryCleaner("DEFAULT_OUTPUT", Collections.emptyList(), specificInjector, specificProject);
    }

    public void invokeDirectoryCleaner(String outputConfigName) {
        GeneratorHelper.invokeDirectoryCleaner(outputConfigName, this.injector, this.project);
    }

    public static void invokeDirectoryCleaner(String outputConfigName, Injector specificInjector, IProject specificProject) {
        GeneratorHelper.invokeDirectoryCleaner(outputConfigName, Collections.emptyList(), specificInjector, specificProject);
    }

    public void invokeDirectoryCleaner(String outputConfigName, Collection<String> excludes) {
        GeneratorHelper.invokeDirectoryCleaner(outputConfigName, excludes, this.injector, this.project);
    }

    public static void invokeDirectoryCleaner(String outputConfigName, Collection<String> excludes, Injector specificInjector, IProject specificProject) {
        DirectoryCleaner directoryCleaner = new DirectoryCleaner();
        for (String exclude : excludes) {
            directoryCleaner.addExclude(exclude);
        }
        OutputConfiguration config = GeneratorHelper.getOutputConfiguration(outputConfigName, specificInjector);
        if (config != null) {
            IFolder genFolder = specificProject.getFolder(config.getOutputDirectory());
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (!genFolder.exists()) {
                    genFolder.create(true, true, (IProgressMonitor)monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            try {
                directoryCleaner.cleanFolder(genFolder.getLocation().toString());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public IFileSystemAccess2 getConfiguredFileSystemAccess() {
        return this.getConfiguredFileSystemAccess(this.injector);
    }

    public IFileSystemAccess2 getConfiguredFileSystemAccess(Injector specificInjector) {
        return GeneratorHelper.getConfiguredFileSystemAccess(specificInjector, this.project);
    }

    public static IFileSystemAccess2 getConfiguredFileSystemAccess(Injector specificInjector, IProject specificProject) {
        JavaIoFileSystemAccess fsa = (JavaIoFileSystemAccess)specificInjector.getInstance(JavaIoFileSystemAccess.class);
        IOutputConfigurationProvider outCP = (IOutputConfigurationProvider)specificInjector.getInstance(IOutputConfigurationProvider.class);
        Set configs = outCP.getOutputConfigurations();
        HashMap<String, OutputConfiguration> outputs = new HashMap<String, OutputConfiguration>();
        for (OutputConfiguration c : configs) {
            outputs.put(c.getName(), c);
        }
        fsa.setOutputConfigurations(outputs);
        for (OutputConfiguration config : configs) {
            if (config.getName().equals("PROJECT_ROOT_FOLDER")) {
                fsa.setOutputPath(config.getName(), specificProject.getLocation().toString());
                continue;
            }
            String outputDirectory = config.getOutputDirectory();
            IFolder f = specificProject.getFolder(outputDirectory);
            fsa.setOutputPath(config.getName(), f.getLocation().toString());
        }
        return fsa;
    }

    public void refreshFolder(String outputConfigName, int depth) {
        GeneratorHelper.refreshFolder(outputConfigName, depth, this.injector, this.project);
    }

    public static void refreshFolder(String outputConfigName, int depth, Injector specificInjector, IProject specificProject) {
        OutputConfiguration config = GeneratorHelper.getOutputConfiguration(outputConfigName, specificInjector);
        if (config != null) {
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (config.getName().equals("PROJECT_ROOT_FOLDER")) {
                    specificProject.refreshLocal(2, (IProgressMonitor)monitor);
                } else {
                    specificProject.getFolder(config.getOutputDirectory()).refreshLocal(2, (IProgressMonitor)monitor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public OutputConfiguration getOutputConfiguration(String outputConfigName) {
        return GeneratorHelper.getOutputConfiguration(outputConfigName, this.injector);
    }

    public static OutputConfiguration getOutputConfiguration(String outputConfigName, Injector specificInjector) {
        IOutputConfigurationProvider outCP = (IOutputConfigurationProvider)specificInjector.getInstance(IOutputConfigurationProvider.class);
        Set configs = outCP.getOutputConfigurations();
        for (OutputConfiguration config : configs) {
            if (!config.getName().equals(outputConfigName)) continue;
            return config;
        }
        return null;
    }
}

