/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EnumerationGenerator {
    @Inject
    @Extension
    private CommObjectGenHelpers _commObjectGenHelpers;
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;

    public CharSequence compileEnumIDL(Enumeration en) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef ");
        CharSequence _enumIdlDefine = this._commObjectGenHelpers.getEnumIdlDefine(en);
        _builder.append((Object)_enumIdlDefine);
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        CharSequence _enumIdlDefine_1 = this._commObjectGenHelpers.getEnumIdlDefine(en);
        _builder.append((Object)_enumIdlDefine_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("//#include <ace/CDR_Stream.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)en);
        _builder.append((Object)_repoNamespace);
        _builder.append("IDL {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("typedef int ");
        CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileEnum(Enumeration en) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef ");
        CharSequence _enumDefine = this._commObjectGenHelpers.getEnumDefine(en);
        _builder.append((Object)_enumDefine);
        _builder.newLineIfNotEmpty();
        _builder.append("#define ");
        CharSequence _enumDefine_1 = this._commObjectGenHelpers.getEnumDefine(en);
        _builder.append((Object)_enumDefine_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)en);
        _builder.append((Object)_repoNamespace);
        _builder.append("/");
        CharSequence _enumIdlFileName = this._commObjectGenHelpers.getEnumIdlFileName(en);
        _builder.append((Object)_enumIdlFileName);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#include <string>");
        _builder.newLine();
        _builder.append("#include <iostream>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// SmartUtils used in from_xml method");
        _builder.newLine();
        _builder.append("#include \"smartKnuthMorrisPratt.hh\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)en);
        _builder.append((Object)_repoNamespace_1);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("class ");
        CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName, "\t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private:");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace((EObject)en);
        _builder.append((Object)_repoNamespace_2, "\t\t");
        _builder.append("IDL::");
        CharSequence _idlStructName_1 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_1, "\t\t");
        _builder.append(" value;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("enum ENUM_");
        CharSequence _idlStructName_2 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_2, "\t\t");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("ENUM_VALUE_UNDEFINED = 0,");
        _builder.newLine();
        _builder.append("\t\t\t");
        int counter = 0;
        _builder.newLineIfNotEmpty();
        EList _enums = en.getEnums();
        for (EnumerationElement el : _enums) {
            boolean _notEquals;
            _builder.append("\t\t\t");
            String _name = el.getName();
            _builder.append(_name, "\t\t\t");
            _builder.append(" = ");
            _builder.append((Object)(++counter), "\t\t\t");
            EnumerationElement _last = (EnumerationElement)IterableExtensions.last((Iterable)en.getEnums());
            boolean bl = _notEquals = !Objects.equal((Object)el, (Object)_last);
            if (_notEquals) {
                _builder.append(",");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// default constructor");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _idlStructName_3 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_3, "\t\t");
        _builder.append("() { ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("value = ENUM_VALUE_UNDEFINED;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// copy constructor for enum type");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _idlStructName_4 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_4, "\t\t");
        _builder.append("(ENUM_");
        CharSequence _idlStructName_5 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_5, "\t\t");
        _builder.append(" e) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("value = static_cast<int>(e);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// copy constructor for IDL type");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _idlStructName_6 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_6, "\t\t");
        _builder.append("(");
        CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace((EObject)en);
        _builder.append((Object)_repoNamespace_3, "\t\t");
        _builder.append("IDL::");
        CharSequence _idlStructName_7 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_7, "\t\t");
        _builder.append(" e) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("value = e;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//const ");
        CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace((EObject)en);
        _builder.append((Object)_repoNamespace_4, "\t\t");
        _builder.append("IDL::");
        CharSequence _idlStructName_8 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_8, "\t\t");
        _builder.append("& get() const { return value; }");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// ENUM operator");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("operator ENUM_");
        CharSequence _idlStructName_9 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_9, "\t\t");
        _builder.append("() const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return static_cast<ENUM_");
        CharSequence _idlStructName_10 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_10, "\t\t\t");
        _builder.append(">(value);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// compare operator");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("bool operator == (const ENUM_");
        CharSequence _idlStructName_11 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_11, "\t\t");
        _builder.append(" t) const {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("return this->value == t;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("std::string to_string() const {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("std::string result = \"\";");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("switch (value) {");
        _builder.newLine();
        EList _enums_1 = en.getEnums();
        for (EnumerationElement el_1 : _enums_1) {
            _builder.append("\t\t\t\t");
            _builder.append("case ");
            String _name_1 = el_1.getName();
            _builder.append(_name_1, "\t\t\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
            _builder.append("\t");
            _builder.append("result = \"");
            CharSequence _idlStructName_12 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
            _builder.append((Object)_idlStructName_12, "\t\t\t\t\t");
            _builder.append("::");
            String _name_2 = el_1.getName();
            _builder.append(_name_2, "\t\t\t\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("result = \"ENUM_VALUE_UNDEFINED\";");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// helper method to easily implement output stream");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("void to_ostream(std::ostream &os = std::cout) const {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("os << to_string();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// convert to xml stream");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("void to_xml(std::ostream &os, const std::string &indent = \"\") const {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("os << indent << \"<value>\" << value << \"</value>\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// restore from xml stream");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("void from_xml(std::istream &is) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("static const Smart::KnuthMorrisPratt kmp_value(\"<value>\");");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if(kmp_value.search(is)) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("is >> value;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("inline std::ostream &operator<<(std::ostream &os, const ");
        CharSequence _idlStructName_13 = this._commObjectGenHelpers.getIdlStructName((AbstractCommElement)en);
        _builder.append((Object)_idlStructName_13, "\t");
        _builder.append(" &e)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("e.to_ostream(os);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return os;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }
}

