/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.BehaviorNature;
import org.eclipse.smartmdsd.ui.natures.ComponentNature;
import org.eclipse.smartmdsd.ui.natures.DomainModelsNature;
import org.eclipse.smartmdsd.ui.natures.SystemNature;

public enum SmartMDSDNatureEnum {
    DomainModelsNature("org.eclipse.smartmdsd.ui.natures.DomainModelsNature"),
    ComponentNature("org.eclipse.smartmdsd.ui.natures.ComponentNature"),
    SystemNature("org.eclipse.smartmdsd.ui.natures.SystemNature"),
    BehaviorNature("org.eclipse.smartmdsd.ui.natures.BehaviorNature");

    private static final Map<String, SmartMDSDNatureEnum> lookup;
    private String natureId;

    static {
        lookup = new HashMap<String, SmartMDSDNatureEnum>();
        SmartMDSDNatureEnum[] smartMDSDNatureEnumArray = SmartMDSDNatureEnum.values();
        int n = smartMDSDNatureEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SmartMDSDNatureEnum nature = smartMDSDNatureEnumArray[n2];
            lookup.put(nature.getId(), nature);
            ++n2;
        }
    }

    public static SmartMDSDNatureEnum getFromID(String natureId) {
        return lookup.get(natureId);
    }

    private SmartMDSDNatureEnum(String natureId) {
        this.natureId = natureId;
    }

    public String getId() {
        return this.natureId;
    }

    public AbstractSmartMDSDNature getSmartMDSDNatureFrom(IProject project) throws CoreException {
        IProjectNature natureObject;
        if (project.hasNature(this.natureId) && (natureObject = project.getNature(this.natureId)) instanceof AbstractSmartMDSDNature) {
            return (AbstractSmartMDSDNature)natureObject;
        }
        return null;
    }

    public AbstractSmartMDSDNature createSmartMDSDNatureObject() {
        switch (this) {
            case DomainModelsNature: {
                return new DomainModelsNature();
            }
            case ComponentNature: {
                return new ComponentNature();
            }
            case SystemNature: {
                return new SystemNature();
            }
            case BehaviorNature: {
                return new BehaviorNature();
            }
        }
        return null;
    }
}

