/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.base.genericDatasheet.ui.quickfix;

import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetFactory;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetModel;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.TechnologyReadinessLevel;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class GenericDatasheetQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="invalidSpdxURI")
    public void fixSPDXURI(Issue issue, IssueResolutionAcceptor acceptor) {
        String _get = issue.getData()[0];
        String text = "Fix semantic URI using SPDX ID " + _get;
        ISemanticModification _function = (element, context) -> {
            DatasheetProperty property = (DatasheetProperty)element;
            String _get_1 = issue.getData()[0];
            String _plus = "https://spdx.org/licenses/" + _get_1;
            String spdx_uri = String.valueOf(_plus) + ".html";
            property.setSemanticID(spdx_uri);
        };
        acceptor.accept(issue, text, text, null, _function);
    }

    @Fix(value="invalidTRLValue")
    public void fixTRLValue(Issue issue, IssueResolutionAcceptor acceptor) {
        for (TechnologyReadinessLevel trl : TechnologyReadinessLevel.VALUES) {
            String _literal = trl.getLiteral();
            String text = "Change value to " + _literal;
            ISemanticModification _function = (element, context) -> {
                DatasheetProperty property = (DatasheetProperty)element;
                property.setValue(trl.getLiteral());
            };
            acceptor.accept(issue, text, text, null, _function);
        }
    }

    @Fix(value="undefinedBaseURI")
    public void addDefaultBaseURI(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            GenericDatasheetModel model = (GenericDatasheetModel)element;
            MandatoryDatasheetElement baseURI = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
            baseURI.setName(MandatoryDatasheetElementNames.BASE_URI);
            baseURI.setValue("http://www.servicerobotik-ulm.de");
            model.getElements().add((Object)baseURI);
        };
        acceptor.accept(issue, "Create default Base URI http://www.servicerobotik-ulm.de", "Create default Base URI http://www.servicerobotik-ulm.de", null, _function);
    }

    @Fix(value="undefinedShortDescription")
    public void addDefaultShortDescription(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            GenericDatasheetModel model = (GenericDatasheetModel)element;
            MandatoryDatasheetElement description = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
            description.setName(MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
            String _segment = model.eResource().getURI().segment(1);
            String _plus = "TODO: add short description for " + _segment;
            description.setValue(_plus);
            model.getElements().add((Object)description);
        };
        acceptor.accept(issue, "Create default short description", "Create default short description", null, _function);
    }
}

