/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.roboticMiddleware.ide;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.RoboticMiddlewareRuntimeModule;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.RoboticMiddlewareStandaloneSetup;
import org.eclipse.smartmdsd.xtext.service.roboticMiddleware.ide.RoboticMiddlewareIdeModule;
import org.eclipse.xtext.util.Modules2;

/**
 * Initialization support for running Xtext languages as language servers.
 */
@SuppressWarnings("all")
public class RoboticMiddlewareIdeSetup extends RoboticMiddlewareStandaloneSetup {
  @Override
  public Injector createInjector() {
    RoboticMiddlewareRuntimeModule _roboticMiddlewareRuntimeModule = new RoboticMiddlewareRuntimeModule();
    RoboticMiddlewareIdeModule _roboticMiddlewareIdeModule = new RoboticMiddlewareIdeModule();
    return Guice.createInjector(Modules2.mixin(_roboticMiddlewareRuntimeModule, _roboticMiddlewareIdeModule));
  }
}
