/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.setup.Info;
import org.eclipse.oomph.util.IOUtil;

public final class CertificateInfo
extends Info {
    public CertificateInfo(String string) {
        super(string);
    }

    public CertificateInfo(String uuid, String name) {
        super(uuid, name);
    }

    public CertificateInfo(Certificate certificate) {
        super(CertificateInfo.getUUID(certificate), CertificateInfo.getName(certificate));
    }

    private static String getUUID(Certificate certificate) {
        try {
            return XMLTypeFactory.eINSTANCE.convertBase64Binary(IOUtil.getSHA1((InputStream)new ByteArrayInputStream(certificate.getEncoded())));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getName(Certificate certificate) {
        return ((X509Certificate)certificate).getSubjectDN().getName();
    }
}

