/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePage;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleViewer;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleEvent;
import org.eclipse.cdt.internal.ui.buildconsole.GlobalBuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.IBuildConsoleStreamDecorator;
import org.eclipse.cdt.internal.ui.buildconsole.MultiBuildConsoleAdapter;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;
import org.osgi.service.prefs.Preferences;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener,
IPropertyChangeListener {
    static final String PREF_QUALIFIER = "org.eclipse.cdt.ui";
    public static final String KEY_KEEP_LOG = "keepLog";
    public static final String KEY_LOG_LOCATION = "logLocation";
    public static final boolean CONSOLE_KEEP_LOG_DEFAULT = true;
    private static final String BUILD_CONSOLE_NODE = "buildConsole";
    private static final String PROJECT_LOG_EXT = ".build.log";
    private ListenerList<IBuildConsoleListener> listeners = new ListenerList();
    private BuildConsole fConsole;
    private Map<IProject, BuildConsolePartitioner> fConsoleMap = new HashMap<IProject, BuildConsolePartitioner>();
    private Color infoColor;
    private Color outputColor;
    private Color errorColor;
    private Color backgroundColor;
    private Color problemHighlightedColor;
    private Color problemErrorBackgroundColor;
    private Color problemInfoBackgroundColor;
    private Color problemWarningBackgroundColor;
    private BuildConsoleStreamDecorator infoStream;
    private BuildConsoleStreamDecorator outputStream;
    private BuildConsoleStreamDecorator errorStream;
    private String fName;
    private String fContextMenuId;
    public static final int BUILD_STREAM_TYPE_INFO = 0;
    public static final int BUILD_STREAM_TYPE_OUTPUT = 1;
    public static final int BUILD_STREAM_TYPE_ERROR = 2;
    public static final String DEFAULT_CONTEXT_MENU_ID = "org.eclipse.cdt.ui.CDTBuildConsole";
    private IProject fLastProject;
    private IConsoleListener fConsoleListener;
    private final AtomicBoolean fWasClosed = new AtomicBoolean(false);

    public Color getProblemHighlightedColor() {
        return this.problemHighlightedColor;
    }

    public Color getProblemBackgroundColor() {
        return this.problemErrorBackgroundColor;
    }

    public Color getWarningBackgroundColor() {
        return this.problemWarningBackgroundColor;
    }

    public Color getInfoBackgroundColor() {
        return this.problemInfoBackgroundColor;
    }

    protected void startConsoleActivity(IProject project) {
        if (!this.listeners.isEmpty()) {
            for (IBuildConsoleListener listener : this.listeners) {
                ConsoleEvent event = new ConsoleEvent(this, project, 1);
                listener.consoleChange(event);
            }
        }
        this.showConsole(true);
    }

    protected void showConsole(boolean bringToTop) {
        IWorkbenchPage page;
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart consoleView = page.findView("org.eclipse.ui.console.ConsoleView");
            if (consoleView == null && BuildConsolePreferencePage.isAutoOpenConsole()) {
                IWorkbenchPart activePart = page.getActivePart();
                try {
                    consoleView = page.showView("org.eclipse.ui.console.ConsoleView");
                }
                catch (PartInitException pie) {
                    CUIPlugin.log(pie);
                }
                page.activate(activePart);
            }
            boolean shouldBringToTop = this.shouldBringToTop(consoleView);
            if (bringToTop && shouldBringToTop) {
                page.bringToTop((IWorkbenchPart)consoleView);
            }
            if (consoleView instanceof IConsoleView) {
                if (BuildConsole.getCurrentPage() == null) {
                    ((IConsoleView)consoleView).display((IConsole)this.fConsole);
                } else if (shouldBringToTop) {
                    ((IConsoleView)consoleView).display((IConsole)BuildConsole.getCurrentPage().getConsole());
                }
            }
        }
    }

    boolean shouldBringToTop(IViewPart consoleView) {
        boolean bringToTop = false;
        if (consoleView instanceof IConsoleView) {
            IConsoleView cView = (IConsoleView)consoleView;
            return !cView.isPinned() && BuildConsolePreferencePage.isConsoleOnTop();
        }
        return bringToTop;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IDocumentPartitioner partioner;
        IResource resource = event.getResource();
        if (resource != null && resource.getType() == 4 && (event.getType() == 4 || event.getType() == 2) && (partioner = (IDocumentPartitioner)this.fConsoleMap.remove(resource)) != null) {
            partioner.disconnect();
            if (!this.listeners.isEmpty()) {
                for (IBuildConsoleListener listener : this.listeners) {
                    ConsoleEvent consoleEvent = new ConsoleEvent(this, (IProject)resource, 2);
                    listener.consoleChange(consoleEvent);
                }
            }
        }
    }

    public void shutdown() {
        if (this.infoColor != null) {
            this.infoColor.dispose();
            this.outputColor.dispose();
            this.errorColor.dispose();
            this.backgroundColor.dispose();
            this.problemErrorBackgroundColor.dispose();
            this.problemWarningBackgroundColor.dispose();
            this.problemInfoBackgroundColor.dispose();
            this.problemHighlightedColor.dispose();
        }
        ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this.fConsoleListener);
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.fConsole});
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void runUI(Runnable run) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            display.asyncExec(run);
        } else {
            run.run();
        }
    }

    protected BuildConsole createBuildConsole(String name, String contextId, URL iconUrl) {
        return new BuildConsole(this, name, contextId, iconUrl);
    }

    public void startup(String name, String contextId, URL iconUrl) {
        if (!(this instanceof GlobalBuildConsoleManager)) {
            GlobalBuildConsoleManager.startup();
        }
        this.infoStream = new BuildConsoleStreamDecorator();
        this.outputStream = new BuildConsoleStreamDecorator();
        this.errorStream = new BuildConsoleStreamDecorator();
        this.fName = name;
        this.fContextMenuId = contextId;
        this.fConsoleListener = new IConsoleListener(){

            public void consolesAdded(IConsole[] consoles) {
            }

            public void consolesRemoved(IConsole[] consoles) {
                IConsole[] iConsoleArray = consoles;
                int n = consoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IConsole console = iConsoleArray[n2];
                    if (console == BuildConsoleManager.this.fConsole) {
                        BuildConsoleManager.this.fWasClosed.set(true);
                    }
                    ++n2;
                }
            }
        };
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(this.fConsoleListener);
        this.runUI(() -> {
            this.fConsole = this.createBuildConsole(this.fName, this.fContextMenuId, iconUrl);
            this.addConsole();
            this.infoStream.setConsole(this.fConsole);
            this.infoColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
            this.infoStream.setColor(this.infoColor);
            this.outputStream.setConsole(this.fConsole);
            this.outputColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
            this.outputStream.setColor(this.outputColor);
            this.errorStream.setConsole(this.fConsole);
            this.errorColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
            this.errorStream.setColor(this.errorColor);
            this.backgroundColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleBackgroundColor");
            this.fConsole.setBackground(this.backgroundColor);
            this.problemHighlightedColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemHighlightedColor");
            this.problemErrorBackgroundColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemBackgroundColor");
            this.problemWarningBackgroundColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemWarningBackgroundColor");
            this.problemInfoBackgroundColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemInfoBackgroundColor");
        });
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void reinitaliazeIfNecessary() {
        if (!(this instanceof GlobalBuildConsoleManager)) {
            GlobalBuildConsoleManager.staticReinitaliazeIfNecessary();
        }
        if (this.fWasClosed.getAndSet(false)) {
            this.addConsole();
        }
    }

    private void addConsole() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.fConsole});
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("buildConsoleInfoStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
            this.infoStream.setColor(newColor);
            this.infoColor.dispose();
            this.infoColor = newColor;
        } else if (property.equals("buildConsoleOutputStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
            this.outputStream.setColor(newColor);
            this.outputColor.dispose();
            this.outputColor = newColor;
        } else if (property.equals("buildConsoleErrorStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
            this.errorStream.setColor(newColor);
            this.errorColor.dispose();
            this.errorColor = newColor;
        } else if (property.equals("buildConsoleBackgroundColor")) {
            Color newColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleBackgroundColor");
            this.fConsole.setBackground(newColor);
            this.backgroundColor.dispose();
            this.backgroundColor = newColor;
        } else if (property.equals("buildConsoleProblemHighlightedColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemHighlightedColor");
            this.problemHighlightedColor.dispose();
            this.problemHighlightedColor = newColor;
            this.redrawTextViewer();
        } else if (property.equals("buildConsoleProblemBackgroundColor")) {
            Color newColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemBackgroundColor");
            this.problemErrorBackgroundColor.dispose();
            this.problemErrorBackgroundColor = newColor;
            this.redrawTextViewer();
        } else if (property.equals("buildConsoleProblemWarningBackgroundColor")) {
            Color newColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemWarningBackgroundColor");
            this.problemWarningBackgroundColor.dispose();
            this.problemWarningBackgroundColor = newColor;
            this.redrawTextViewer();
        } else if (property.equals("buildConsoleProblemInfoBackgroundColor")) {
            Color newColor = this.createBackgroundColor(CUIPlugin.getStandardDisplay(), "buildConsoleProblemInfoBackgroundColor");
            this.problemInfoBackgroundColor.dispose();
            this.problemInfoBackgroundColor = newColor;
            this.redrawTextViewer();
        }
    }

    private void redrawTextViewer() {
        BuildConsolePage p = BuildConsole.getCurrentPage();
        if (p == null) {
            return;
        }
        BuildConsoleViewer v = p.getViewer();
        if (v == null) {
            return;
        }
        Display display = Display.getDefault();
        display.asyncExec(() -> v.getTextWidget().redraw());
    }

    public IBuildConsoleStreamDecorator getStreamDecorator(int type) throws CoreException {
        switch (type) {
            case 2: {
                return this.errorStream;
            }
            case 0: {
                return this.infoStream;
            }
            case 1: {
                return this.outputStream;
            }
        }
        throw new CoreException((IStatus)new Status(4, PREF_QUALIFIER, -1, "No Such Console", null));
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)CUIPlugin.getDefault().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    private Color createBackgroundColor(Display display, String preference) {
        IPreferenceStore preferenceStore = CUIPlugin.getDefault().getPreferenceStore();
        RGB rgb = preferenceStore.contains(preference) ? PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)preference) : new RGB(200, 200, 200);
        return new Color((Device)display, rgb);
    }

    @Override
    public org.eclipse.cdt.core.resources.IConsole getConsole(IProject project) {
        return new MultiBuildConsoleAdapter(this.getProjectConsole(project), GlobalBuildConsoleManager.getGlobalConsole());
    }

    @Override
    public org.eclipse.cdt.core.resources.IConsole getProjectConsole(IProject project) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        this.fLastProject = project;
        return this.getProjectConsolePartioner(project).getConsole();
    }

    @Override
    public IProject getLastBuiltProject() {
        return this.fLastProject;
    }

    private BuildConsolePartitioner getProjectConsolePartioner(IProject project) {
        BuildConsolePartitioner partitioner = this.fConsoleMap.get(project);
        if (partitioner == null) {
            partitioner = new BuildConsolePartitioner(project, this);
            this.fConsoleMap.put(project, partitioner);
        }
        return partitioner;
    }

    @Override
    public IDocument getConsoleDocument(IProject project) {
        Assert.isNotNull((Object)project);
        return this.getProjectConsolePartioner(project).getDocument();
    }

    @Override
    public void addConsoleListener(IBuildConsoleListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeConsoleListener(IBuildConsoleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public Preferences getBuildLogPreferences(IProject project) {
        return new LocalProjectScope(project).getNode(PREF_QUALIFIER).node(BUILD_CONSOLE_NODE);
    }

    public String getDefaultConsoleLogLocation(IProject project) {
        IPath defaultLogLocation = CUIPlugin.getDefault().getStateLocation().append(String.valueOf(project.getName()) + PROJECT_LOG_EXT);
        return defaultLogLocation.toOSString();
    }

    public URI getLogURI(IProject project) {
        Assert.isNotNull((Object)project);
        if (this.fContextMenuId != DEFAULT_CONTEXT_MENU_ID) {
            return null;
        }
        URI logURI = null;
        Preferences prefs = this.getBuildLogPreferences(project);
        boolean keepLog = prefs.getBoolean(KEY_KEEP_LOG, true);
        if (keepLog) {
            String strLocation = prefs.get(KEY_LOG_LOCATION, this.getDefaultConsoleLogLocation(project));
            if (strLocation.trim().length() > 0) {
                logURI = URIUtil.toURI((String)strLocation);
            }
            if (logURI == null) {
                Status status = new Status(4, PREF_QUALIFIER, "Can't determine URI for location=[" + strLocation + "]");
                CUIPlugin.log((IStatus)status);
            }
        }
        return logURI;
    }
}

