/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.AbstractComponentElement;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNode;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputHandler;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestHandler;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.InteractionObserver;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartInputHandler;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartTask;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SmartQueryHandler {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private ComponentGenHelpers _componentGenHelpers;
    @Inject
    @Extension
    private CommObjectGenHelpers _commObjectGenHelpers;
    @Inject
    @Extension
    private SmartInputHandler _smartInputHandler;
    @Inject
    @Extension
    private SmartTask _smartTask;
    @Inject
    @Extension
    private SmartComponent _smartComponent;
    @Inject
    @Extension
    private InteractionObserver _interactionObserver;

    public String QueryServerHandlerCoreHeaderFileName(RequestHandler handler) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        return String.valueOf(_nameClass) + "Core.hh";
    }

    public String QueryServerHandlerCoreSourceFileName(RequestHandler handler) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        return String.valueOf(_nameClass) + "Core.cc";
    }

    public String QueryServerHandlerUserHeaderFileName(RequestHandler handler) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        return String.valueOf(_nameClass) + ".hh";
    }

    public String QueryServerHandlerUserSourceFileName(RequestHandler handler) {
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        return String.valueOf(_nameClass) + ".cc";
    }

    public void CreateQueryServerHandlers(ComponentDefinition comp, IFileSystemAccess fsa) {
        Iterable _filter = Iterables.filter((Iterable)comp.getElements(), RequestHandler.class);
        for (RequestHandler handler : _filter) {
            fsa.generateFile(this.QueryServerHandlerCoreHeaderFileName(handler), this.HandlerHeaderFileContent(handler));
            fsa.generateFile(this.QueryServerHandlerCoreSourceFileName(handler), this.HandlerCoreSourceFileContent(handler));
            fsa.generateFile(this.QueryServerHandlerUserHeaderFileName(handler), "SRC_OUTPUT", this.HandlerUserHeaderFileContent(handler));
            fsa.generateFile(this.QueryServerHandlerUserSourceFileName(handler), "SRC_OUTPUT", this.HandlerUserSourceFileContent(handler));
        }
    }

    public CharSequence HandlerHeaderFileContent(RequestHandler handler) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = handler.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = handler.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_CORE_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("#include \"aceSmartSoft.hh\"");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> it.getName();
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getAllCommObjects((RequestHandler)handler), (Functions.Function1)_function);
        for (CommunicationObject obj : _sortBy) {
            _builder.append("#include <");
            CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
            _builder.append((Object)_userClassHeaderFileNameFQN);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// include the input interfaces (if any)");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)handler), (Functions.Function1)_function_1);
        for (InputPortLink inLink : _sortBy_1) {
            _builder.append("#include \"");
            String _UpcallInterfaceHeaderFileName = this._smartInputHandler.UpcallInterfaceHeaderFileName(inLink.getInputPort());
            _builder.append(_UpcallInterfaceHeaderFileName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("// include all interaction-observer interfaces");
        _builder.newLine();
        _builder.append("#include <");
        String _nodeObserverInterfaceHeaderFileName = this._interactionObserver.getNodeObserverInterfaceHeaderFileName((ComponentSubNode)handler);
        _builder.append(_nodeObserverInterfaceHeaderFileName);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function_2 = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)handler), (Functions.Function1)_function_2);
        for (ComponentSubNodeObserver obs : _sortBy_2) {
            _builder.append("#include <");
            String _nodeObserverInterfaceHeaderFileName_1 = this._interactionObserver.getNodeObserverInterfaceHeaderFileName(obs.getSubject());
            _builder.append(_nodeObserverInterfaceHeaderFileName_1);
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass);
        _builder.append("Core ");
        _builder.newLineIfNotEmpty();
        _builder.append(":\tpublic Smart::IInputHandler<std::pair<Smart::QueryIdPtr,");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Request"));
        _builder.append((Object)_fullyQualifiedNameCpp);
        _builder.append(">>");
        _builder.newLineIfNotEmpty();
        _builder.append(",\tpublic Smart::TaskTriggerSubject");
        _builder.newLine();
        Functions.Function1 _function_3 = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy_3 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)handler), (Functions.Function1)_function_3);
        for (ComponentSubNodeObserver obs_1 : _sortBy_3) {
            _builder.append(",\tpublic ");
            String _nodeObserverInterfaceClassName = this._interactionObserver.getNodeObserverInterfaceClassName(obs_1.getSubject());
            _builder.append(_nodeObserverInterfaceClassName);
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1 _function_4 = it -> it.getName();
        List _sortBy_4 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)handler), (Functions.Function1)_function_4);
        for (InputPortLink inLink_1 : _sortBy_4) {
            _builder.append(",\tpublic ");
            String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)inLink_1.getInputPort());
            _builder.append(_nameClass_1);
            _builder.append("UpcallInterface");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("{");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        _builder.append("virtual void handle_input(const std::pair<Smart::QueryIdPtr,");
        CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Request"));
        _builder.append((Object)_fullyQualifiedNameCpp_1);
        _builder.append("> &input) override {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this->handleQuery(input.first, input.second);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function_5 = it -> it.getName();
        List _sortBy_5 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)handler), (Functions.Function1)_function_5);
        for (InputPortLink inLink_2 : _sortBy_5) {
            _builder.append("Smart::StatusCode ");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink_2.getInputPort());
            _builder.append(_nameInstance);
            _builder.append("Status;");
            _builder.newLineIfNotEmpty();
            CharSequence _inputHandlerCommObject = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)inLink_2.getInputPort());
            _builder.append((Object)_inputHandlerCommObject);
            _builder.append(" ");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink_2.getInputPort());
            _builder.append(_nameInstance_1);
            _builder.append("Object;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void updateAllCommObjects();");
        _builder.newLine();
        _builder.newLine();
        CharSequence _compileNodeSubjectHeader = this._interactionObserver.compileNodeSubjectHeader((ComponentSubNode)handler);
        _builder.append((Object)_compileNodeSubjectHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        Functions.Function1 _function_6 = it -> it.getName();
        List _sortBy_6 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)handler), (Functions.Function1)_function_6);
        for (ComponentSubNodeObserver obs_2 : _sortBy_6) {
            _builder.append("\t");
            _builder.append("// overload this method in derived classes!");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("virtual void on_update_from(const ");
            String _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)obs_2.getSubject());
            _builder.append(_nameClass_2, "\t");
            _builder.append("* subject) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// no-op");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        Functions.Function1 _function_7 = it -> it.getInputPort();
        Functions.Function1 _function_8 = it -> it.getName();
        List _sortBy_7 = IterableExtensions.sortBy((Iterable)IterableExtensions.map((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)handler), (Functions.Function1)_function_7), (Functions.Function1)_function_8);
        for (InputPort input : _sortBy_7) {
            _builder.append("\t");
            _builder.append("// overload and implement this method in derived classes to immediately get all incoming updates from ");
            String _name = input.getName();
            _builder.append(_name, "\t");
            _builder.append(" (as soon as they arrive)");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("virtual void on_");
            String _name_1 = input.getName();
            _builder.append(_name_1, "\t");
            _builder.append("(const ");
            CharSequence _inputHandlerCommObject_1 = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)input);
            _builder.append((Object)_inputHandlerCommObject_1, "\t");
            _builder.append(" &input) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// no-op");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// this method can be safely used from the thread in derived classes");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("inline Smart::StatusCode ");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_2, "\t");
            _builder.append("GetUpdate(");
            CharSequence _inputHandlerCommObject_2 = this._componentGenHelpers.getInputHandlerCommObject((ComponentPort)input);
            _builder.append((Object)_inputHandlerCommObject_2, "\t");
            _builder.append(" &");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_3, "\t");
            _builder.append("Object) const");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("// copy local object buffer and return the last status code");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_4, "\t\t");
            _builder.append("Object = this->");
            String _nameInstance_5 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_5, "\t\t");
            _builder.append("Object;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            String _nameInstance_6 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_6, "\t\t");
            _builder.append("Status;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("using IQueryServer = Smart::IQueryServerPattern<");
        CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList((ComponentPort)handler.getAnswerPort(), (Boolean)true);
        _builder.append((Object)_commObjectCppList, "\t");
        _builder.append(">;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("using QueryId = Smart::QueryIdPtr;");
        _builder.newLine();
        _builder.append("\t");
        String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_3, "\t");
        _builder.append("Core(IQueryServer *server);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual ~");
        String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_4, "\t");
        _builder.append("Core() = default;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("IQueryServer *server;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//this user-method has to be implemented in derived classes");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual void handleQuery(const QueryId &id, const ");
        CharSequence _fullyQualifiedNameCpp_2 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Request"));
        _builder.append((Object)_fullyQualifiedNameCpp_2, "\t");
        _builder.append("& request) = 0;");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence HandlerCoreSourceFileContent(RequestHandler handler) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyright = this._copyrightHelpers.getCopyright();
        _builder.append(_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _QueryServerHandlerCoreHeaderFileName = this.QueryServerHandlerCoreHeaderFileName(handler);
        _builder.append(_QueryServerHandlerCoreHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _QueryServerHandlerUserHeaderFileName = this.QueryServerHandlerUserHeaderFileName(handler);
        _builder.append(_QueryServerHandlerUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("// include observers");
        _builder.newLine();
        Functions.Function1 _function = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)handler), (Functions.Function1)_function);
        for (ComponentSubNodeObserver observer : _sortBy) {
            ComponentSubNode _subject = observer.getSubject();
            if (_subject instanceof Activity) {
                _builder.append("#include \"");
                ComponentSubNode _subject_1 = observer.getSubject();
                String _TaskUserHeaderFileName = this._smartTask.TaskUserHeaderFileName((Activity)_subject_1);
                _builder.append(_TaskUserHeaderFileName);
                _builder.append("\"");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ComponentSubNode _subject_2 = observer.getSubject();
            if (!(_subject_2 instanceof InputHandler)) continue;
            _builder.append("#include \"");
            ComponentSubNode _subject_3 = observer.getSubject();
            String _InputHandlerUserHeaderFileName = this._smartInputHandler.InputHandlerUserHeaderFileName((InputHandler)_subject_3);
            _builder.append(_InputHandlerUserHeaderFileName);
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass);
        _builder.append("Core::");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_1);
        _builder.append("Core(IQueryServer* server)");
        _builder.newLineIfNotEmpty();
        _builder.append(":\tSmart::IInputHandler<std::pair<Smart::QueryIdPtr,");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Request"));
        _builder.append((Object)_fullyQualifiedNameCpp);
        _builder.append(">>(server)");
        _builder.newLineIfNotEmpty();
        _builder.append(",\tserver(server)");
        _builder.newLine();
        Functions.Function1 _function_1 = it -> it.getName();
        List _sortBy_1 = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)handler), (Functions.Function1)_function_1);
        for (InputPortLink inLink : _sortBy_1) {
            _builder.append(",\t");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink.getInputPort());
            _builder.append(_nameInstance);
            _builder.append("Status(Smart::SMART_DISCONNECTED)");
            _builder.newLineIfNotEmpty();
            _builder.append(",\t");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance((AbstractComponentElement)inLink.getInputPort());
            _builder.append(_nameInstance_1);
            _builder.append("Object()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_2);
        _builder.append("Core::updateAllCommObjects()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        Functions.Function1 _function_2 = it -> it.getInputPort();
        Functions.Function1 _function_3 = it -> it.getName();
        List _sortBy_2 = IterableExtensions.sortBy((Iterable)IterableExtensions.map((Iterable)ComponentDefinitionModelUtility.getInputLinks((ComponentSubNode)handler), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        for (InputPort input : _sortBy_2) {
            _builder.append("\t");
            String _nameInstance_2 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_2, "\t");
            _builder.append("Status = COMP->");
            String _nameInstance_3 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_3, "\t");
            _builder.append("InputTaskTrigger->getUpdate(");
            String _nameInstance_4 = this._componentGenHelpers.nameInstance((AbstractComponentElement)input);
            _builder.append(_nameInstance_4, "\t");
            _builder.append("Object);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _compileNodeSubjectSource = this._interactionObserver.compileNodeSubjectSource((ComponentSubNode)handler);
        _builder.append((Object)_compileNodeSubjectSource);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence HandlerUserHeaderFileContent(RequestHandler handler) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#ifndef _");
        String _upperCase = handler.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_USER_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("#define _");
        String _upperCase_1 = handler.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_USER_HH");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("#include \"");
        String _QueryServerHandlerCoreHeaderFileName = this.QueryServerHandlerCoreHeaderFileName(handler);
        _builder.append(_QueryServerHandlerCoreHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("class ");
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass);
        _builder.append(" : public ");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_1);
        _builder.append("Core");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("protected:");
        _builder.newLine();
        Functions.Function1 _function = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)handler), (Functions.Function1)_function);
        for (ComponentSubNodeObserver obs : _sortBy) {
            _builder.append("\t");
            _builder.append("virtual void on_update_from(const ");
            String _nameClass_2 = this._componentGenHelpers.getNameClass(obs);
            _builder.append(_nameClass_2, "\t");
            _builder.append("* ");
            String _nameInstance = this._componentGenHelpers.nameInstance(obs);
            _builder.append(_nameInstance, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t");
        String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_3, "\t");
        _builder.append("(IQueryServer *server);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual ~");
        String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_4, "\t");
        _builder.append("() = default;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("virtual void handleQuery(const QueryId &id, const ");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Request"));
        _builder.append((Object)_fullyQualifiedNameCpp, "\t");
        _builder.append("& request);");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        return _builder;
    }

    public CharSequence HandlerUserSourceFileContent(RequestHandler handler) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnce = this._copyrightHelpers.getCopyrightWriteOnce();
        _builder.append(_copyrightWriteOnce);
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        String _QueryServerHandlerUserHeaderFileName = this.QueryServerHandlerUserHeaderFileName(handler);
        _builder.append(_QueryServerHandlerUserHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"");
        EObject _eContainer = handler.eContainer();
        String _compHeaderFilename = this._smartComponent.getCompHeaderFilename((ComponentDefinition)_eContainer);
        _builder.append(_compHeaderFilename);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _nameClass = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass);
        _builder.append("::");
        String _nameClass_1 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_1);
        _builder.append("(IQueryServer *server)");
        _builder.newLineIfNotEmpty();
        _builder.append(":\t");
        String _nameClass_2 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_2);
        _builder.append("Core(server)");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = it -> this._componentGenHelpers.getNameClass((ComponentSubNodeObserver)it);
        List _sortBy = IterableExtensions.sortBy((Iterable)ComponentDefinitionModelUtility.getObservers((ComponentSubNode)handler), (Functions.Function1)_function);
        for (ComponentSubNodeObserver observer : _sortBy) {
            _builder.append("void ");
            String _nameClass_3 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
            _builder.append(_nameClass_3);
            _builder.append("::on_update_from(const ");
            String _nameClass_4 = this._componentGenHelpers.nameClass((AbstractComponentElement)observer.getSubject());
            _builder.append(_nameClass_4);
            _builder.append("* ");
            String _nameInstance = this._componentGenHelpers.nameInstance((AbstractComponentElement)observer.getSubject());
            _builder.append(_nameInstance);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// update triggered from ");
            String _nameClass_5 = this._componentGenHelpers.nameClass((AbstractComponentElement)observer.getSubject());
            _builder.append(_nameClass_5, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("// (use a local mutex here, because this method is called from within the thread of ");
            String _name = observer.getSubject().getName();
            _builder.append(_name, "\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("void ");
        String _nameClass_6 = this._componentGenHelpers.nameClass((AbstractComponentElement)handler);
        _builder.append(_nameClass_6);
        _builder.append("::handleQuery(const Smart::QueryIdPtr &id, const ");
        CharSequence _fullyQualifiedNameCpp = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Request"));
        _builder.append((Object)_fullyQualifiedNameCpp);
        _builder.append("& request) ");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _fullyQualifiedNameCpp_1 = this._commObjectGenHelpers.getFullyQualifiedNameCpp(this._componentGenHelpers.getCommunicationObjects((ComponentPort)handler.getAnswerPort()).get("Answer"));
        _builder.append((Object)_fullyQualifiedNameCpp_1, "\t");
        _builder.append(" answer;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// implement your query handling logic here and fill in the answer object");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this->server->answer(id, answer);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

