/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.system;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PublicOperationMode;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.ACE_SmartSoft;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.RoboticMiddleware;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.OpcUaDeviceClientInstance;
import org.eclipse.smartmdsd.ecore.system.compArchSeronetExtension.OpcUaReadServerInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ActivityConfigurationMapping;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureModelUtility;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.Connection;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ProvidedService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.RequiredService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.system.ActivityConfig;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.system.BehaviorSystem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class SystemGenerator2Impl
extends AbstractGenerator {
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;
    @Inject
    @Extension
    private ActivityConfig _activityConfig;
    @Inject
    @Extension
    private BehaviorSystem _behaviorSystem;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), SystemComponentArchitecture.class);
        for (SystemComponentArchitecture model : _filter) {
            fsa.generateFile("CMakeLists.txt", "SMARTSOFT_OUTPUT", this.compileCMakeLists(model));
            fsa.generateFile("BuildExternalComponents.cmake", "SRC_GEN_SYS_CONFIG", this.compileBuildExternalComponents(model));
            fsa.generateFile("CoordinationModuleConnections.json", "SRC_GEN_SYS_CONFIG", this._behaviorSystem.compileModuleConnections(model));
            fsa.generateFile("behaviorProjectFiles.sh", "SRC_GEN_SYS_CONFIG", this._behaviorSystem.compileBehaviorProjectFiles(model));
            EList _components = model.getComponents();
            for (ComponentInstance component : _components) {
                String _name = component.getName();
                String _plus = String.valueOf(_name) + ".ini";
                fsa.generateFile(_plus, "SRC_GEN_SYS_CONFIG", this.compileIniFile(component));
            }
        }
    }

    public CharSequence compileCMakeLists(SystemComponentArchitecture system) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("INCLUDE(src-gen/system/BuildExternalComponents.cmake)");
        _builder.newLine();
        return _builder;
    }

    public CharSequence compileBuildExternalComponents(SystemComponentArchitecture system) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
        _builder.newLine();
        _builder.append("PROJECT(");
        String _name = system.getName();
        _builder.append(_name);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# this is a pseudo-target just to trigger CMake builder");
        _builder.newLine();
        _builder.append("ADD_CUSTOM_TARGET(${PROJECT_NAME} ALL)");
        _builder.newLine();
        return _builder;
    }

    public String getSmartSoftFolder(ComponentInstance componentInstance) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(componentInstance.getComponent().getName());
        IFolder smartSoftFolder = proj.getFolder("smartsoft");
        boolean _exists = smartSoftFolder.exists();
        if (_exists) {
            return smartSoftFolder.getLocation().toOSString();
        }
        return "";
    }

    public CharSequence compileIniFile(ComponentInstance compInstance) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[smartsoft]");
        _builder.newLine();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# component parameters");
        _builder.newLine();
        _builder.newLine();
        _builder.append("[component]");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# the name of the component for the naming service");
        _builder.newLine();
        _builder.append("name ");
        String _name = compInstance.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("# the initial MainState of the component");
        _builder.newLine();
        _builder.append("initialMainState ");
        String _initialMainState = this.getInitialMainState(compInstance);
        _builder.append(_initialMainState);
        _builder.newLineIfNotEmpty();
        _builder.append("#defaultScheduler FIFO");
        _builder.newLine();
        _builder.append("#useLogger true");
        _builder.newLine();
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# server port parameters");
        _builder.newLine();
        Iterable _allServerPorts = ComponentArchitectureModelUtility.getAllServerPorts((ComponentInstance)compInstance);
        for (ComponentPort server : _allServerPorts) {
            _builder.newLine();
            _builder.append("[");
            String _name_1 = server.getName();
            _builder.append(_name_1);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            _builder.append("serviceName ");
            String _name_2 = server.getName();
            _builder.append(_name_2);
            _builder.newLineIfNotEmpty();
            _builder.append("roboticMiddleware ");
            String _selectedMiddlewareString = this.getSelectedMiddlewareString(compInstance, server);
            _builder.append(_selectedMiddlewareString);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# client port parameters");
        _builder.newLine();
        Iterable _allClientPorts = ComponentArchitectureModelUtility.getAllClientPorts((ComponentInstance)compInstance);
        for (ComponentPort client : _allClientPorts) {
            _builder.newLine();
            _builder.append("[");
            String _name_3 = client.getName();
            _builder.append(_name_3);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            _builder.append("wiringName ");
            String _name_4 = client.getName();
            _builder.append(_name_4);
            _builder.newLineIfNotEmpty();
            boolean _hasConnection = this.hasConnection(compInstance, client);
            if (_hasConnection) {
                _builder.append("serverName ");
                String _name_5 = this.getConnectedServer(compInstance, client).getName();
                _builder.append(_name_5);
                _builder.newLineIfNotEmpty();
                _builder.append("serviceName ");
                String _name_6 = this.getConnectedService(compInstance, client).getName();
                _builder.append(_name_6);
                _builder.newLineIfNotEmpty();
                _builder.append("initialConnect true");
                _builder.newLine();
            } else {
                _builder.append("serverName unknown");
                _builder.newLine();
                _builder.append("serviceName unknown");
                _builder.newLine();
                _builder.append("initialConnect false");
                _builder.newLine();
            }
            _builder.append("roboticMiddleware ");
            String _selectedMiddlewareString_1 = this.getSelectedMiddlewareString(compInstance, client);
            _builder.append(_selectedMiddlewareString_1);
            _builder.newLineIfNotEmpty();
            _builder.append("interval 1");
            _builder.newLine();
        }
        _builder.newLine();
        Iterable _filter = Iterables.filter((Iterable)compInstance.getComponent().getElements(), OpcUaDeviceClient.class);
        for (OpcUaDeviceClient opcDeviceClient : _filter) {
            _builder.append("[");
            String _name_7 = opcDeviceClient.getName();
            _builder.append(_name_7);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function = it -> {
                OpcUaDeviceClient _deviceClient = it.getDeviceClient();
                return Objects.equal((Object)_deviceClient, (Object)opcDeviceClient);
            };
            boolean _exists = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)compInstance.getExtensions(), OpcUaDeviceClientInstance.class), (Functions.Function1)_function);
            if (_exists) {
                _builder.append("deviceURI ");
                Functions.Function1 _function_1 = it -> {
                    OpcUaDeviceClient _deviceClient = it.getDeviceClient();
                    return Objects.equal((Object)_deviceClient, (Object)opcDeviceClient);
                };
                OpcUaDeviceClientInstance _findFirst = (OpcUaDeviceClientInstance)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)compInstance.getExtensions(), OpcUaDeviceClientInstance.class), (Functions.Function1)_function_1);
                String _deviceURI = null;
                if (_findFirst != null) {
                    _deviceURI = _findFirst.getDeviceURI();
                }
                _builder.append(_deviceURI);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("deviceURI ");
                String _deviceURI_1 = opcDeviceClient.getDeviceURI();
                _builder.append(_deviceURI_1);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("opcuaXmlFile ");
            String _opcuaXmlFile = opcDeviceClient.getOpcuaXmlFile();
            _builder.append(_opcuaXmlFile);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)compInstance.getComponent().getElements(), OpcUaReadServer.class);
        for (OpcUaReadServer opcStatusServer : _filter_1) {
            _builder.append("[");
            String _name_8 = opcStatusServer.getName();
            _builder.append(_name_8);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_2 = it -> {
                OpcUaReadServer _readServer = it.getReadServer();
                return Objects.equal((Object)_readServer, (Object)opcStatusServer);
            };
            boolean _exists_1 = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)compInstance.getExtensions(), OpcUaReadServerInstance.class), (Functions.Function1)_function_2);
            if (_exists_1) {
                _builder.append("portNumber ");
                Functions.Function1 _function_3 = it -> {
                    OpcUaReadServer _readServer = it.getReadServer();
                    return Objects.equal((Object)_readServer, (Object)opcStatusServer);
                };
                int _portNumber = ((OpcUaReadServerInstance)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)compInstance.getExtensions(), OpcUaReadServerInstance.class), (Functions.Function1)_function_3)).getPortNumber();
                _builder.append((Object)_portNumber);
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("portNumber ");
            int _portNumber_1 = opcStatusServer.getPortNumber();
            _builder.append((Object)_portNumber_1);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("##########################");
        _builder.newLine();
        _builder.append("# activity parameters");
        _builder.newLine();
        Iterable _activities = ComponentDefinitionModelUtility.getActivities((ComponentDefinition)compInstance.getComponent());
        for (Activity activity : _activities) {
            _builder.newLine();
            _builder.append("[");
            String _name_9 = activity.getName();
            _builder.append(_name_9);
            _builder.append("]");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_4 = it -> {
                Activity _activity = it.getActivity();
                return Objects.equal((Object)_activity, (Object)activity);
            };
            boolean _exists_2 = IterableExtensions.exists((Iterable)Iterables.filter((Iterable)compInstance.getExtensions(), ActivityConfigurationMapping.class), (Functions.Function1)_function_4);
            if (_exists_2) {
                Functions.Function1 _function_5 = it -> {
                    Activity _activity = it.getActivity();
                    return Objects.equal((Object)_activity, (Object)activity);
                };
                CharSequence _compileActivityNode = this._activityConfig.compileActivityNode((ActivityConfigurationMapping)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)compInstance.getExtensions(), ActivityConfigurationMapping.class), (Functions.Function1)_function_5));
                _builder.append((Object)_compileActivityNode);
                _builder.newLineIfNotEmpty();
                continue;
            }
            CharSequence _compileDefaultActivity = this._activityConfig.compileDefaultActivity(activity);
            _builder.append((Object)_compileDefaultActivity);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String getInitialMainState(ComponentInstance componentInstance) {
        Iterable _filter = Iterables.filter((Iterable)componentInstance.getComponent().getElements(), CoordinationSlavePort.class);
        for (CoordinationSlavePort slave : _filter) {
            Functions.Function1 _function = it -> {
                boolean _isIsDefaultInit = it.isIsDefaultInit();
                return _isIsDefaultInit;
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)slave.getElements(), PublicOperationMode.class), (Functions.Function1)_function);
            Iterator iterator = _filter_1.iterator();
            if (!iterator.hasNext()) continue;
            PublicOperationMode mode = (PublicOperationMode)iterator.next();
            return mode.getName();
        }
        return "Neutral";
    }

    private boolean hasConnection(ComponentInstance component, ComponentPort service) {
        EObject parent;
        Functions.Function1 _function = it -> {
            ComponentPort _port = it.getPort();
            return Objects.equal((Object)_port, (Object)service);
        };
        ServiceInstance port = (ServiceInstance)IterableExtensions.findFirst((Iterable)component.getPorts(), (Functions.Function1)_function);
        if (port instanceof RequiredService && (parent = component.eContainer()) instanceof SystemComponentArchitecture) {
            Functions.Function1 _function_1 = it -> {
                RequiredService _from = it.getFrom();
                return Objects.equal((Object)_from, (Object)port);
            };
            return IterableExtensions.exists((Iterable)((SystemComponentArchitecture)parent).getConnections(), (Functions.Function1)_function_1);
        }
        return false;
    }

    private ProvidedService getConnectedService(ComponentInstance component, ComponentPort service) {
        EObject parent;
        Functions.Function1 _function = it -> {
            ComponentPort _port = it.getPort();
            return Objects.equal((Object)_port, (Object)service);
        };
        ServiceInstance port = (ServiceInstance)IterableExtensions.findFirst((Iterable)component.getPorts(), (Functions.Function1)_function);
        if (port instanceof RequiredService && (parent = component.eContainer()) instanceof SystemComponentArchitecture) {
            Functions.Function1 _function_1 = it -> {
                RequiredService _from = it.getFrom();
                return Objects.equal((Object)_from, (Object)port);
            };
            Connection connection = (Connection)IterableExtensions.findFirst((Iterable)((SystemComponentArchitecture)parent).getConnections(), (Functions.Function1)_function_1);
            if (connection != null) {
                return connection.getTo();
            }
        }
        return null;
    }

    private ComponentInstance getConnectedServer(ComponentInstance component, ComponentPort service) {
        EObject parent;
        ProvidedService connectedSvc = this.getConnectedService(component, service);
        if (connectedSvc != null && (parent = connectedSvc.eContainer()) instanceof ComponentInstance) {
            return (ComponentInstance)parent;
        }
        return null;
    }

    public String getSelectedMiddlewareString(ComponentInstance component, ComponentPort service) {
        EObject parent = component.eContainer();
        if (parent instanceof SystemComponentArchitecture) {
            Functions.Function1 _function = it -> {
                ComponentPort _port = it.getPort();
                return Objects.equal((Object)_port, (Object)service);
            };
            ServiceInstance port = (ServiceInstance)IterableExtensions.findFirst((Iterable)component.getPorts(), (Functions.Function1)_function);
            if (port instanceof RequiredService) {
                Functions.Function1 _function_1 = it -> {
                    RequiredService _from = it.getFrom();
                    return Objects.equal((Object)_from, (Object)port);
                };
                Connection connection = (Connection)IterableExtensions.findFirst((Iterable)((SystemComponentArchitecture)parent).getConnections(), (Functions.Function1)_function_1);
                if (connection != null) {
                    boolean _tripleNotEquals;
                    RoboticMiddleware _middlewareSelection = connection.getMiddlewareSelection();
                    boolean bl = _tripleNotEquals = _middlewareSelection != null;
                    if (_tripleNotEquals) {
                        return connection.getMiddlewareSelection().eClass().getName();
                    }
                }
            } else if (port instanceof ProvidedService) {
                Functions.Function1 _function_2 = it -> {
                    ProvidedService _to = it.getTo();
                    return Objects.equal((Object)_to, (Object)port);
                };
                Iterable _filter = IterableExtensions.filter((Iterable)((SystemComponentArchitecture)parent).getConnections(), (Functions.Function1)_function_2);
                for (Connection connection_1 : _filter) {
                    boolean _tripleNotEquals_1;
                    RoboticMiddleware _middlewareSelection_1 = connection_1.getMiddlewareSelection();
                    boolean bl = _tripleNotEquals_1 = _middlewareSelection_1 != null;
                    if (!_tripleNotEquals_1) continue;
                    return connection_1.getMiddlewareSelection().eClass().getName();
                }
            }
        }
        return ACE_SmartSoft.class.getSimpleName();
    }
}

