/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.checkouts;

import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

public class CDOCheckoutProperties
extends Properties<CDOCheckout> {
    public static final IProperties<CDOCheckout> INSTANCE = new CDOCheckoutProperties();
    public static final String CATEGORY_CHECKOUT = "Checkout";

    private CDOCheckoutProperties() {
        super(CDOCheckout.class);
        this.add((Property)new Property<CDOCheckout>("state"){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getState();
            }
        });
        this.add((Property)new Property<CDOCheckout>("open", "Open", "Whether this checkout is open", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.isOpen();
            }
        });
        this.add((Property)new Property<CDOCheckout>("type", "Type", "The type of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getType();
            }
        });
        this.add((Property)new Property<CDOCheckout>("id", "ID", "The ID of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getID();
            }
        });
        this.add((Property)new Property<CDOCheckout>("label", "Label", "The label of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getLabel();
            }
        });
        this.add((Property)new Property<CDOCheckout>("folder", "Folder", "The folder of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return ((AbstractElement)((Object)checkout)).getFolder();
            }
        });
        this.add((Property)new Property<CDOCheckout>("rootType"){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getRootType();
            }
        });
        this.add((Property)new Property<CDOCheckout>("canContainResources"){

            protected Object eval(CDOCheckout checkout) {
                CDOCheckout.ObjectType rootType = checkout.getRootType();
                if (rootType != null) {
                    switch (rootType) {
                        case Root: 
                        case Folder: {
                            return true;
                        }
                    }
                }
                return false;
            }
        });
        this.add((Property)new Property<CDOCheckout>("branchID", "Branch ID", "The ID of the branch of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getBranchID();
            }
        });
        this.add((Property)new Property<CDOCheckout>("branch", "Branch", "The branch of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getBranchPath();
            }
        });
        this.add((Property)new Property<CDOCheckout>("timeStamp", "Time Stamp", "The time stamp of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return CDOCommonUtil.formatTimeStamp((long)checkout.getTimeStamp());
            }
        });
        this.add((Property)new Property<CDOCheckout>("readOnly", "Read-Only", "Whether this checkout is read-only", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.isReadOnly();
            }
        });
        this.add((Property)new Property<CDOCheckout>("rootID", "Root ID", "The ID of the root object of this checkout", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.getRootID();
            }
        });
        this.add((Property)new Property<CDOCheckout>("dirty", "Dirty", "Whether this checkout is dirty", CATEGORY_CHECKOUT){

            protected Object eval(CDOCheckout checkout) {
                return checkout.isDirty();
            }
        });
        this.add((Property)new Property<CDOCheckout>("repositoryConnected", "Connected", "Whether the repository of this checkout is connected", "Repository"){

            protected Object eval(CDOCheckout checkout) {
                CDORepository repository = checkout.getRepository();
                if (repository != null) {
                    return repository.isConnected();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOCheckout>("repositoryType", "Type", "The type of the repository of this checkout", "Repository"){

            protected Object eval(CDOCheckout checkout) {
                CDORepository repository = checkout.getRepository();
                if (repository != null) {
                    return repository.getType();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOCheckout>("repositoryID", "ID", "The ID of the repository of this checkout", "Repository"){

            protected Object eval(CDOCheckout checkout) {
                CDORepository repository = checkout.getRepository();
                if (repository != null) {
                    return repository.getID();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOCheckout>("repositoryLabel", "Label", "The label of the repository of this checkout", "Repository"){

            protected Object eval(CDOCheckout checkout) {
                CDORepository repository = checkout.getRepository();
                if (repository != null) {
                    return repository.getLabel();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOCheckout>("repositoryFolder", "Folder", "The folder of the repository of this checkout", "Repository"){

            protected Object eval(CDOCheckout checkout) {
                AbstractElement repository = (AbstractElement)((Object)checkout.getRepository());
                if (repository != null) {
                    return repository.getFolder();
                }
                return null;
            }
        });
        this.add((Property)new Property<CDOCheckout>("repositoryURI", "URI", "The URI of the repository of this checkout", "Repository"){

            protected Object eval(CDOCheckout checkout) {
                CDORepository repository = checkout.getRepository();
                if (repository != null) {
                    return repository.getURI();
                }
                return null;
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    public static final class Tester
    extends DefaultPropertyTester<CDOCheckout> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.explorer.checkout";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

