/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.MessageLine;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MakeTargetDialog
extends Dialog {
    private MessageLine fStatusLine;
    private static final String TARGET_PREFIX = "TargetBlock";
    private static final String TARGET_NAME_LABEL = "TargetBlock.target.label";
    private static final String BUILD_ARGUMENT_PREFIX = "BuildTarget";
    private static final String BUILD_ARGUMENT_GROUP = "BuildTarget.target.group_label";
    private static final String BUILD_ARGUMENT_LABEL = "BuildTarget.target.label";
    private static final String SETTING_PREFIX = "SettingsBlock";
    private static final String MAKE_SETTING_GROUP = "SettingsBlock.makeSetting.group_label";
    private static final String MAKE_SETTING_STOP_ERROR = "SettingsBlock.makeSetting.stopOnError";
    private static final String MAKE_CMD_GROUP = "SettingsBlock.makeCmd.group_label";
    private static final String MAKE_CMD_USE_BUILDER_SETTINGS = "SettingsBlock.makeCmd.useBuilderSettings";
    private static final String MAKE_CMD_LABEL = "SettingsBlock.makeCmd.label";
    private Text targetNameText;
    private Button sameAsNameCheckBox;
    private Text targetText;
    private Button useBuilderCommandCheckBox;
    private Text commandText;
    private Button stopOnErrorCheckBox;
    private Button runAllBuildersCheckBox;
    private final IMakeTargetManager fTargetManager;
    private final IContainer fContainer;
    private final IPath builderCommand;
    private final String builderArguments;
    private boolean isUsingBuilderCommand = true;
    private boolean isStopOnError;
    private boolean runAllBuilders = true;
    private IPath targetBuildCommand;
    private String targetBuildArguments;
    private String targetString;
    private String targetName;
    private String targetBuildID;
    private IMakeTarget fTarget;
    private boolean initializing = true;

    public MakeTargetDialog(Shell parentShell, IMakeTarget target) throws CoreException {
        this(parentShell, target.getContainer());
        this.fTarget = target;
        this.isStopOnError = target.isStopOnError();
        this.isUsingBuilderCommand = target.isDefaultBuildCmd();
        if (!this.isUsingBuilderCommand) {
            this.targetBuildCommand = target.getBuildCommand();
            this.targetBuildArguments = target.getBuildArguments();
        }
        this.targetName = target.getName();
        this.targetString = target.getBuildAttribute(IMakeTarget.BUILD_TARGET, "");
        this.targetBuildID = target.getTargetBuilderID();
        this.runAllBuilders = target.runAllBuilders();
    }

    public MakeTargetDialog(Shell parentShell, IContainer container) throws CoreException {
        super(parentShell);
        this.fContainer = container;
        this.fTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        String[] id = this.fTargetManager.getTargetBuilders(container.getProject());
        if (id.length == 0) {
            throw new CoreException((IStatus)new Status(4, MakeUIPlugin.getUniqueIdentifier(), -1, MakeUIPlugin.getResourceString("MakeTargetDialog.exception.noTargetBuilderOnProject"), null));
        }
        this.targetBuildID = id[0];
        IMakeBuilderInfo buildInfo = MakeCorePlugin.createBuildInfo((IProject)container.getProject(), (String)this.fTargetManager.getBuilderID(this.targetBuildID));
        this.isStopOnError = buildInfo.isStopOnError();
        this.isUsingBuilderCommand = true;
        this.targetBuildCommand = this.builderCommand = buildInfo.getBuildCommand();
        this.targetBuildArguments = this.builderArguments = buildInfo.getBuildArguments();
        this.targetString = buildInfo.getIncrementalBuildTarget();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.getTitle());
        super.configureShell(newShell);
    }

    private String getTitle() {
        String title = this.fTarget == null || !MakeCorePlugin.getDefault().getTargetManager().targetExists(this.fTarget) ? MakeUIPlugin.getResourceString("MakeTargetDialog.title.createMakeTarget") : MakeUIPlugin.getResourceString("MakeTargetDialog.title.modifyMakeTarget");
        return title;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createNameControl(composite);
        this.createTargetControl(composite);
        this.createBuildCmdControls(composite);
        this.createSettingControls(composite);
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fStatusLine.setLayoutData(gd);
        this.initializing = false;
        return composite;
    }

    protected void createNameControl(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)2);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        composite.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(TARGET_NAME_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.targetNameText = ControlFactory.createTextField((Composite)composite, (int)2052);
        ((GridData)this.targetNameText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetNameText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.targetNameText.addListener(24, (Listener)new UpdateStatusLineListener());
    }

    protected void createSettingControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_SETTING_GROUP), (int)1);
        this.stopOnErrorCheckBox = new Button((Composite)group, 32);
        this.stopOnErrorCheckBox.setText(MakeUIPlugin.getResourceString(MAKE_SETTING_STOP_ERROR));
        this.stopOnErrorCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeTargetDialog.this.updateButtons();
            }
        });
        if (this.isStopOnError) {
            this.stopOnErrorCheckBox.setSelection(true);
        }
        if (this.isUsingBuilderCommand) {
            this.stopOnErrorCheckBox.setEnabled(true);
        } else {
            this.stopOnErrorCheckBox.setEnabled(false);
        }
        this.runAllBuildersCheckBox = new Button((Composite)group, 32);
        this.runAllBuildersCheckBox.setText(MakeUIPlugin.getResourceString("SettingsBlock.makeSetting.runAllBuilders"));
        this.runAllBuildersCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeTargetDialog.this.updateButtons();
            }
        });
        if (this.runAllBuilders) {
            this.runAllBuildersCheckBox.setSelection(true);
        }
    }

    protected void createBuildCmdControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_CMD_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        group.setLayoutData((Object)gd);
        this.useBuilderCommandCheckBox = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_USE_BUILDER_SETTINGS));
        this.useBuilderCommandCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MakeTargetDialog.this.useBuilderCommandCheckBox.getSelection()) {
                    StringBuilder cmd = new StringBuilder(MakeTargetDialog.this.builderCommand.toString());
                    if (MakeTargetDialog.this.builderArguments != null && !MakeTargetDialog.this.builderArguments.isEmpty()) {
                        cmd.append(" ");
                        cmd.append(MakeTargetDialog.this.builderArguments);
                    }
                    MakeTargetDialog.this.commandText.setText(cmd.toString());
                    MakeTargetDialog.this.commandText.setEnabled(false);
                    MakeTargetDialog.this.stopOnErrorCheckBox.setEnabled(true);
                } else {
                    MakeTargetDialog.this.commandText.setEnabled(true);
                    MakeTargetDialog.this.stopOnErrorCheckBox.setEnabled(false);
                }
                MakeTargetDialog.this.updateButtons();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.useBuilderCommandCheckBox.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.commandText = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.commandText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.commandText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.commandText.addListener(24, (Listener)new UpdateStatusLineListener());
        if (this.isUsingBuilderCommand) {
            this.commandText.setEnabled(false);
        } else {
            this.commandText.setEnabled(true);
        }
        this.useBuilderCommandCheckBox.setSelection(this.isUsingBuilderCommand);
    }

    private void createTargetControl(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(BUILD_ARGUMENT_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        group.setLayoutData((Object)gd);
        this.sameAsNameCheckBox = new Button((Composite)group, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.sameAsNameCheckBox.setLayoutData((Object)gd);
        this.sameAsNameCheckBox.setText(MakeUIPlugin.getResourceString("SettingsBlock.makeSetting.sameAsTarget"));
        this.targetNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MakeTargetDialog.this.sameAsNameCheckBox.getSelection()) {
                    MakeTargetDialog.this.targetText.setText(MakeTargetDialog.this.targetNameText.getText());
                }
            }
        });
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(BUILD_ARGUMENT_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.targetText = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.targetText.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetText.getLayoutData()).grabExcessHorizontalSpace = true;
        this.targetText.setText(this.targetString);
        this.targetText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                MakeTargetDialog.this.updateButtons();
            }
        });
        this.sameAsNameCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MakeTargetDialog.this.sameAsNameSelected();
            }
        });
        this.sameAsNameCheckBox.setSelection(this.targetString.equals(this.targetName) || this.targetString.length() == 0 && this.targetName == null);
        this.sameAsNameSelected();
    }

    protected void sameAsNameSelected() {
        this.targetText.setEnabled(!this.sameAsNameCheckBox.getSelection());
        if (this.sameAsNameCheckBox.getSelection()) {
            this.targetText.setText(this.targetNameText.getText());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.fTarget == null || !MakeCorePlugin.getDefault().getTargetManager().targetExists(this.fTarget)) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.targetNameText.setFocus();
        if (this.targetName != null) {
            this.targetNameText.setText(this.targetName);
        } else {
            this.targetNameText.setText(this.generateUniqueName(this.targetString));
        }
        this.targetNameText.selectAll();
        if (this.targetBuildCommand != null) {
            StringBuilder cmd = new StringBuilder(this.targetBuildCommand.toOSString());
            if (this.targetBuildArguments != null && !this.targetBuildArguments.isEmpty()) {
                cmd.append(" ");
                cmd.append(this.targetBuildArguments);
            }
            this.commandText.setText(cmd.toString());
        }
    }

    protected void updateButtons() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.targetHasChanged() && !this.fStatusLine.hasErrorMessage());
        }
    }

    protected boolean targetHasChanged() {
        if (this.initializing || this.fTarget == null || !MakeCorePlugin.getDefault().getTargetManager().targetExists(this.fTarget)) {
            return true;
        }
        if (this.isStopOnError != this.isStopOnError()) {
            return true;
        }
        if (this.runAllBuilders != this.runAllBuilders()) {
            return true;
        }
        if (this.isUsingBuilderCommand != this.isUsingBuilderCommand()) {
            return true;
        }
        if (!this.targetName.equals(this.getTargetName())) {
            return true;
        }
        if (!this.targetString.equals(this.getTarget())) {
            return true;
        }
        if (!this.isUsingBuilderCommand) {
            StringBuilder cmd = new StringBuilder(this.targetBuildCommand.toOSString()).append(this.targetBuildArguments);
            if (!this.getBuildLine().equals(cmd.toString())) {
                return true;
            }
        }
        return false;
    }

    private String generateUniqueName(String targetString) {
        String newName = targetString;
        int i = 0;
        try {
            while (this.fTargetManager.findTarget(this.fContainer, newName) != null) {
                newName = String.valueOf(targetString) + " (" + Integer.toString(++i) + ")";
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return newName;
    }

    private boolean isStopOnError() {
        return this.stopOnErrorCheckBox.getSelection();
    }

    private boolean runAllBuilders() {
        return this.runAllBuildersCheckBox.getSelection();
    }

    private boolean isUsingBuilderCommand() {
        return this.useBuilderCommandCheckBox.getSelection();
    }

    private String getBuildLine() {
        String cmd;
        if (this.commandText != null && (cmd = this.commandText.getText()) != null) {
            return cmd.trim();
        }
        return null;
    }

    private String getTarget() {
        return this.targetText.getText().trim();
    }

    private String getTargetName() {
        return this.targetNameText.getText().trim();
    }

    protected void okPressed() {
        IMakeTarget target = this.fTarget;
        try {
            String targetName = this.getTargetName();
            if (target == null) {
                target = this.fTargetManager.createTarget(this.fContainer.getProject(), targetName, this.targetBuildID);
            } else if (!target.getName().equals(targetName)) {
                String lastTargetName = null;
                IContainer container = target.getContainer();
                try {
                    lastTargetName = (String)container.getSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (lastTargetName != null && lastTargetName.equals(target.getName())) {
                    container.setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTarget"), (Object)targetName);
                    IPath path = target.getContainer().getProjectRelativePath();
                    container.getProject().setSessionProperty(new QualifiedName(MakeUIPlugin.getUniqueIdentifier(), "lastTargetContainer"), (Object)path.toString());
                }
                this.fTargetManager.renameTarget(target, targetName);
            }
            target.setStopOnError(this.isStopOnError());
            target.setRunAllBuilders(this.runAllBuilders());
            target.setUseDefaultBuildCmd(this.isUsingBuilderCommand());
            if (this.isUsingBuilderCommand()) {
                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, this.builderCommand.toString());
                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, this.builderArguments);
            } else {
                String bldLine = this.getBuildLine();
                int start = 0;
                int end = -1;
                if (!bldLine.startsWith("\"")) {
                    end = bldLine.indexOf(32);
                } else {
                    start = 1;
                    end = bldLine.indexOf(34, 1);
                }
                Path path = end == -1 ? new Path(bldLine) : new Path(bldLine.substring(start, end));
                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, path.toString());
                String args = "";
                if (end != -1) {
                    args = bldLine.substring(end + 1);
                }
                target.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, args);
            }
            target.setBuildAttribute(IMakeTarget.BUILD_TARGET, this.getTarget());
            if (this.fTarget == null || !MakeCorePlugin.getDefault().getTargetManager().targetExists(this.fTarget)) {
                this.fTargetManager.addTarget(this.fContainer, target);
            }
        }
        catch (CoreException e) {
            MakeUIPlugin.errorDialog(this.getShell(), MakeUIPlugin.getResourceString("MakeTargetDialog.exception.makeTargetError"), MakeUIPlugin.getResourceString("MakeTargetDialog.exception.errorAddingTarget"), e);
        }
        super.okPressed();
    }

    private class UpdateStatusLineListener
    implements Listener {
        private UpdateStatusLineListener() {
        }

        private void setStatusLine() {
            MakeTargetDialog.this.fStatusLine.setErrorMessage(null);
            String newTargetName = MakeTargetDialog.this.targetNameText.getText().trim();
            if (newTargetName.length() == 0) {
                MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.mustSpecifyName"));
            } else if (MakeTargetDialog.this.commandText.isEnabled() && MakeTargetDialog.this.commandText.getText().trim().length() == 0) {
                MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.mustSpecifyBuildCommand"));
            } else {
                try {
                    if (!newTargetName.equals(MakeTargetDialog.this.targetName) && MakeTargetDialog.this.fTargetManager.findTarget(MakeTargetDialog.this.fContainer, newTargetName) != null) {
                        MakeTargetDialog.this.fStatusLine.setErrorMessage(MakeUIPlugin.getResourceString("MakeTargetDialog.message.targetWithNameExists"));
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }

        public void handleEvent(Event e) {
            this.setStatusLine();
            MakeTargetDialog.this.updateButtons();
        }
    }
}

