/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.core.commands;

import com.cthing.cmakeed.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class CMakeCommand {
    private String name;
    private String description;
    private boolean deprecated;
    private List<String> usages;

    public CMakeCommand(String name, String description, boolean deprecated) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("name cannot be blank.");
        }
        if (StringUtils.isBlank(description)) {
            throw new IllegalArgumentException("description cannot be blank.");
        }
        this.name = name;
        this.description = description;
        this.deprecated = deprecated;
        this.usages = new ArrayList<String>();
    }

    public void addUsage(String usage) {
        if (StringUtils.isBlank(usage)) {
            throw new IllegalArgumentException("usage cannot be blank.");
        }
        this.usages.add(usage);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getUsages() {
        return this.usages.toArray(new String[this.usages.size()]);
    }

    public String toString() {
        return String.valueOf(this.name) + ": " + this.description;
    }

    public int hashCode() {
        return 31 + (this.name == null ? 0 : this.name.toLowerCase().hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CMakeCommand other = (CMakeCommand)obj;
        return !(this.name == null ? other.name != null : !this.name.toLowerCase().equals(other.name.toLowerCase()));
    }
}

