/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.system.activityArchitecture;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulerType implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    FIFO(1, "FIFO", "FIFO"),
    RR(2, "RR", "RR");

    public static final int DEFAULT_VALUE = 0;
    public static final int FIFO_VALUE = 1;
    public static final int RR_VALUE = 2;
    private static final SchedulerType[] VALUES_ARRAY;
    public static final List<SchedulerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulerType[]{DEFAULT, FIFO, RR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulerType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return FIFO;
            }
            case 2: {
                return RR;
            }
        }
        return null;
    }

    private SchedulerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

