/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.dialect.NotYetOpenedDiagramAdapter;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.MappingBasedDiagramContentDuplicationSwitch;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.MappingBasedSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.part.DiagramEditPartService;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.diagram.util.MappingBasedSiriusFormatManagerFactoryHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MappingBasedSiriusFormatManagerFactory {
    protected static final MappingBasedSiriusFormatManagerFactory INSTANCE = new MappingBasedSiriusFormatManagerFactory();
    protected MappingBasedDiagramContentDuplicationSwitch diagramContentDuplicationSwitch;
    protected MappingBasedSiriusFormatDataManager formatDataManager;
    protected Map<Node, Node> sourceToTargetNoteMap;
    protected boolean isAppliedOnSequenceDiagram;

    public static MappingBasedSiriusFormatManagerFactory getInstance() {
        return INSTANCE;
    }

    public DDiagram applyFormatOnDiagram(Session sourceSession, DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession, DDiagram targetDiagram, boolean copyNotes) {
        this.checkApplyFormatOnDiagramCallCorrection(sourceDiagram, correspondenceMap, targetDiagram, sourceSession, targetSession);
        this.applyFormatAccordingToMap(sourceSession, sourceDiagram, correspondenceMap, targetSession, targetDiagram, copyNotes);
        return targetDiagram;
    }

    public DDiagram applyFormatOnNewDiagram(Session sourceSession, DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession, String targetDiagramName, EObject targetDiagramRoot, boolean copyNotes) {
        this.checkApplyFormatOnNewDiagramCallCorrection(sourceDiagram, correspondenceMap, targetDiagramName, sourceSession, targetSession, targetDiagramRoot);
        DSemanticDiagram targetDiagram = this.createRepresentation(sourceDiagram, targetSession, targetDiagramName, targetDiagramRoot);
        if (targetDiagram != null) {
            this.applyFormatAccordingToMap(sourceSession, sourceDiagram, correspondenceMap, targetSession, (DDiagram)targetDiagram, copyNotes);
            return targetDiagram;
        }
        return null;
    }

    private void applyFormatAccordingToMap(Session sourceSession, DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, Session targetSession, DDiagram targetDiagram, boolean copyNotes) {
        this.diagramContentDuplicationSwitch = new MappingBasedDiagramContentDuplicationSwitch((DSemanticDiagram)targetDiagram, correspondenceMap, targetSession);
        this.diagramContentDuplicationSwitch.doSwitch((EObject)sourceDiagram);
        DiagramEditPart sourceDiagramEditPart = null;
        DiagramEditPart targetDiagramEditPart = null;
        try {
            Collection<DiagramEditPart> sourceDiagramEditParts = this.getDiagramEditPart(sourceSession, (DRepresentation)sourceDiagram);
            Collection<DiagramEditPart> targetDiagramEditParts = this.getDiagramEditPart(targetSession, (DRepresentation)targetDiagram);
            if (!sourceDiagramEditParts.isEmpty() && !targetDiagramEditParts.isEmpty()) {
                sourceDiagramEditPart = sourceDiagramEditParts.stream().findFirst().get();
                targetDiagramEditPart = targetDiagramEditParts.stream().findFirst().get();
                this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram, targetDiagramEditPart);
                this.applyFormatOnDiagram(sourceDiagramEditPart, correspondenceMap, targetDiagramEditPart);
                this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram, targetDiagramEditPart);
                if (copyNotes) {
                    this.copyNotes(sourceDiagram, targetDiagram, targetSession);
                }
                MappingBasedSiriusFormatManagerFactoryHelper.applyNodeDepthPositions(sourceDiagram, targetDiagram, copyNotes, this.diagramContentDuplicationSwitch, this.sourceToTargetNoteMap);
                this.applyFiltersAndLayersState(sourceDiagram, targetDiagram);
                this.synchronizeTargetDiagram(targetSession, (DSemanticDiagram)targetDiagram, targetDiagramEditPart);
            }
        }
        finally {
            this.cleanAndDispose(sourceDiagramEditPart);
            this.cleanAndDispose(targetDiagramEditPart);
        }
    }

    private void applyFiltersAndLayersState(DDiagram sourceDiagram, DDiagram targetDiagram) {
        DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility(targetDiagram);
        sourceDiagram.getActivatedLayers().forEach(layer -> targetDiagram.getActivatedLayers().add(layer));
        targetDiagram.getActivatedFilters().clear();
        targetDiagram.getActivatedFilters().addAll((Collection)sourceDiagram.getActivatedFilters());
        if (targetDiagram.getActivatedFilters().size() != 0) {
            CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(targetDiagram);
            builder.computeCompositeFilterApplications();
        }
        DialectManager.INSTANCE.refresh((DRepresentation)targetDiagram, (IProgressMonitor)new NullProgressMonitor());
        if (DisplayMode.NORMAL.equals((Object)DisplayServiceManager.INSTANCE.getMode())) {
            DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility(targetDiagram);
        }
    }

    private void checkApplyFormatOnDiagramCallCorrection(DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, DDiagram targetDiagram, Session sourceSession, Session targetSession) {
        this.checkDiagram(sourceDiagram);
        this.checkDiagram(targetDiagram);
        this.checkSourceDiagramVSTargetDiagram(sourceDiagram, targetDiagram);
        this.checkSourceAndTargetSessions(sourceSession, targetSession);
        this.isAppliedOnSequenceDiagram = this.computeIsSequenceDiagram(sourceDiagram);
        this.checkMapSourceCorrection(sourceDiagram, correspondenceMap);
    }

    private void checkDiagram(DDiagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorDiagramIsNull);
        }
    }

    private void checkSourceDiagramVSTargetDiagram(DDiagram sourceDiagram, DDiagram targetDiagram) {
        if (sourceDiagram.equals(targetDiagram)) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorSourceAndTargetDiagramsAreTheSame);
        }
        if (!sourceDiagram.getDescription().equals(targetDiagram.getDescription())) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ErrorSourceAndTargetDiagramDecriptionsDoesNotMatch, sourceDiagram.getDescription(), targetDiagram.getDescription()));
        }
    }

    private void checkSourceAndTargetSessions(Session sourceSession, Session targetSession) {
        if (sourceSession == null || targetSession == null) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorSourceAndOrTargetSessionsNull);
        }
    }

    private void checkApplyFormatOnNewDiagramCallCorrection(DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap, String targetDiagramName, Session sourceSession, Session targetSession, EObject targetDiagramRoot) {
        this.checkDiagram(sourceDiagram);
        if (targetDiagramName == null || targetDiagramName.isEmpty()) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorTargetDiagramNameIsEmpty);
        }
        if (targetDiagramRoot == null) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorTargetDiagramRootIsNull);
        }
        this.checkSourceAndTargetSessions(sourceSession, targetSession);
        this.isAppliedOnSequenceDiagram = this.computeIsSequenceDiagram(sourceDiagram);
        this.checkMapSourceCorrection(sourceDiagram, correspondenceMap);
    }

    private void checkMapSourceCorrection(DDiagram sourceDiagram, Map<EObject, EObject> correspondenceMap) {
        if (correspondenceMap.isEmpty()) {
            throw new IllegalArgumentException(Messages.MappingBasedSiriusFormatManagerFactory_ErrorMappingfunctionIsEmpty);
        }
        if (this.isAppliedOnSequenceDiagram) {
            List allSourceDiagramSemanticElements = sourceDiagram.getDiagramElements().stream().map(DSemanticDecorator::getTarget).collect(Collectors.toList());
            boolean contains = correspondenceMap.keySet().containsAll(allSourceDiagramSemanticElements);
            if (!contains) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ErrorMappingfunctionIncompleteOnSequenceDiagram, sourceDiagram));
            }
        }
    }

    private void synchronizeTargetDiagram(Session targetSession, DSemanticDiagram targetDiagram, DiagramEditPart targetDiagramEditPart) {
        Set<View> set2;
        DiagramCreationUtil targetDiagramUtil = new DiagramCreationUtil((DDiagram)targetDiagram);
        if (!targetDiagramUtil.findAssociatedGMFDiagram()) {
            targetDiagramUtil.createNewGMFDiagram();
        }
        Diagram targetGMFDiagram = targetDiagramUtil.getAssociatedGMFDiagram();
        CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(targetGMFDiagram);
        canonicalSynchronizer.storeViewsToArrange(false);
        canonicalSynchronizer.synchronize();
        targetSession.getRefreshEditorsListener().setForceRefresh(true);
        targetSession.getRefreshEditorsListener().addRepresentationToForceRefresh((DRepresentation)targetDiagram);
        Map<Diagram, Set<View>> viewToArrangeCenter = SiriusLayoutDataManager.INSTANCE.getCreatedViewWithCenterLayout();
        Map<Diagram, Set<View>> viewToArrange = SiriusLayoutDataManager.INSTANCE.getCreatedViewsToLayout();
        Diagram diagramView = targetDiagramEditPart.getDiagramView();
        Set<View> set = viewToArrange.get(diagramView);
        if (set != null) {
            set.clear();
        }
        if ((set2 = viewToArrangeCenter.get(diagramView)) != null) {
            set2.clear();
        }
    }

    private DSemanticDiagram createRepresentation(DDiagram sourceDiagram, Session targetSession, String targetDiagramName, EObject targetDiagramRoot) {
        Collection selectedViewpoints = targetSession.getSelectedViewpoints(true);
        Collection descs = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, targetDiagramRoot);
        DRepresentation targetRepresentation = null;
        String sourceDescName = sourceDiagram.getDescription().getName();
        Optional<RepresentationDescription> optDesc = descs.stream().filter(desc -> desc.getName().equals(sourceDescName)).findFirst();
        if (optDesc.isPresent()) {
            targetRepresentation = DialectManager.INSTANCE.createRepresentation(targetDiagramName, targetDiagramRoot, optDesc.get(), targetSession, (IProgressMonitor)new NullProgressMonitor());
            DSemanticDiagram targetDiagram = (DSemanticDiagram)targetRepresentation;
            if (targetDiagram.eAdapters().contains((Object)NotYetOpenedDiagramAdapter.INSTANCE)) {
                targetDiagram.eAdapters().remove((Object)NotYetOpenedDiagramAdapter.INSTANCE);
            }
            return targetDiagram;
        }
        DiagramPlugin.getDefault().logError(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToSuitableDescription, descs, sourceDescName, targetSession));
        return null;
    }

    private void applyFormatOnDiagram(DiagramEditPart sourceDiagramEditPart, Map<EObject, EObject> correspondenceMap, DiagramEditPart targetDiagramEditPart) {
        this.formatDataManager = new MappingBasedSiriusFormatDataManager(correspondenceMap);
        this.formatDataManager.storeFormatData((IGraphicalEditPart)sourceDiagramEditPart);
        if (this.isAppliedOnSequenceDiagram) {
            for (Map.Entry<DDiagramElement, DDiagramElement> entry : this.diagramContentDuplicationSwitch.getSourceDDiagramElementToTargetDDiagramElementMap().entrySet()) {
                View sourceGmfView = SiriusGMFHelper.getGmfView(entry.getKey());
                View targetGmfView = SiriusGMFHelper.getGmfView(entry.getValue());
                if (sourceGmfView instanceof Node && targetGmfView instanceof Node) {
                    Node sourceNode = (Node)sourceGmfView;
                    Node targetNode = (Node)targetGmfView;
                    MappingBasedSiriusFormatManagerFactoryHelper.copyNodeLayout(sourceNode, targetNode);
                    this.formatDataManager.copySiriusStyle((DSemanticDecorator)entry.getKey(), (DSemanticDecorator)entry.getValue());
                    this.formatDataManager.copyGMFStyle((View)sourceNode, (View)targetNode);
                    continue;
                }
                if (!(sourceGmfView instanceof Edge) || !(targetGmfView instanceof Edge)) continue;
                Edge sourceEdge = (Edge)sourceGmfView;
                Edge targetEdge = (Edge)targetGmfView;
                MappingBasedSiriusFormatManagerFactoryHelper.copyEdgeLayout(sourceEdge, targetEdge);
                this.formatDataManager.copySiriusStyle((DSemanticDecorator)entry.getKey(), (DSemanticDecorator)entry.getValue());
                this.formatDataManager.copyGMFStyle((View)sourceEdge, (View)targetEdge);
            }
        } else {
            this.formatDataManager.applyFormat((IGraphicalEditPart)targetDiagramEditPart);
        }
    }

    private boolean computeIsSequenceDiagram(DDiagram sourceDiagram) {
        boolean isSequenceDiagram = false;
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(sourceDiagram.getDescription().eClass().getEPackage())) continue;
            isSequenceDiagram = diagramTypeDescriptor.getDiagramDescriptionProvider().requiresNonStandardFormatDataManagers();
            break;
        }
        return isSequenceDiagram;
    }

    private Collection<DiagramEditPart> getDiagramEditPart(Session session, DRepresentation representation) {
        ArrayList<DiagramEditPart> result = new ArrayList<DiagramEditPart>();
        Collection data = session.getServices().getCustomData("GMF_DIAGRAMS", (EObject)representation);
        final Shell shell = new Shell();
        for (EObject dataElement : data) {
            if (!(dataElement instanceof Diagram)) continue;
            Diagram diagram = (Diagram)dataElement;
            DiagramEditPartService tool = new DiagramEditPartService();
            DiagramEditPart diagramEditPart = tool.createDiagramEditPart(diagram, shell, PreferencesHint.USE_DEFAULTS);
            result.add(diagramEditPart);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                shell.dispose();
            }
        });
        return result;
    }

    private void copyNotes(DDiagram sourceDiagram, DDiagram targetDiagram, Session targetSession) {
        Diagram sourceGMFDiagram = MappingBasedSiriusFormatManagerFactoryHelper.getGMFDiagram(sourceDiagram);
        Diagram targetGMFDiagram = MappingBasedSiriusFormatManagerFactoryHelper.getGMFDiagram(targetDiagram);
        Collection<Node> sourceNotes = GMFNotationHelper.getNotes(sourceGMFDiagram);
        sourceNotes.addAll(GMFNotationHelper.getTextNotes(sourceGMFDiagram));
        if (this.sourceToTargetNoteMap == null) {
            this.sourceToTargetNoteMap = new HashMap<Node, Node>();
        }
        this.sourceToTargetNoteMap.clear();
        sourceNotes.forEach(sourceNote -> {
            Node targetNote = null;
            if (ViewType.NOTE.equals(sourceNote.getType())) {
                targetNote = GMFNotationHelper.createNote(targetGMFDiagram, GMFNotationHelper.getNoteDescription(sourceNote));
            } else {
                Object targetParentNode = null;
                targetParentNode = sourceNote.eContainer().equals(sourceGMFDiagram) ? targetGMFDiagram : MappingBasedSiriusFormatManagerFactoryHelper.getTargetDiagramTextNoteContainer(sourceNote, this.diagramContentDuplicationSwitch);
                if (targetParentNode != null) {
                    targetNote = GMFNotationHelper.createTextNote((View)targetParentNode, GMFNotationHelper.getNoteDescription(sourceNote));
                } else {
                    DiagramPlugin.getDefault().logInfo(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToFindTargetTextNoteContainer, sourceNote));
                    return;
                }
            }
            targetNote.setLayoutConstraint((LayoutConstraint)EcoreUtil.copy((EObject)sourceNote.getLayoutConstraint()));
            if (sourceNote.isSetElement()) {
                targetNote.setElement(sourceNote.getElement());
            }
            this.formatDataManager.copyGMFStyle((View)sourceNote, (View)targetNote);
            this.sourceToTargetNoteMap.put((Node)sourceNote, targetNote);
        });
        Collection<Edge> notesAttachments = GMFNotationHelper.getNotesAttachments(sourceGMFDiagram);
        notesAttachments.forEach(attach -> {
            Node nodeAttachment = (Node)attach.getSource();
            Boolean noteIsSource = true;
            if (!GMFNotationHelper.isNote(nodeAttachment) && !GMFNotationHelper.isTextNote(nodeAttachment)) {
                nodeAttachment = (Node)attach.getTarget();
                noteIsSource = false;
            }
            MappingBasedSiriusFormatManagerFactoryHelper.duplicateNoteAttachment(attach, this.sourceToTargetNoteMap.get(nodeAttachment), targetSession, noteIsSource, this.diagramContentDuplicationSwitch, this.sourceToTargetNoteMap, this.formatDataManager);
        });
    }

    private void cleanAndDispose(DiagramEditPart diagramEditPart) {
        diagramEditPart.deactivate();
        diagramEditPart.getViewer().flush();
        diagramEditPart.getViewer().getEditDomain().getCommandStack().flush();
        diagramEditPart.getViewer().getControl().dispose();
        ((DiagramEditDomain)diagramEditPart.getViewer().getEditDomain()).removeViewer(diagramEditPart.getViewer());
    }
}

