/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.builder.CDTProjectHelpers;

public class SmartMDSDManagedBuildConfigurator
implements IManagedBuilderMakefileGenerator {
    public static final String BUILDER_ID = "org.eclipse.smartmdsd.ui.smartmdsd.builder";
    private IProject project = null;
    private IPath buildWorkingDir = null;
    private String buildConfigurationName = "";

    public void generateDependencies() throws CoreException {
        this.regenerateDependencies(false);
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        return this.regenerateMakefiles();
    }

    public IPath getBuildWorkingDir() {
        return this.buildWorkingDir;
    }

    public String getMakefileName() {
        return "Makefile";
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        String generatorFolderName = Activator.getDefault().getPreferenceStore().getString("GeneratorFolderName");
        String buildFolderName = Activator.getDefault().getPreferenceStore().getString("BuildFolderName");
        this.buildWorkingDir = new Path(String.valueOf(generatorFolderName) + '/' + buildFolderName);
        this.buildConfigurationName = info.getConfigurationName();
    }

    public boolean isGeneratedResource(IResource resource) {
        if (resource != null) {
            return resource.isDerived();
        }
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, "", null);
        if (this.project == null) {
            return status;
        }
        String defaultBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
        if (!this.buildConfigurationName.contentEquals(defaultBuildType)) {
            CDTProjectHelpers.setActiveBuildTypeFor(this.project, defaultBuildType);
        }
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, "", null);
    }
}

