/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.deployment;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeploymentActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IResource resource = this.getSelectedResource(workbenchWindow);
        if (resource != null) {
            final IProject project = resource.getProject();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            final ILaunchConfigurationType deploymentLauncher = launchManager.getLaunchConfigurationType("org.eclipse.smartmdsd.ui.launch.deployment");
            Job job = new Job("DeploymentJob"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        String launcherName = String.valueOf(project.getName()) + "Deployment";
                        ILaunchConfigurationWorkingCopy deploymentLauncherConfiguration = deploymentLauncher.newInstance((IContainer)project, launcherName);
                        deploymentLauncherConfiguration.setAttribute("org.eclipse.smartmdsd.ui.launch.deployment.projectName", project.getName());
                        deploymentLauncherConfiguration.launch("run", monitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            System.out.println("Skip deployment-action, beacause a project could not be derived from the current selection");
        }
        return null;
    }

    private IResource getSelectedResource(IWorkbenchWindow window) {
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IResource) {
                return (IResource)firstElement;
            }
            if (firstElement instanceof IProjectNature) {
                IProjectNature projNature = (IProjectNature)firstElement;
                return projNature.getProject();
            }
        }
        return null;
    }
}

