/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.behavior.generator.system;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.SkillRealization;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationSlavePort;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.SkillRealizationsRef;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillResult;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class SkillJsonGeneratorImpl
extends AbstractGenerator {
    @Inject
    private DefaultDeclarativeQualifiedNameProvider fqn;

    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)resource.getAllContents()), SystemComponentArchitecture.class);
        for (SystemComponentArchitecture model : _filter) {
            String _name = model.getName();
            String _plus = String.valueOf(_name) + ".skills.json";
            fsa.generateFile(_plus, this.compileJson(model));
        }
    }

    public CharSequence compileJson(SystemComponentArchitecture model) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        EList _components = model.getComponents();
        for (ComponentInstance comp : _components) {
            Iterable _filter = Iterables.filter((Iterable)comp.getComponent().getElements(), CoordinationSlavePort.class);
            for (CoordinationSlavePort slave : _filter) {
                Iterable _filter_1 = Iterables.filter((Iterable)slave.getElements(), SkillRealizationsRef.class);
                for (SkillRealizationsRef skillSet : _filter_1) {
                    _builder.append("[");
                    _builder.newLine();
                    EList _skills = skillSet.getSkillRealizationCoordModuleRef().getSkills();
                    for (SkillRealization skill : _skills) {
                        boolean _notEquals_3;
                        _builder.append("{\"skill\" :");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("{ ");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\"name\" : \"");
                        String _name = skill.getSkillDef().getName();
                        _builder.append(_name, "\t\t");
                        _builder.append("\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\"skill-definition-fqn\" : \"");
                        QualifiedName _fullyQualifiedName = this.fqn.getFullyQualifiedName((EObject)skill.getSkillDef());
                        _builder.append((Object)_fullyQualifiedName, "\t\t");
                        _builder.append("\",");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\"in-attribute\" : {");
                        _builder.newLine();
                        EList _inAttribute = skill.getSkillDef().getInAttribute();
                        for (AttributeDefinition inAttr : _inAttribute) {
                            boolean _notEquals;
                            _builder.append("\t\t\t");
                            _builder.append("\"");
                            String _name_1 = inAttr.getName();
                            _builder.append(_name_1, "\t\t\t");
                            _builder.append("\" : \"");
                            String _typeString = this.getTypeString(inAttr.getType());
                            _builder.append(_typeString, "\t\t\t");
                            _builder.append("\"");
                            AttributeDefinition _last = (AttributeDefinition)IterableExtensions.last((Iterable)skill.getSkillDef().getInAttribute());
                            boolean bl = _notEquals = !Objects.equal((Object)inAttr, (Object)_last);
                            if (_notEquals) {
                                _builder.append(",");
                            }
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t\t");
                        _builder.append("},");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\"out-attribute\" : {");
                        _builder.newLine();
                        EList _outAttribute = skill.getSkillDef().getOutAttribute();
                        for (AttributeDefinition outAttr : _outAttribute) {
                            boolean _notEquals_1;
                            _builder.append("\t\t\t");
                            _builder.append("\"");
                            String _name_2 = outAttr.getName();
                            _builder.append(_name_2, "\t\t\t");
                            _builder.append("\" : \"");
                            String _typeString_1 = this.getTypeString(outAttr.getType());
                            _builder.append(_typeString_1, "\t\t\t");
                            _builder.append("\"");
                            AttributeDefinition _last_1 = (AttributeDefinition)IterableExtensions.last((Iterable)skill.getSkillDef().getOutAttribute());
                            boolean bl = _notEquals_1 = !Objects.equal((Object)outAttr, (Object)_last_1);
                            if (_notEquals_1) {
                                _builder.append(",");
                            }
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t\t");
                        _builder.append("},");
                        _builder.newLine();
                        _builder.append("\t\t");
                        _builder.append("\"results\" : [ ");
                        _builder.newLine();
                        EList _results = skill.getSkillDef().getResults();
                        for (SkillResult result : _results) {
                            boolean _notEquals_2;
                            _builder.append("\t\t\t");
                            _builder.append("{ \"result\" : \"");
                            String _literal = result.getResult().getLiteral();
                            _builder.append(_literal, "\t\t\t");
                            _builder.append("\", \"result-value\" : \"");
                            String _resultValue = result.getResultValue();
                            _builder.append(_resultValue, "\t\t\t");
                            _builder.append("\" }");
                            SkillResult _last_2 = (SkillResult)IterableExtensions.last((Iterable)skill.getSkillDef().getResults());
                            boolean bl = _notEquals_2 = !Objects.equal((Object)result, (Object)_last_2);
                            if (_notEquals_2) {
                                _builder.append(",");
                            }
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t\t");
                        _builder.append("]");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                        _builder.append("}");
                        SkillRealization _last_3 = (SkillRealization)IterableExtensions.last((Iterable)skillSet.getSkillRealizationCoordModuleRef().getSkills());
                        boolean bl = _notEquals_3 = !Objects.equal((Object)skill, (Object)_last_3);
                        if (_notEquals_3) {
                            _builder.append(",");
                        }
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("]");
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public String getTypeString(AbstractAttributeType attrType) {
        if (attrType instanceof PrimitiveType) {
            PRIMITIVE_TYPE_NAME typeName = ((PrimitiveType)attrType).getTypeName();
            boolean _equals = Objects.equal((Object)typeName, (Object)PRIMITIVE_TYPE_NAME.DOUBLE);
            if (_equals) {
                return "Double";
            }
            boolean _equals_1 = Objects.equal((Object)typeName, (Object)PRIMITIVE_TYPE_NAME.FLOAT);
            if (_equals_1) {
                return "Double";
            }
            boolean _equals_2 = Objects.equal((Object)typeName, (Object)PRIMITIVE_TYPE_NAME.STRING);
            if (_equals_2) {
                return "String";
            }
            boolean _equals_3 = Objects.equal((Object)typeName, (Object)PRIMITIVE_TYPE_NAME.BOOLEAN);
            if (_equals_3) {
                return "Bool";
            }
            return "Int";
        }
        return null;
    }
}

