/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.ICommitsProvider;
import org.eclipse.egit.ui.internal.history.RefFilterHelper;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.egit.ui.internal.history.SearchBar;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CommitSelectionDialog
extends TitleAreaDialog {
    private static final int BATCH_SIZE = 256;
    @NonNull
    private final Repository repository;
    private final IResource[] filterResources;
    private CommitGraphTable table;
    private SWTCommitList allCommits;
    private RevFlag highlightFlag;
    private ObjectId commitId;
    private SearchBar searchBar;
    private Label statusLabel;

    public CommitSelectionDialog(Shell parentShell, @NonNull Repository repository) {
        this(parentShell, repository, null);
    }

    public CommitSelectionDialog(Shell parentShell, @NonNull Repository repository, IResource[] filterResources) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.filterResources = filterResources;
    }

    protected Control createDialogArea(Composite parent) {
        Composite searchBarParent = new Composite(parent, 0);
        searchBarParent.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)searchBarParent);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
        UIUtils.hookDisposal((Widget)main, (ResourceManager)resources);
        this.table = new CommitGraphTable(main, null, (ResourceManager)resources, false);
        this.table.getTableView().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitSelectionDialog.this.commitId = null;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    CommitSelectionDialog.this.commitId = ((SWTCommit)((Object)sel.getFirstElement())).getId();
                }
                CommitSelectionDialog.this.getButton(0).setEnabled(CommitSelectionDialog.this.commitId != null);
            }
        });
        this.table.getTableView().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (CommitSelectionDialog.this.getButton(0).isEnabled()) {
                    CommitSelectionDialog.this.buttonPressed(0);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 400).applyTo(this.table.getControl());
        this.allCommits = new SWTCommitList((ResourceManager)resources);
        this.table.getControl().addDisposeListener(e -> this.allCommits.clear());
        this.searchBar = new SearchBar(String.valueOf(CommitSelectionDialog.class.getName()) + ".searchBar", this.table){

            @Override
            protected void showStatus(FindToolbar originator, String text) {
                CommitSelectionDialog.this.statusLabel.setText(text);
                CommitSelectionDialog.this.statusLabel.requestLayout();
            }
        };
        this.searchBar.fill(searchBarParent);
        Composite statusLine = new Composite(parent, 0);
        statusLine.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)statusLine);
        this.statusLabel = new Label(statusLine, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.statusLabel);
        return main;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.CommitSelectionDialog_WindowTitle);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(UIText.CommitSelectionDialog_BuildingCommitListMessage, -1);
                    try {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (SWTWalk currentWalk = new SWTWalk(CommitSelectionDialog.this.repository);){
                                currentWalk.setTreeFilter(CommitSelectionDialog.this.createTreeFilter());
                                currentWalk.sort(RevSort.COMMIT_TIME_DESC, true);
                                currentWalk.sort(RevSort.BOUNDARY, true);
                                CommitSelectionDialog.this.highlightFlag = currentWalk.newFlag("highlight");
                                CommitSelectionDialog.this.allCommits.source((RevWalk)currentWalk);
                                RefFilterHelper helper = new RefFilterHelper(CommitSelectionDialog.this.repository);
                                CommitSelectionDialog.this.markStartAllRefs((RevWalk)currentWalk, helper.getMatchingRefsForSelectedRefFilters());
                                while (true) {
                                    int oldsz = CommitSelectionDialog.this.allCommits.size();
                                    CommitSelectionDialog.this.allCommits.fillTo(oldsz + 256 - 1);
                                    if (monitor.isCanceled() || oldsz == CommitSelectionDialog.this.allCommits.size()) break;
                                    String taskName = MessageFormat.format(UIText.CommitSelectionDialog_FoundCommitsMessage, CommitSelectionDialog.this.allCommits.size());
                                    monitor.setTaskName(taskName);
                                }
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                CommitSelectionDialog.this.getShell().getDisplay().asyncExec(() -> CommitSelectionDialog.access$10(CommitSelectionDialog.this));
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(e.getCause().getMessage());
        }
        catch (InterruptedException e) {
            this.setMessage(UIText.CommitSelectionDialog_IncompleteListMessage, 2);
        }
    }

    public ObjectId getCommitId() {
        return this.commitId;
    }

    private void updateUi() {
        this.setTitle(MessageFormat.format(UIText.CommitSelectionDialog_DialogTitle, this.allCommits.size(), GitLabels.getPlainShortLabel(this.repository)));
        this.setMessage(UIText.CommitSelectionDialog_DialogMessage);
        final SWTCommit[] allCommitsArray = (SWTCommit[])this.allCommits.toArray((Object[])new SWTCommit[0]);
        this.table.setInput(this.highlightFlag, this.allCommits, allCommitsArray, null, true);
        this.searchBar.setInput(new ICommitsProvider(){

            @Override
            public Object getSearchContext() {
                return null;
            }

            @Override
            public SWTCommit[] getCommits() {
                return allCommitsArray;
            }

            @Override
            public RevFlag getHighlight() {
                return CommitSelectionDialog.this.highlightFlag;
            }
        });
    }

    private void markStartAllRefs(RevWalk walk, Set<Ref> refs) throws IncorrectObjectTypeException, IOException {
        for (Ref ref : refs) {
            this.markStart(walk, ref.getLeaf().getObjectId());
        }
        Ref head = this.repository.exactRef("HEAD");
        if (head != null) {
            this.markStart(walk, head.getLeaf().getObjectId());
        }
    }

    private void markStart(RevWalk walk, ObjectId id) throws IncorrectObjectTypeException, IOException {
        try {
            RevObject peeled = walk.peel(walk.parseAny((AnyObjectId)id));
            if (peeled instanceof RevCommit) {
                walk.markStart((RevCommit)peeled);
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private TreeFilter createTreeFilter() {
        if (this.filterResources == null) {
            return TreeFilter.ALL;
        }
        ArrayList<Object> filters = new ArrayList<Object>();
        IResource[] iResourceArray = this.filterResources;
        int n = this.filterResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null) {
                DiffConfig diffConfig = (DiffConfig)mapping.getRepository().getConfig().get(DiffConfig.KEY);
                String path = mapping.getRepoRelativePath(resource);
                if (path != null && !path.isEmpty()) {
                    if (resource.getType() == 1) {
                        filters.add(FollowFilter.create((String)path, (DiffConfig)diffConfig));
                    } else {
                        filters.add(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
                    }
                }
            }
            ++n2;
        }
        if (filters.isEmpty()) {
            return TreeFilter.ALL;
        }
        if (filters.size() == 1) {
            return (TreeFilter)filters.get(0);
        }
        return OrTreeFilter.create(filters);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.HistoryCommitSelectionDialog_ButtonOK, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    static /* synthetic */ void access$10(CommitSelectionDialog commitSelectionDialog) {
        commitSelectionDialog.updateUi();
    }
}

