/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.internal.ui.editor.CDOLobEditorInput;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CDOLobStorage
extends AbstractDocumentProvider {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static CDOLobStorage instance;

    public CDOLobStorage() {
        instance = this;
    }

    private CDOLobStorage(boolean dummy) {
    }

    protected IDocument createDocument(Object element) throws CoreException {
        if (element instanceof CDOLobEditorInput) {
            CDOResourceLeaf resource = ((CDOLobEditorInput)((Object)element)).getResource();
            String contents = this.getContents(resource);
            Document document = new Document();
            document.set(contents);
            return document;
        }
        return null;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    public boolean isReadOnly(Object element) {
        if (element instanceof CDOLobEditorInput) {
            CDOResourceLeaf resource = ((CDOLobEditorInput)((Object)element)).getResource();
            return resource.cdoView().isReadOnly();
        }
        return super.isReadOnly(element);
    }

    public boolean isModifiable(Object element) {
        return !this.isReadOnly(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof CDOLobEditorInput) {
            CDOLobEditorInput editorInput = (CDOLobEditorInput)((Object)element);
            CDOResourceLeaf resource = editorInput.getResource();
            String contents = document.get();
            try {
                CDOView view;
                if (resource instanceof CDOTextResource) {
                    CDOTextResource textResource = (CDOTextResource)resource;
                    CDOClob clob = new CDOClob((Reader)new CharArrayReader(contents.toCharArray()));
                    textResource.setContents(clob);
                } else if (resource instanceof CDOBinaryResource) {
                    byte[] bytes = contents.getBytes(this.getDefaultEncoding());
                    CDOBlob blob = new CDOBlob((InputStream)new ByteArrayInputStream(bytes));
                    ((CDOBinaryResource)resource).setContents(blob);
                }
                if (editorInput.isCommitOnSave() && (view = resource.cdoView()) instanceof CDOTransaction) {
                    CDOTransaction transaction = (CDOTransaction)view;
                    transaction.commit();
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getContents(CDOResourceLeaf resource) {
        try {
            if (resource instanceof CDOTextResource) {
                CDOTextResource textResource = (CDOTextResource)resource;
                CDOClob clob = textResource.getContents();
                if (clob == null) {
                    return "";
                }
                Reader reader = null;
                try {
                    reader = clob.getContents();
                    CharArrayWriter writer = new CharArrayWriter();
                    IOUtil.copyCharacter((Reader)reader, (Writer)writer);
                    String string = writer.toString();
                    return string;
                }
                finally {
                    IOUtil.close((Closeable)reader);
                }
            }
            if (!(resource instanceof CDOBinaryResource)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ((CDOResource)resource).save((OutputStream)outputStream, null);
                return new String(outputStream.toByteArray(), this.getDefaultEncoding());
            }
            CDOBlob blob = ((CDOBinaryResource)resource).getContents();
            if (blob == null) {
                return "";
            }
            InputStream inputStream = null;
            try {
                inputStream = blob.getContents();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                String string = new String(outputStream.toByteArray(), this.getDefaultEncoding());
                return string;
            }
            finally {
                IOUtil.close((Closeable)inputStream);
            }
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private String getDefaultEncoding() {
        String encoding = CHARSET_UTF_8;
        try {
            encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return encoding;
    }

    public static IDocumentProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        return new CDOLobStorage(true);
    }
}

