/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * headed by Prof. Dr. Christian Schlegel
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.system.targetPlatform;

import org.eclipse.smartmdsd.ecore.system.targetPlatform.NetworkInterface;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformDefinition;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformFactory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformModel;

@SuppressWarnings("all")
public class TargetPlatformUtility {
  public static TargetPlatformDefinition addDefaultLocalhostTarget(final TargetPlatformModel model) {
    final TargetPlatformDefinition targetPlatformDef = TargetPlatformFactory.eINSTANCE.createTargetPlatformDefinition();
    targetPlatformDef.setName("LocalhostTarget");
    final NetworkInterface ni = TargetPlatformFactory.eINSTANCE.createNetworkInterface();
    ni.setName("localhost");
    ni.setHostAddress("127.0.0.1");
    targetPlatformDef.getElements().add(ni);
    model.getElements().add(targetPlatformDef);
    return targetPlatformDef;
  }
}
