/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentPortDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu.ComponentParametersDocu;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu.HtmlTableHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ComponentDocuGenerator2Impl
extends AbstractGenerator {
    @Inject
    @Extension
    private ComponentParametersDocu _componentParametersDocu;
    @Inject
    @Extension
    private HtmlTableHelpers _htmlTableHelpers;

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable _filter = Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)input.getAllContents()), ComponentDatasheet.class);
        for (ComponentDatasheet datasheet : _filter) {
            fsa.generateFile("README.md", "SRC_GEN_DOCU", this.compileDocu(datasheet));
        }
    }

    public CharSequence getDatasheetPropertyTableHeader() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _tableHeaderBegin = this._htmlTableHelpers.getTableHeaderBegin();
        _builder.append((Object)_tableHeaderBegin);
        _builder.newLineIfNotEmpty();
        CharSequence _asTableHeaderCell = this._htmlTableHelpers.getAsTableHeaderCell("Property Name");
        _builder.append((Object)_asTableHeaderCell);
        _builder.newLineIfNotEmpty();
        CharSequence _asTableHeaderCell_1 = this._htmlTableHelpers.getAsTableHeaderCell("Property Value");
        _builder.append((Object)_asTableHeaderCell_1);
        _builder.newLineIfNotEmpty();
        CharSequence _asTableHeaderCell_2 = this._htmlTableHelpers.getAsTableHeaderCell("Property Description");
        _builder.append((Object)_asTableHeaderCell_2);
        _builder.newLineIfNotEmpty();
        CharSequence _tableHeaderEnd = this._htmlTableHelpers.getTableHeaderEnd();
        _builder.append((Object)_tableHeaderEnd);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getTableRow(DatasheetProperty property) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<tr>");
        _builder.newLine();
        CharSequence _asTableCell = this._htmlTableHelpers.getAsTableCell(property.getName());
        _builder.append((Object)_asTableCell);
        _builder.newLineIfNotEmpty();
        String _unit = property.getUnit();
        boolean bl = _tripleNotEquals = _unit != null;
        if (_tripleNotEquals) {
            String _value = property.getValue();
            String _plus = String.valueOf(_value) + " ";
            String _unit_1 = property.getUnit();
            String _plus_1 = String.valueOf(_plus) + _unit_1;
            CharSequence _asTableCell_1 = this._htmlTableHelpers.getAsTableCell(_plus_1);
            _builder.append((Object)_asTableCell_1);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _asTableCell_2 = this._htmlTableHelpers.getAsTableCell(property.getValue());
            _builder.append((Object)_asTableCell_2);
            _builder.newLineIfNotEmpty();
        }
        String _semanticID = property.getSemanticID();
        boolean bl2 = _tripleNotEquals_1 = _semanticID != null;
        if (_tripleNotEquals_1) {
            CharSequence _asTableCell_3 = this._htmlTableHelpers.getAsTableCell(property.getSemanticID());
            _builder.append((Object)_asTableCell_3);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _asTableCell_4 = this._htmlTableHelpers.getAsTableCell(property.getShortDescription());
            _builder.append((Object)_asTableCell_4);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("</tr>");
        _builder.newLine();
        return _builder;
    }

    public String getShortDescription(ComponentDatasheet datasheet) {
        Functions.Function1 _function = it -> it.getName().equals((Object)MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
        MandatoryDatasheetElement decription = (MandatoryDatasheetElement)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)datasheet.getElements(), MandatoryDatasheetElement.class), (Functions.Function1)_function);
        if (decription != null) {
            return decription.getValue();
        }
        return "";
    }

    public CharSequence compileDocu(ComponentDatasheet datasheet) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!--- This file is generated from the ");
        String _name = datasheet.getComponent().getName();
        _builder.append(_name);
        _builder.append(".componentDocumentation model --->");
        _builder.newLineIfNotEmpty();
        _builder.append("<!--- do not modify this file manually as it will by automatically overwritten by the code generator, modify the model instead and re-generate this file --->");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# ");
        String _name_1 = datasheet.getComponent().getName();
        _builder.append(_name_1);
        _builder.append(" Component");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("<img src=\"model/");
        String _name_2 = datasheet.getComponent().getName();
        _builder.append(_name_2);
        _builder.append("ComponentDefinition.jpg\" alt=\"");
        String _name_3 = datasheet.getComponent().getName();
        _builder.append(_name_3);
        _builder.append("-ComponentImage\" width=\"1000\">");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("*Component Short Description:* ");
        String _shortDescription = this.getShortDescription(datasheet);
        _builder.append(_shortDescription);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        if (datasheet.getComponent() != null && datasheet.getComponent().getDocumentation() != null) {
            _builder.append("## Component Documentation");
            _builder.newLine();
            String _multilineHtmlDocumentation = datasheet.getComponent().getMultilineHtmlDocumentation();
            _builder.append(_multilineHtmlDocumentation);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("## Component-Datasheet Properties");
        _builder.newLine();
        _builder.newLine();
        CharSequence _tableBegin = this._htmlTableHelpers.getTableBegin();
        _builder.append((Object)_tableBegin);
        _builder.newLineIfNotEmpty();
        CharSequence _asTableCaption = this._htmlTableHelpers.getAsTableCaption("Component-Datasheet Properties");
        _builder.append((Object)_asTableCaption);
        _builder.newLineIfNotEmpty();
        CharSequence _datasheetPropertyTableHeader = this.getDatasheetPropertyTableHeader();
        _builder.append((Object)_datasheetPropertyTableHeader);
        _builder.newLineIfNotEmpty();
        Iterable _filter = Iterables.filter((Iterable)datasheet.getElements(), DatasheetProperty.class);
        for (DatasheetProperty property : _filter) {
            CharSequence _tableRow = this.getTableRow(property);
            _builder.append((Object)_tableRow);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _tableEnd = this._htmlTableHelpers.getTableEnd();
        _builder.append((Object)_tableEnd);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("## Component Ports");
        _builder.newLine();
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter((Iterable)datasheet.getComponent().getElements(), ComponentPort.class);
        for (ComponentPort port : _filter_1) {
            _builder.append("### ");
            String _name_4 = port.getName();
            _builder.append(_name_4);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("*Documentation:*");
            _builder.newLine();
            String _multilineHtmlDocumentation_1 = port.getMultilineHtmlDocumentation();
            _builder.append(_multilineHtmlDocumentation_1);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            Functions.Function1 _function = it -> {
                ComponentPort _port = it.getPort();
                return Objects.equal((Object)_port, (Object)port);
            };
            Iterable _filter_2 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)datasheet.getElements(), ComponentPortDatasheet.class), (Functions.Function1)_function);
            for (ComponentPortDatasheet port_ds : _filter_2) {
                boolean _greaterThan;
                int _size = port_ds.getProperties().size();
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                CharSequence _tableBegin_1 = this._htmlTableHelpers.getTableBegin();
                _builder.append((Object)_tableBegin_1);
                _builder.newLineIfNotEmpty();
                String _name_5 = port.getName();
                String _plus = "Datasheet Properties of Component-Port <b>" + _name_5;
                CharSequence _asTableCaption_1 = this._htmlTableHelpers.getAsTableCaption(String.valueOf(_plus) + "</b>");
                _builder.append((Object)_asTableCaption_1);
                _builder.newLineIfNotEmpty();
                CharSequence _datasheetPropertyTableHeader_1 = this.getDatasheetPropertyTableHeader();
                _builder.append((Object)_datasheetPropertyTableHeader_1);
                _builder.newLineIfNotEmpty();
                EList _properties = port_ds.getProperties();
                for (DatasheetProperty property_1 : _properties) {
                    CharSequence _tableRow_1 = this.getTableRow(property_1);
                    _builder.append((Object)_tableRow_1);
                    _builder.newLineIfNotEmpty();
                }
                CharSequence _tableEnd_1 = this._htmlTableHelpers.getTableEnd();
                _builder.append((Object)_tableEnd_1);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        Iterable _filter_3 = Iterables.filter((Iterable)datasheet.getComponent().getElements(), ComponentParametersRef.class);
        for (ComponentParametersRef paramRef : _filter_3) {
            CharSequence _compileComponentParameters = this._componentParametersDocu.compileComponentParameters(paramRef.getParameter());
            _builder.append((Object)_compileComponentParameters);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

